/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.editor.inspectors.jms.header;

import com.eviware.soapui.config.JMSDeliveryModeTypeConfig;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.editor.inspectors.jms.header.AbstractJMSHeaderInspector;
import com.eviware.soapui.support.editor.xml.XmlInspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestJMSHeaderInspector
extends AbstractJMSHeaderInspector
implements XmlInspector,
PropertyChangeListener {
    private SimpleBindingForm simpleform;
    AbstractHttpRequest<?> request;

    public RequestJMSHeaderInspector(AbstractHttpRequest<?> request) {
        super(request);
        this.request = request;
        request.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.request.getEndpoint() != null && evt.getPropertyName().equals("endpoint")) {
            this.setEnabled(this.request.getEndpoint().startsWith("jms://"));
        }
    }

    @Override
    public void release() {
        super.release();
        this.request.removePropertyChangeListener(this);
    }

    @Override
    public void buildContent(SimpleBindingForm form) {
        this.simpleform = form;
        this.simpleform.addSpace(5);
        this.simpleform.appendTextField("JMSCorrelationID", "JMSCorrelationID", "JMSCorrelationID header property of JMS message");
        this.simpleform.appendTextField("JMSReplyTo", "JMSReplyTo", "JMSReplyTo header property of JMS message");
        this.simpleform.appendTextField("JMSType", "JMSType", "JMSType header property of JMS message");
        this.simpleform.appendTextField("JMSPriority", "JMSPriority", "JMSPriority header property of JMS message");
        this.simpleform.appendComboBox("JMSDeliveryMode", "JMSDeliveryMode", new String[]{JMSDeliveryModeTypeConfig.PERSISTENT.toString(), JMSDeliveryModeTypeConfig.NON_PERSISTENT.toString()}, "Choose between NON PERSISTENT and PERSISTENT (default) message");
        this.simpleform.appendTextField("timeToLive", "TimeToLive", "specify 'time to live' of JMS message , zero means never expire which is default");
        this.simpleform.appendCheckBox("sendAsBytesMessage", "Send As Bytes Message", "").setToolTipText("if selected message will be sent as BytesMessage");
        if (this.request.getOperation() != null) {
            this.simpleform.appendCheckBox("soapActionAdd", "Add SoapAction as property", "").setToolTipText("Add properties SOAPJMS_soapAction=" + this.request.getOperation().getName() + "\n and " + "SoapAction=" + this.request.getOperation().getName() + " to outgoing message");
        }
        this.simpleform.appendTextField("durableSubscriptionName", "Durable Subscription Name", "specify 'Durable Subscription Name' for subscribing to topic , if not specified automatic name is 'durableSubscription' + 'topic name'");
        this.simpleform.appendTextField("clientID", "ClientID", "specify optional 'ClientID' for of JMS connection");
        this.simpleform.appendTextField("messageSelector", "Message Selector", "specify message selector string to determine which messages you want to receive");
        this.simpleform.addSpace(5);
    }
}

