/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.BrowserComponent;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.xml.XmlUtils;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserFactory;
import com.teamdev.jxbrowser.Configurable;
import com.teamdev.jxbrowser.Feature;
import com.teamdev.jxbrowser.events.NavigationAdapter;
import com.teamdev.jxbrowser.events.NavigationFinishedEvent;
import com.teamdev.jxbrowser.events.NavigationListener;
import com.teamdev.jxbrowser.events.NavigationStatusCode;
import com.teamdev.jxbrowser.events.StatusChangedEvent;
import com.teamdev.jxbrowser.events.StatusListener;
import com.teamdev.jxbrowser.prompt.DefaultPromptService;
import com.teamdev.jxbrowser.prompt.PromptService;
import com.teamdev.jxbrowser.security.HttpSecurityAction;
import com.teamdev.jxbrowser.security.HttpSecurityHandler;
import com.teamdev.jxbrowser.security.SecurityProblem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.mozilla.interfaces.nsIHttpChannel;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIURI;
import org.mozilla.interfaces.nsIWeakReference;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIWebProgressListener;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class NativeBrowserComponent
implements nsIWebProgressListener,
nsIWeakReference,
StatusListener {
    private Browser browser;
    private JPanel panel = new JPanel(new BorderLayout());
    private JPanel statusBar;
    private JLabel statusLabel;
    private String errorPage;
    private boolean showingErrorPage;
    public String url;
    private Boolean possibleError = false;
    private final boolean addStatusBar;
    private InternalNavigationAdapter internalNavigationAdapter;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    public static final String EVENT_HTTP_ON_MODIFY_REQUEST = "http-on-modify-request";
    private InternalHttpSecurityHandler internalHttpSecurityHandler;

    public NativeBrowserComponent(boolean addToolbar, boolean addStatusBar) {
        this.addStatusBar = addStatusBar;
    }

    public Component getComponent() {
        if (SoapUI.isJXBrowserDisabled(true)) {
            JEditorPane jxbrowserDisabledPanel = new JEditorPane();
            jxbrowserDisabledPanel.setText("browser component disabled or not available on this platform");
            this.panel.add(jxbrowserDisabledPanel);
        } else if (this.browser == null) {
            if (this.addStatusBar) {
                this.statusBar = new JPanel(new BorderLayout());
                this.statusLabel = new JLabel();
                UISupport.setFixedSize(this.statusBar, new Dimension(20, 20));
                this.statusBar.add((Component)this.statusLabel, "West");
                this.panel.add((Component)this.statusBar, "South");
            }
            this.initBrowser();
            this.configureBrowser();
            this.browser.navigate("about:blank");
        }
        return this.panel;
    }

    private Component buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.addFixed(UISupport.createToolbarButton(new BackAction()));
        toolbar.addRelatedGap();
        toolbar.addFixed(UISupport.createToolbarButton(new ForwardAction()));
        toolbar.addGlue();
        return toolbar;
    }

    public synchronized boolean initBrowser() {
        if (this.browser != null || SoapUI.isJXBrowserDisabled(true)) {
            return false;
        }
        this.browser = BrowserFactory.createBrowser();
        this.browser.getServices().setPromptService((PromptService)new DefaultPromptService());
        BrowserComponent.initNewWindowManager(this.browser, false);
        this.internalHttpSecurityHandler = new InternalHttpSecurityHandler();
        this.browser.setHttpSecurityHandler((HttpSecurityHandler)this.internalHttpSecurityHandler);
        this.internalNavigationAdapter = new InternalNavigationAdapter();
        this.browser.addNavigationListener((NavigationListener)this.internalNavigationAdapter);
        this.browser.addStatusListener((StatusListener)this);
        this.panel.add(this.browser.getComponent(), "Center");
        return true;
    }

    public void release() {
        if (this.browser != null) {
            this.cleanup();
        }
        this.possibleError = false;
    }

    private synchronized void cleanup() {
        if (this.browser != null) {
            this.browser.stop();
            this.browser.dispose();
            this.browser.setHttpSecurityHandler(null);
            this.browser.removeStatusListener((StatusListener)this);
            this.panel.removeAll();
            this.browser = null;
        }
    }

    private void configureBrowser() {
        if (this.browser != null) {
            Configurable contentSettings = this.browser.getConfigurable();
            if (SoapUI.isJXBrowserPluginsDisabled()) {
                contentSettings.disableFeature(Feature.PLUGINS);
            } else {
                contentSettings.enableFeature(Feature.PLUGINS);
            }
        }
    }

    public void setContent(String contentAsString, String contextUri) {
        if (SoapUI.isJXBrowserDisabled(true)) {
            return;
        }
        if (this.browser == null) {
            this.initBrowser();
        }
        this.configureBrowser();
        try {
            this.browser.setContent(contentAsString, contextUri);
            this.pcs.firePropertyChange("content", null, null);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void setContent(String content) {
        if (SoapUI.isJXBrowserDisabled(true)) {
            return;
        }
        if (this.browser == null) {
            this.initBrowser();
        }
        this.configureBrowser();
        this.browser.setContent(content);
        this.pcs.firePropertyChange("content", null, null);
    }

    public void navigate(String url, String errorPage) {
        this.navigate(url, null, errorPage);
    }

    public String getContent() {
        return this.browser == null ? null : XmlUtils.serialize(this.browser.getDocument());
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) throws InterruptedException, InvocationTargetException {
        this.navigate(url, null);
    }

    public nsISupports queryInterface(String uuid) {
        return Mozilla.queryInterface((nsISupports)this, (String)uuid);
    }

    public nsISupports queryReferent(String uuid) {
        return Mozilla.queryInterface((nsISupports)this, (String)uuid);
    }

    public void onLocationChange(nsIWebProgress arg0, nsIRequest arg1, nsIURI arg2) {
        if (this.getUrl() != null && !this.getUrl().equals("about:blank")) {
            if (!this.possibleError.booleanValue()) {
                this.possibleError = true;
            } else if (!this.showingErrorPage) {
                this.showErrorPage();
            }
        }
    }

    public void onProgressChange(nsIWebProgress arg0, nsIRequest arg1, int arg2, int arg3, int arg4, int arg5) {
    }

    public void onSecurityChange(nsIWebProgress arg0, nsIRequest arg1, long arg2) {
    }

    public void onStateChange(nsIWebProgress arg0, nsIRequest request, long arg2, long arg3) {
        block4: {
            try {
                if (this.getUrl() != null && !this.getUrl().equals("about:blank")) {
                    nsIHttpChannel ch = null;
                    ch = (nsIHttpChannel)request.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
                    if (ch != null) {
                        this.possibleError = false;
                        this.showingErrorPage = false;
                    }
                }
            }
            catch (XPCOMException e) {
                SoapUI.logError(e);
                if (!this.possibleError.booleanValue() || this.showingErrorPage) break block4;
                this.showErrorPage();
            }
        }
    }

    private void showErrorPage() {
        if (this.errorPage != null && !this.errorPage.equals(this.getUrl())) {
            try {
                this.showingErrorPage = true;
                this.setUrl(this.errorPage);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public void onStatusChange(nsIWebProgress arg0, nsIRequest arg1, long arg2, String arg3) {
        block4: {
            try {
                if (this.getUrl() != null && !this.getUrl().equals("about:blank")) {
                    nsIHttpChannel ch = null;
                    ch = (nsIHttpChannel)arg1.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
                    if (ch != null) {
                        this.possibleError = false;
                        this.showingErrorPage = false;
                    }
                }
            }
            catch (XPCOMException e) {
                SoapUI.logError(e);
                if (!this.possibleError.booleanValue() || this.showingErrorPage) break block4;
                this.showErrorPage();
            }
        }
    }

    public void statusChanged(StatusChangedEvent event) {
        if (this.statusLabel != null) {
            this.statusLabel.setText(event.getStatusText());
        }
    }

    public boolean isBrowserInitialised() {
        return this.browser != null;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.addPropertyChangeListener(pcl);
    }

    public void rempvePropertyChangeListener(PropertyChangeListener pcl) {
        this.pcs.removePropertyChangeListener(pcl);
    }

    public static String dumpUri(nsIURI uri) {
        if (uri == null) {
            return "";
        }
        return (uri.getUsername() == null || "".equals(uri.getUsername()) ? "" : uri.getUsername() + ":" + uri.getUserPass()) + uri.getScheme() + "://" + uri.getHost() + (uri.getPort() == -1 ? "" : ":" + uri.getPort()) + uri.getPath();
    }

    public void navigate(String url, String postData, String errorPage) {
        if (SoapUI.isJXBrowserDisabled(true)) {
            return;
        }
        if (errorPage != null) {
            this.setErrorPage(errorPage);
        }
        this.url = url;
        if (this.browser == null) {
            this.initBrowser();
        }
        this.configureBrowser();
        BrowserComponent.updateJXBrowserProxy();
        if (postData != null && postData.length() > 0) {
            this.browser.navigate(url, postData);
        } else {
            this.browser.navigate(url);
        }
        if (this.showingErrorPage) {
            this.showingErrorPage = false;
        }
    }

    private class ForwardAction
    extends AbstractAction {
        public ForwardAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_right.png"));
            this.putValue("ShortDescription", "Navigate to next selection");
        }

        public void actionPerformed(ActionEvent e) {
            if (!NativeBrowserComponent.this.browser.canGoForward()) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                NativeBrowserComponent.this.browser.goForward();
            }
        }
    }

    private class BackAction
    extends AbstractAction {
        public BackAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/arrow_left.png"));
            this.putValue("ShortDescription", "Navigate to previous selection");
        }

        public void actionPerformed(ActionEvent e) {
            if (!NativeBrowserComponent.this.browser.canGoBack()) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                NativeBrowserComponent.this.browser.goBack();
            }
        }
    }

    private final class InternalNavigationAdapter
    extends NavigationAdapter {
        private InternalNavigationAdapter() {
        }

        public void navigationFinished(NavigationFinishedEvent evt) {
            if (evt.getUrl().equals(SoapUI.PUSH_PAGE_URL) && !evt.getStatusCode().equals((Object)NavigationStatusCode.OK)) {
                NativeBrowserComponent.this.browser.navigate(SoapUI.PUSH_PAGE_ERROR_URL);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class InternalHttpSecurityHandler
    implements HttpSecurityHandler {
        private InternalHttpSecurityHandler() {
        }

        public HttpSecurityAction onSecurityProblem(Set<SecurityProblem> arg0) {
            return HttpSecurityAction.CONTINUE;
        }
    }
}

