/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.support.components;

import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;

public class GroovyEditorComponent
extends JPanel
implements PropertyChangeListener {
    private GroovyEditor editor;
    private JButton insertCodeButton;
    private Action runAction;
    private JXToolBar toolBar;
    private final GroovyEditorModel editorModel;
    private final String helpUrl;

    public GroovyEditorComponent(GroovyEditorModel editorModel, String helpUrl) {
        super(new BorderLayout());
        this.editorModel = editorModel;
        this.helpUrl = helpUrl;
        this.editor = new GroovyEditor(editorModel);
        this.editor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), this.editor.getBorder()));
        this.add((Component)this.editor, "Center");
        this.buildToolbar(editorModel, helpUrl);
        editorModel.addPropertyChangeListener(this);
    }

    public GroovyEditor getEditor() {
        return this.editor;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.editor.setEnabled(enabled);
        if (this.runAction != null) {
            this.runAction.setEnabled(enabled);
        }
        this.insertCodeButton.setEnabled(enabled);
    }

    protected void buildToolbar(GroovyEditorModel editorModel, String helpUrl) {
        if (this.toolBar == null) {
            this.toolBar = UISupport.createSmallToolbar();
        } else {
            this.remove(this.toolBar);
            this.toolBar.removeAll();
        }
        this.runAction = editorModel.getRunAction();
        if (this.runAction != null) {
            JButton runButton = UISupport.createToolbarButton(this.runAction);
            if (runButton.getIcon() == null) {
                runButton.setIcon(UISupport.createImageIcon("/run_testcase.gif"));
            }
            if (runButton.getToolTipText() == null) {
                runButton.setToolTipText("Runs this script");
            }
            this.toolBar.add(runButton);
            this.toolBar.addRelatedGap();
        }
        if (this.insertCodeButton == null) {
            this.insertCodeButton = new JButton(new InsertCodeAction());
            this.insertCodeButton.setIcon(UISupport.createImageIcon("/down_arrow.gif"));
            this.insertCodeButton.setHorizontalTextPosition(2);
        }
        this.toolBar.addFixed(this.insertCodeButton);
        this.toolBar.add(Box.createHorizontalGlue());
        String[] args = editorModel.getKeywords();
        if (args != null && args.length > 0) {
            String scriptName = editorModel.getScriptName();
            scriptName = scriptName == null ? "" : scriptName.trim() + " ";
            StringBuilder text = new StringBuilder("<html>" + scriptName + "Script is invoked with ");
            for (int c = 0; c < args.length; ++c) {
                if (c > 0) {
                    text.append(", ");
                }
                text.append("<font face=\"courier\">").append(args[c]).append("</font>");
            }
            text.append(" variables</html>");
            JLabel label = new JLabel(text.toString());
            label.setToolTipText(label.getText());
            label.setMaximumSize(label.getPreferredSize());
            this.toolBar.addFixed(label);
            this.toolBar.addUnrelatedGap();
        }
        if (helpUrl != null) {
            this.toolBar.addFixed(UISupport.createToolbarButton(new ShowOnlineHelpAction(helpUrl)));
        }
        this.add((Component)this.toolBar, "North");
        this.revalidate();
        this.repaint();
    }

    public void release() {
        this.editorModel.removePropertyChangeListener(this);
        this.getEditor().release();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("script")) {
            this.buildToolbar(this.editorModel, this.helpUrl);
        }
    }

    public class InsertCodeAction
    extends AbstractAction {
        public InsertCodeAction() {
            super("Edit");
            this.putValue("ShortDescription", "Inserts code at caret");
        }

        public void actionPerformed(ActionEvent e) {
            JPopupMenu popup = GroovyEditorComponent.this.editor.getEditArea().getComponentPopupMenu();
            popup.show(GroovyEditorComponent.this.insertCodeButton, GroovyEditorComponent.this.insertCodeButton.getWidth() / 2, GroovyEditorComponent.this.insertCodeButton.getHeight() / 2);
        }
    }
}

