/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security.support;

import com.eviware.soapui.config.CheckedParameterConfig;
import com.eviware.soapui.config.CheckedParametersListConfig;
import com.eviware.soapui.model.security.SecurityCheckedParameter;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.security.SecurityScanParameterHolderListener;
import com.eviware.soapui.model.testsuite.TestPropertyListener;
import com.eviware.soapui.security.support.SecurityCheckedParameterImpl;
import com.eviware.soapui.security.support.SecurityScanParameterListenerAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityCheckedParameterHolder
extends SecurityScanParameterListenerAdapter
implements TestPropertyListener {
    private SecurityScan securityCheck;
    private CheckedParametersListConfig paramsConfig;
    private List<SecurityCheckedParameter> params = new ArrayList<SecurityCheckedParameter>();
    private Map<String, SecurityCheckedParameter> paramsMap = new HashMap<String, SecurityCheckedParameter>();
    private Set<SecurityScanParameterHolderListener> listeners = new HashSet<SecurityScanParameterHolderListener>();

    public SecurityCheckedParameterHolder(SecurityScan securityCheck, CheckedParametersListConfig checkedPameters) {
        this.securityCheck = securityCheck;
        this.paramsConfig = checkedPameters;
        for (CheckedParameterConfig param : this.paramsConfig.getParametersList()) {
            this.addParameter(param);
        }
        securityCheck.getTestStep().addTestPropertyListener(this);
    }

    public void addParameterListener(SecurityScanParameterHolderListener listener) {
        this.listeners.add(listener);
    }

    public void removeParameterListener(SecurityScanParameterHolderListener listener) {
        this.listeners.remove(listener);
    }

    public void updateConfig(CheckedParametersListConfig config) {
        this.paramsConfig = config;
        List paramsList = config.getParametersList();
        for (int c = 0; c < paramsList.size(); ++c) {
            if (!(this.params.get(c) instanceof SecurityCheckedParameterImpl)) continue;
            ((SecurityCheckedParameterImpl)this.params.get(c)).setConfig((CheckedParameterConfig)paramsList.get(c));
        }
    }

    SecurityCheckedParameter addParameter(CheckedParameterConfig param) {
        SecurityCheckedParameterImpl result = new SecurityCheckedParameterImpl(param);
        this.params.add(result);
        this.paramsMap.put(result.getLabel().toUpperCase(), result);
        this.fireParameterAdded(result);
        return result;
    }

    public boolean addParameter(String label, String name, String xpath, boolean used) {
        if (this.paramsMap.get(label.toUpperCase()) != null) {
            return false;
        }
        CheckedParameterConfig newParameterConfig = this.paramsConfig.addNewParameters();
        SecurityCheckedParameterImpl newParameter = new SecurityCheckedParameterImpl(newParameterConfig);
        newParameter.setLabel(label);
        newParameter.setName(name);
        newParameter.setXpath(xpath);
        newParameter.setChecked(used);
        this.params.add(newParameter);
        this.paramsMap.put(newParameter.getLabel().toUpperCase(), newParameter);
        this.fireParameterAdded(newParameter);
        return true;
    }

    public void removeParameter(SecurityCheckedParameter parameter) {
        int index = this.params.indexOf(parameter);
        this.params.remove(parameter);
        this.paramsMap.remove(parameter.getLabel().toUpperCase());
        this.paramsConfig.removeParameters(index);
        this.fireParameterRemoved(parameter);
    }

    public void fireParameterAdded(SecurityCheckedParameter parameter) {
        for (SecurityScanParameterHolderListener listener : this.listeners) {
            listener.parameterAdded(parameter);
        }
    }

    public void fireParameterRemoved(SecurityCheckedParameter parameter) {
        for (SecurityScanParameterHolderListener listener : this.listeners) {
            listener.parameterRemoved(parameter);
        }
    }

    public List<SecurityCheckedParameter> getParameterList() {
        return this.params;
    }

    public String[] getParameterLabels() {
        String[] labels = new String[this.params.size()];
        for (int c = 0; c < labels.length; ++c) {
            labels[c] = this.params.get(c).getLabel();
        }
        return labels;
    }

    @Override
    public void parameterLabelChanged(SecurityCheckedParameter parameter, String oldLabel, String newLabel) {
        SecurityCheckedParameter param = this.paramsMap.get(oldLabel);
        this.paramsMap.remove(oldLabel);
        this.paramsMap.put(newLabel, param);
    }

    public SecurityCheckedParameter getParametarByLabel(String paramLabel) {
        for (SecurityCheckedParameter param : this.params) {
            if (!param.getLabel().equals(paramLabel)) continue;
            return param;
        }
        return null;
    }

    public List<SecurityCheckedParameter> getParametarsByName(String paramName) {
        ArrayList<SecurityCheckedParameter> paramsList = new ArrayList<SecurityCheckedParameter>();
        for (SecurityCheckedParameter param : this.params) {
            if (!param.getName().equals(paramName)) continue;
            paramsList.add(param);
        }
        return paramsList;
    }

    public void removeParameters(int[] selected) {
        ArrayList<SecurityCheckedParameter> paramsToRemove = new ArrayList<SecurityCheckedParameter>();
        for (int index : selected) {
            paramsToRemove.add(this.params.get(index));
        }
        for (SecurityCheckedParameter param : paramsToRemove) {
            this.removeParameter(param);
        }
    }

    @Override
    public void propertyAdded(String name) {
    }

    @Override
    public void propertyMoved(String name, int oldIndex, int newIndex) {
    }

    @Override
    public void propertyRemoved(String name) {
        ArrayList<SecurityCheckedParameter> parameterToRemove = new ArrayList<SecurityCheckedParameter>();
        for (SecurityCheckedParameter param : this.params) {
            if (!param.getName().equals(name)) continue;
            parameterToRemove.add(param);
        }
        for (SecurityCheckedParameter param : parameterToRemove) {
            this.removeParameter(param);
        }
    }

    @Override
    public void propertyRenamed(String oldName, String newName) {
        ArrayList<SecurityCheckedParameter> parameterToRemove = new ArrayList<SecurityCheckedParameter>();
        for (SecurityCheckedParameter param : this.params) {
            if (!param.getName().equals(oldName)) continue;
            parameterToRemove.add(param);
        }
        for (SecurityCheckedParameter param : parameterToRemove) {
            ((SecurityCheckedParameterImpl)param).setName(newName);
        }
    }

    @Override
    public void propertyValueChanged(String name, String oldValue, String newValue) {
    }

    public void release() {
        this.securityCheck.getTestStep().removeTestPropertyListener(this);
    }
}

