/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.security;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.wsdl.support.AbstractTestCaseRunner;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepFactory;
import com.eviware.soapui.impl.wsdl.teststeps.registry.WsdlTestStepRegistry;
import com.eviware.soapui.model.security.SecurityScan;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.security.SecurityTestRunContext;
import com.eviware.soapui.security.SecurityTestRunner;
import com.eviware.soapui.security.result.SecurityResult;
import com.eviware.soapui.security.result.SecurityScanResult;
import com.eviware.soapui.security.result.SecurityTestStepResult;
import com.eviware.soapui.security.scan.AbstractSecurityScanWithProperties;
import com.eviware.soapui.security.support.SecurityTestRunListener;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityTestRunnerImpl
extends AbstractTestCaseRunner<SecurityTest, SecurityTestRunContext>
implements SecurityTestRunner {
    private SecurityTest securityTest;
    private SecurityTestRunListener[] securityTestListeners = new SecurityTestRunListener[0];
    private SecurityTestRunListener[] securityTestStepListeners = new SecurityTestRunListener[0];
    private long timeTaken;
    private int currentScanOnSecurityTestIndex;

    public SecurityTestRunnerImpl(SecurityTest test, StringToObjectMap properties) {
        super(test, properties);
        this.securityTest = test;
        this.currentScanOnSecurityTestIndex = 0;
    }

    @Override
    public SecurityTestRunContext createContext(StringToObjectMap properties) {
        return new SecurityTestRunContext(this, properties);
    }

    @Override
    public SecurityTest getSecurityTest() {
        return (SecurityTest)this.getTestRunnable();
    }

    @Override
    public TestStepResult runTestStep(TestStep testStep, boolean discard, boolean process) {
        TestStepResult stepResult = testStep.run(this, (TestCaseRunContext)this.getRunContext());
        this.getResults().add(stepResult);
        this.setResultCount(this.getResultCount() + 1);
        return stepResult;
    }

    public TestStep cloneForSecurityScan(WsdlTestStep sourceTestStep) {
        WsdlTestStep clonedTestStep = null;
        TestStepConfig testStepConfig = (TestStepConfig)((TestStepConfig)sourceTestStep.getConfig()).copy();
        WsdlTestStepFactory factory = WsdlTestStepRegistry.getInstance().getFactory(testStepConfig.getType());
        if (factory != null && (clonedTestStep = factory.buildTestStep(this.securityTest.getTestCase(), testStepConfig, false)) instanceof Assertable) {
            for (TestAssertion assertion : ((Assertable)((Object)clonedTestStep)).getAssertionList()) {
                ((Assertable)((Object)clonedTestStep)).removeAssertion(assertion);
            }
        }
        return clonedTestStep;
    }

    public static TestStep cloneTestStepForSecurityScan(WsdlTestStep sourceTestStep) {
        WsdlTestStep clonedTestStep = null;
        TestStepConfig testStepConfig = (TestStepConfig)((TestStepConfig)sourceTestStep.getConfig()).copy();
        WsdlTestStepFactory factory = WsdlTestStepRegistry.getInstance().getFactory(testStepConfig.getType());
        if (factory != null && (clonedTestStep = factory.buildTestStep(sourceTestStep.getTestCase(), testStepConfig, false)) instanceof Assertable) {
            for (TestAssertion assertion : ((Assertable)((Object)clonedTestStep)).getAssertionList()) {
                ((Assertable)((Object)clonedTestStep)).removeAssertion(assertion);
            }
        }
        return clonedTestStep;
    }

    @Override
    protected int runCurrentTestStep(SecurityTestRunContext runContext, int currentStepIndex) {
        boolean jumpExit = false;
        TestStep currentStep = runContext.getCurrentStep();
        this.securityTestStepListeners = this.securityTest.getTestStepRunListeners(currentStep);
        if (!currentStep.isDisabled() && !this.securityTest.skipTest(currentStep)) {
            int i;
            int i2;
            TestStepResult stepResult = this.runTestStep(currentStep, true, true);
            if (stepResult == null) {
                jumpExit = true;
            }
            SecurityTestStepResult securityStepResult = new SecurityTestStepResult(currentStep, stepResult);
            for (i2 = 0; i2 < this.securityTestListeners.length; ++i2) {
                if (!Arrays.asList(this.getSecurityTest().getSecurityTestRunListeners()).contains(this.securityTestListeners[i2])) continue;
                this.securityTestListeners[i2].afterOriginalStep(this, (SecurityTestRunContext)this.getRunContext(), securityStepResult);
            }
            for (i2 = 0; i2 < this.securityTestListeners.length; ++i2) {
                if (!Arrays.asList(this.getSecurityTest().getSecurityTestRunListeners()).contains(this.securityTestListeners[i2])) continue;
                this.securityTestListeners[i2].beforeStep(this, (SecurityTestRunContext)this.getRunContext(), stepResult);
            }
            for (i2 = 0; i2 < this.securityTestStepListeners.length; ++i2) {
                if (!Arrays.asList(this.getSecurityTest().getSecurityTestRunListeners()).contains(this.securityTestStepListeners[i2])) continue;
                this.securityTestStepListeners[i2].beforeStep(this, (SecurityTestRunContext)this.getRunContext(), stepResult);
            }
            HashMap<String, List<SecurityScan>> secScanMap = this.securityTest.getSecurityScansMap();
            if (secScanMap.containsKey(currentStep.getId())) {
                List testStepScansList = (List)secScanMap.get(currentStep.getId());
                for (int i3 = 0; i3 < testStepScansList.size(); ++i3) {
                    SecurityScanResult securityScanResult;
                    SecurityScan securityScan = (SecurityScan)testStepScansList.get(i3);
                    if (securityScan.isDisabled() || securityScan.isSkipFurtherRunning()) continue;
                    if (stepResult.getStatus() == TestStepResult.TestStepStatus.FAILED && !securityScan.isApplyForFailedStep()) {
                        securityScanResult = new SecurityScanResult(securityScan);
                        if (securityScan.getAssertionCount() > 0) {
                            securityScanResult.setStatus(SecurityResult.ResultStatus.OK);
                        } else if (securityScan instanceof AbstractSecurityScanWithProperties) {
                            if (((AbstractSecurityScanWithProperties)securityScan).getParameterHolder().getParameterList().size() > 0) {
                                securityScanResult.setStatus(SecurityResult.ResultStatus.OK);
                            } else {
                                securityScanResult.setStatus(SecurityResult.ResultStatus.SKIPPED);
                            }
                        } else {
                            securityScanResult.setStatus(SecurityResult.ResultStatus.SKIPPED);
                        }
                        securityStepResult.addSecurityScanResult(securityScanResult);
                        this.runAfterListeners(runContext, securityScanResult);
                        continue;
                    }
                    runContext.setCurrentScanIndex(i3);
                    runContext.setCurrentScanOnSecurityTestIndex(this.currentScanOnSecurityTestIndex++);
                    securityScanResult = this.runTestStepSecurityScan(runContext, currentStep, securityScan);
                    securityStepResult.addSecurityScanResult(securityScanResult);
                    if (securityScanResult.isCanceled()) {
                        jumpExit = true;
                        break;
                    }
                    if (securityScanResult.getStatus() != SecurityResult.ResultStatus.FAILED) continue;
                    if (((SecurityTest)this.getTestRunnable()).getFailOnError()) {
                        this.fail("Cancelling due to failed security scan");
                        continue;
                    }
                    ((SecurityTestRunContext)this.getRunContext()).setProperty(TestRunner.Status.class.getName(), (Object)TestRunner.Status.FAILED);
                }
                if (securityStepResult.getStatus() == SecurityResult.ResultStatus.INITIALIZED) {
                    securityStepResult.setStatus(SecurityResult.ResultStatus.UNKNOWN);
                }
                this.securityTest.putSecurityTestStepResult(currentStep, securityStepResult);
                this.timeTaken += securityStepResult.getTimeTaken();
            }
            for (i = 0; i < this.securityTestStepListeners.length; ++i) {
                if (!Arrays.asList(this.getSecurityTest().getSecurityTestRunListeners()).contains(this.securityTestStepListeners[i])) continue;
                this.securityTestStepListeners[i].afterStep(this, (SecurityTestRunContext)this.getRunContext(), securityStepResult);
            }
            for (i = 0; i < this.securityTestListeners.length; ++i) {
                if (!Arrays.asList(this.getSecurityTest().getSecurityTestRunListeners()).contains(this.securityTestListeners[i])) continue;
                this.securityTestListeners[i].afterStep(this, (SecurityTestRunContext)this.getRunContext(), securityStepResult);
            }
            if (jumpExit) {
                return -2;
            }
            if (this.getGotoStepIndex() != -1) {
                currentStepIndex = this.getGotoStepIndex() - 1;
                this.gotoStep(-1);
            }
        }
        runContext.setCurrentStep(currentStepIndex + 1);
        return currentStepIndex;
    }

    private void runAfterListeners(SecurityTestRunContext runContext, SecurityScanResult securityScanResult) {
        int j;
        for (j = 0; j < this.securityTestStepListeners.length; ++j) {
            if (!Arrays.asList(this.getSecurityTest().getSecurityTestRunListeners()).contains(this.securityTestStepListeners[j])) continue;
            this.securityTestStepListeners[j].afterSecurityScan(this, runContext, securityScanResult);
        }
        for (j = 0; j < this.securityTestListeners.length; ++j) {
            if (!Arrays.asList(this.getSecurityTest().getSecurityTestRunListeners()).contains(this.securityTestListeners[j])) continue;
            this.securityTestListeners[j].afterSecurityScan(this, runContext, securityScanResult);
        }
    }

    @Override
    public SecurityScanResult runTestStepSecurityScan(SecurityTestRunContext runContext, TestStep currentStep, SecurityScan securityScan) {
        int j;
        SecurityScanResult result = null;
        for (j = 0; j < this.securityTestStepListeners.length; ++j) {
            if (!Arrays.asList(this.getSecurityTest().getSecurityTestRunListeners()).contains(this.securityTestStepListeners[j])) continue;
            this.securityTestStepListeners[j].beforeSecurityScan(this, runContext, securityScan);
        }
        for (j = 0; j < this.securityTestListeners.length; ++j) {
            if (!Arrays.asList(this.getSecurityTest().getSecurityTestRunListeners()).contains(this.securityTestListeners[j])) continue;
            this.securityTestListeners[j].beforeSecurityScan(this, runContext, securityScan);
        }
        result = securityScan.run(this.cloneForSecurityScan((WsdlTestStep)currentStep), runContext, this);
        if (securityScan.isRunOnlyOnce()) {
            securityScan.setSkipFurtherRunning(true);
        }
        if (this.securityTest.getFailOnError() && result.getStatus() == SecurityResult.ResultStatus.FAILED) {
            this.fail("Cancelling due to failed security scan");
        }
        this.runAfterListeners(runContext, result);
        return result;
    }

    @Override
    protected void notifyBeforeRun() {
        this.reset();
        if (this.securityTestListeners == null || this.securityTestListeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.securityTestListeners.length; ++i) {
            try {
                if (!Arrays.asList(this.getSecurityTest().getSecurityTestRunListeners()).contains(this.securityTestListeners[i])) continue;
                this.securityTestListeners[i].beforeRun(this, (SecurityTestRunContext)this.getRunContext());
                continue;
            }
            catch (Throwable t) {
                SoapUI.logError(t);
            }
        }
        super.notifyBeforeRun();
    }

    private void reset() {
        this.securityTest.resetAllScansSkipFurtherRunning();
        this.securityTest.clearSecurityTestStepResultMap();
        this.timeTaken = 0L;
    }

    @Override
    protected void notifyAfterRun() {
        super.notifyAfterRun();
        if (this.securityTestListeners == null || this.securityTestListeners.length == 0) {
            return;
        }
        for (int i = 0; i < this.securityTestListeners.length; ++i) {
            try {
                if (!Arrays.asList(this.getSecurityTest().getSecurityTestRunListeners()).contains(this.securityTestListeners[i])) continue;
                this.securityTestListeners[i].afterRun(this, (SecurityTestRunContext)this.getRunContext());
                continue;
            }
            catch (Throwable t) {
                SoapUI.logError(t);
            }
        }
    }

    @Override
    public WsdlTestCase getTestCase() {
        return ((SecurityTest)this.getTestRunnable()).getTestCase();
    }

    @Override
    protected void clear(SecurityTestRunContext runContext) {
        super.clear(runContext);
        this.securityTestListeners = null;
        this.securityTestStepListeners = null;
    }

    @Override
    protected void runSetupScripts(SecurityTestRunContext runContext) throws Exception {
        super.runSetupScripts(runContext);
        ((SecurityTest)this.getTestRunnable()).runStartupScript(runContext, this);
    }

    @Override
    protected void runTearDownScripts(SecurityTestRunContext runContext) throws Exception {
        ((SecurityTest)this.getTestRunnable()).runTearDownScript(runContext, this);
        super.runTearDownScripts(runContext);
    }

    @Override
    protected void fillInTestRunnableListeners() {
        super.fillInTestRunnableListeners();
        this.securityTestListeners = ((SecurityTest)this.getTestRunnable()).getSecurityTestRunListeners();
    }

    @Override
    protected void failTestRunnableOnErrors(SecurityTestRunContext runContext) {
        if (runContext.getProperty(TestRunner.Status.class.getName()) == TestRunner.Status.FAILED && ((SecurityTest)this.getTestRunnable()).getFailSecurityTestOnScanErrors()) {
            this.fail("Failing due to failed security scan");
        }
    }

    @Override
    public long getTimeTaken() {
        return this.timeTaken;
    }

    public long getFunctionalTimeTaken() {
        return super.getTimeTaken();
    }
}

