/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.tree.nodes;

import com.eviware.soapui.model.project.Project;
import com.eviware.soapui.model.support.WorkspaceListenerAdapter;
import com.eviware.soapui.model.tree.AbstractModelItemTreeNode;
import com.eviware.soapui.model.tree.SoapUITreeModel;
import com.eviware.soapui.model.tree.SoapUITreeNode;
import com.eviware.soapui.model.tree.nodes.ProjectTreeNode;
import com.eviware.soapui.model.workspace.Workspace;
import com.eviware.soapui.settings.UISettings;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkspaceTreeNode
extends AbstractModelItemTreeNode<Workspace> {
    private InternalWorkspaceListener workspaceListener = new InternalWorkspaceListener();
    private List<ProjectTreeNode> projectNodes = new ArrayList<ProjectTreeNode>();
    private AbstractModelItemTreeNode.ReorderPropertyChangeListener propertyChangeListener = new AbstractModelItemTreeNode.ReorderPropertyChangeListener();

    public WorkspaceTreeNode(Workspace workspace, SoapUITreeModel treeModel) {
        super(workspace, null, treeModel);
        workspace.addWorkspaceListener(this.workspaceListener);
        for (int c = 0; c < workspace.getProjectCount(); ++c) {
            Project project = workspace.getProjectAt(c);
            project.addPropertyChangeListener(Project.NAME_PROPERTY, this.propertyChangeListener);
            this.projectNodes.add(new ProjectTreeNode(project, this));
        }
        this.initOrdering(this.projectNodes, UISettings.ORDER_PROJECTS);
        this.getTreeModel().mapModelItems(this.projectNodes);
    }

    @Override
    public void release() {
        super.release();
        this.getWorkspace().removeWorkspaceListener(this.workspaceListener);
        for (ProjectTreeNode treeNode : this.projectNodes) {
            ((Project)treeNode.getModelItem()).removePropertyChangeListener(Project.NAME_PROPERTY, this.propertyChangeListener);
            treeNode.release();
        }
    }

    public Workspace getWorkspace() {
        return (Workspace)this.getModelItem();
    }

    private class InternalWorkspaceListener
    extends WorkspaceListenerAdapter {
        private InternalWorkspaceListener() {
        }

        public void projectAdded(Project project) {
            ProjectTreeNode projectTreeNode = new ProjectTreeNode(project, WorkspaceTreeNode.this);
            WorkspaceTreeNode.this.projectNodes.add(projectTreeNode);
            project.addPropertyChangeListener(Project.NAME_PROPERTY, WorkspaceTreeNode.this.propertyChangeListener);
            WorkspaceTreeNode.this.reorder(false);
            WorkspaceTreeNode.this.getTreeModel().notifyNodeInserted(projectTreeNode);
        }

        public void projectRemoved(Project project) {
            SoapUITreeNode treeNode = WorkspaceTreeNode.this.getTreeModel().getTreeNode(project);
            if (!WorkspaceTreeNode.this.projectNodes.contains(treeNode)) {
                throw new RuntimeException("Removing unkown project");
            }
            WorkspaceTreeNode.this.getTreeModel().notifyNodeRemoved(treeNode);
            WorkspaceTreeNode.this.projectNodes.remove(treeNode);
            project.removePropertyChangeListener(WorkspaceTreeNode.this.propertyChangeListener);
        }

        public void projectChanged(Project project) {
            WorkspaceTreeNode.this.getTreeModel().notifyStructureChanged(new TreeModelEvent((Object)WorkspaceTreeNode.this, new Object[]{WorkspaceTreeNode.this.getTreeModel().getPath(WorkspaceTreeNode.this)}));
        }
    }
}

