/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.model.support;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMockResponseTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Operation;
import com.eviware.soapui.model.support.XPathReference;
import com.eviware.soapui.model.testsuite.TestProperty;
import org.apache.commons.beanutils.PropertyUtils;

public class XPathReferenceImpl
implements XPathReference {
    private String label;
    private Object target;
    private String xpathPropertyName;
    private String xpath;
    private Operation operation;
    private boolean request;

    public XPathReferenceImpl(String label, Operation operation, boolean request, Object target, String xpathPropertyName) {
        this.label = label;
        this.operation = operation;
        this.request = request;
        this.target = target;
        this.xpathPropertyName = xpathPropertyName;
        try {
            this.xpath = (String)PropertyUtils.getProperty((Object)target, (String)xpathPropertyName);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public XPathReferenceImpl(String label, TestProperty property, Object target, String xpathPropertyName) {
        ModelItem modelItem;
        this.label = label;
        this.target = target;
        this.xpathPropertyName = xpathPropertyName;
        ModelItem modelItem2 = modelItem = property == null ? null : property.getModelItem();
        if (modelItem instanceof WsdlTestRequestStep) {
            this.operation = ((WsdlTestRequestStep)modelItem).getTestRequest().getOperation();
            this.request = property.getName().equalsIgnoreCase("Request");
        } else if (modelItem instanceof WsdlMockResponseTestStep) {
            this.operation = ((WsdlMockResponseTestStep)modelItem).getOperation();
            this.request = property.getName().equalsIgnoreCase("Request");
        } else if (modelItem instanceof WsdlMockResponse) {
            this.operation = ((WsdlMockResponse)modelItem).getMockOperation().getOperation();
            this.request = property.getName().equalsIgnoreCase("Request");
        } else if (modelItem instanceof WsdlMockOperation) {
            this.operation = ((WsdlMockOperation)modelItem).getOperation();
            this.request = property.getName().equalsIgnoreCase("Request");
        }
        try {
            this.xpath = (String)PropertyUtils.getProperty((Object)target, (String)xpathPropertyName);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public String getLabel() {
        return this.label;
    }

    public String getXPath() {
        return this.xpath;
    }

    public void setXPath(String xpath) {
        this.xpath = xpath;
    }

    public void update() {
        try {
            PropertyUtils.setProperty((Object)this.target, (String)this.xpathPropertyName, (Object)this.xpath);
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    public Operation getOperation() {
        return this.operation;
    }

    public boolean isRequest() {
        return this.request;
    }
}

