/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.http;

import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.support.http.HttpRequest;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import java.util.List;

public class HttpDownloadAllResourcesAssertion
extends WsdlMessageAssertion
implements ResponseAssertion,
RequestAssertion {
    public static final String ID = "HTTP Download all resources";
    public static final String LABEL = "HTTP Download all resources";
    public static final String DESCRIPTION = "Downloads all resources referred to be an HTML document (images, scripts, etc.) and validates that they are all available. Applicable to any property containing HTML.";

    public HttpDownloadAllResourcesAssertion(TestAssertionConfig assertionConfig, Assertable assertable) {
        super(assertionConfig, assertable, false, false, false, true);
    }

    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        List missingResourcesList = (List)context.getProperty("MissingResourcesList");
        if (missingResourcesList != null && !missingResourcesList.isEmpty()) {
            StringBuilder sb = new StringBuilder("Missing resources: \n");
            for (String url : missingResourcesList) {
                sb.append(url + "  ;\n");
            }
            throw new AssertionException(new AssertionError(sb.toString()));
        }
        return "HTTP Download all resources OK";
    }

    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return "OK";
    }

    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return "HTTP Download all resources OK";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super("HTTP Download all resources", "HTTP Download all resources", HttpDownloadAllResourcesAssertion.class, HttpRequest.class);
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return HttpDownloadAllResourcesAssertion.class;
        }

        @Override
        public String getCategory() {
            return "Compliance, Status and Standards";
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry("HTTP Download all resources", "HTTP Download all resources", HttpDownloadAllResourcesAssertion.DESCRIPTION);
        }
    }
}

