/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps.assertions.basic;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.TestAssertionConfig;
import com.eviware.soapui.impl.rest.RestRequestInterface;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.support.http.HttpRequestInterface;
import com.eviware.soapui.impl.wsdl.panels.assertions.AssertionListEntry;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.WsdlMockResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.AbstractGroovyEditorModel;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.submit.AbstractMessageExchange;
import com.eviware.soapui.impl.wsdl.submit.transports.http.WsdlResponse;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.HttpResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.RestResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.RestTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMockResponseTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlResponseMessageExchange;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.AbstractTestAssertionFactory;
import com.eviware.soapui.model.TestPropertyHolder;
import com.eviware.soapui.model.iface.MessageExchange;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionException;
import com.eviware.soapui.model.testsuite.RequestAssertion;
import com.eviware.soapui.model.testsuite.ResponseAssertion;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.log.JLogList;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

public class GroovyScriptAssertion
extends WsdlMessageAssertion
implements RequestAssertion,
ResponseAssertion {
    public static final String ID = "GroovyScriptAssertion";
    public static final String LABEL = "Script Assertion";
    public static final String DESCRIPTION = "Runs a custom script to perform arbitrary validations. Applicable to any Property.";
    private String scriptText;
    private SoapUIScriptEngine scriptEngine;
    private JDialog dialog;
    private GroovyScriptAssertionPanel groovyScriptAssertionPanel;
    private String oldScriptText;

    public GroovyScriptAssertion(TestAssertionConfig assertionConfig, Assertable modelItem) {
        super(assertionConfig, modelItem, true, true, true, false);
        XmlObjectConfigurationReader reader = new XmlObjectConfigurationReader(this.getConfiguration());
        this.scriptText = reader.readString("scriptText", "");
        this.scriptEngine = SoapUIScriptEngineRegistry.create(this);
        this.scriptEngine.setScript(this.scriptText);
    }

    protected String internalAssertRequest(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return this.assertScript(messageExchange, context, SoapUI.ensureGroovyLog());
    }

    private String assertScript(MessageExchange messageExchange, SubmitContext context, Logger log) throws AssertionException {
        try {
            this.scriptEngine.setVariable("context", context);
            this.scriptEngine.setVariable("messageExchange", messageExchange);
            this.scriptEngine.setVariable("log", log);
            this.scriptEngine.setVariable("assertion", this);
            Object result = this.scriptEngine.run();
            String string = result == null ? null : result.toString();
            Object var7_7 = null;
            this.scriptEngine.clearVariables();
            return string;
        }
        catch (Throwable e) {
            try {
                throw new AssertionException(new AssertionError(e.getMessage()));
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.scriptEngine.clearVariables();
                throw throwable;
            }
        }
    }

    protected String internalAssertResponse(MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return this.assertScript(messageExchange, context, SoapUI.ensureGroovyLog());
    }

    protected String internalAssertProperty(TestPropertyHolder source, String propertyName, MessageExchange messageExchange, SubmitContext context) throws AssertionException {
        return null;
    }

    public boolean configure() {
        if (this.dialog == null) {
            this.buildDialog();
        }
        this.oldScriptText = this.scriptText;
        UISupport.showDialog(this.dialog);
        return true;
    }

    protected void buildDialog() {
        this.dialog = new JDialog(UISupport.getMainFrame(), LABEL, true);
        this.groovyScriptAssertionPanel = new GroovyScriptAssertionPanel();
        this.dialog.setContentPane(this.groovyScriptAssertionPanel);
        UISupport.initDialogActions(this.dialog, this.groovyScriptAssertionPanel.getShowOnlineHelpAction(), this.groovyScriptAssertionPanel.getDefaultButton());
        this.dialog.setSize(600, 500);
        this.dialog.setModal(true);
        this.dialog.pack();
    }

    protected GroovyScriptAssertionPanel getScriptAssertionPanel() {
        return this.groovyScriptAssertionPanel;
    }

    protected XmlObject createConfiguration() {
        XmlObjectConfigurationBuilder builder = new XmlObjectConfigurationBuilder();
        builder.add("scriptText", this.scriptText);
        return builder.finish();
    }

    public String getScriptText() {
        return this.scriptText;
    }

    public void setScriptText(String scriptText) {
        this.scriptText = scriptText;
        this.scriptEngine.setScript(scriptText);
        this.setConfiguration(this.createConfiguration());
    }

    public void release() {
        super.release();
        this.scriptEngine.release();
        if (this.groovyScriptAssertionPanel != null) {
            this.groovyScriptAssertionPanel.release();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Factory
    extends AbstractTestAssertionFactory {
        public Factory() {
            super(GroovyScriptAssertion.ID, GroovyScriptAssertion.LABEL, GroovyScriptAssertion.class);
        }

        @Override
        public String getCategory() {
            return "Script";
        }

        @Override
        public Class<? extends WsdlMessageAssertion> getAssertionClassType() {
            return GroovyScriptAssertion.class;
        }

        @Override
        public AssertionListEntry getAssertionListEntry() {
            return new AssertionListEntry(GroovyScriptAssertion.ID, GroovyScriptAssertion.LABEL, GroovyScriptAssertion.DESCRIPTION);
        }
    }

    protected class GroovyScriptAssertionPanel
    extends JPanel {
        private GroovyEditor editor;
        private JSplitPane mainSplit;
        private JLogList logArea;
        private RunAction runAction;
        private Logger logger;
        private JButton okButton;
        private ShowOnlineHelpAction showOnlineHelpAction;
        public String oldscriptText;

        public GroovyScriptAssertionPanel() {
            super(new BorderLayout());
            this.runAction = new RunAction();
            this.buildUI();
            this.setPreferredSize(new Dimension(600, 440));
            this.logger = Logger.getLogger((String)("ScriptAssertion." + this.getName()));
            this.editor.requestFocusInWindow();
        }

        public GroovyEditor getGroovyEditor() {
            return this.editor;
        }

        public void release() {
            this.logArea.release();
            this.editor.release();
            this.logger = null;
        }

        private void buildUI() {
            this.editor = new GroovyEditor(new ScriptStepGroovyEditorModel());
            this.logArea = new JLogList("Groovy Test Log");
            this.logArea.addLogger("ScriptAssertion." + this.getName(), true);
            this.logArea.getLogList().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() < 2) {
                        return;
                    }
                    String value = GroovyScriptAssertionPanel.this.logArea.getLogList().getSelectedValue().toString();
                    if (value == null) {
                        return;
                    }
                    GroovyScriptAssertionPanel.this.editor.selectError(value);
                }
            });
            this.editor.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3), this.editor.getBorder()));
            this.mainSplit = UISupport.createVerticalSplit(this.editor, this.logArea);
            this.mainSplit.setDividerLocation(280);
            this.mainSplit.setResizeWeight(0.8);
            this.add((Component)this.mainSplit, "Center");
            this.add((Component)this.buildToolbar(), "North");
            this.add(this.buildStatusBar(), "South");
        }

        public JButton getDefaultButton() {
            return this.okButton;
        }

        public ShowOnlineHelpAction getShowOnlineHelpAction() {
            return this.showOnlineHelpAction;
        }

        private Component buildStatusBar() {
            ButtonBarBuilder builder = new ButtonBarBuilder();
            this.showOnlineHelpAction = new ShowOnlineHelpAction("http://www.soapui.org/userguide/functional/response-assertions.html#Script_Assertion");
            builder.addFixed((JComponent)UISupport.createToolbarButton(this.showOnlineHelpAction));
            builder.addGlue();
            this.okButton = new JButton(new OkAction());
            builder.addFixed((JComponent)this.okButton);
            builder.addRelatedGap();
            builder.addFixed((JComponent)new JButton(new CancelAction()));
            builder.setBorder(BorderFactory.createEmptyBorder(0, 3, 3, 3));
            return builder.getPanel();
        }

        private JComponent buildToolbar() {
            JXToolBar toolBar = UISupport.createToolbar();
            JButton runButton = UISupport.createToolbarButton(this.runAction);
            toolBar.add(runButton);
            toolBar.add(Box.createHorizontalGlue());
            JLabel label = new JLabel("<html>Script is invoked with <code>log</code>, <code>context</code> and <code>messageExchange</code> variables</html>");
            label.setToolTipText(label.getText());
            label.setMaximumSize(label.getPreferredSize());
            toolBar.addFixed(label);
            toolBar.addSpace(3);
            return toolBar;
        }

        private class RunAction
        extends AbstractAction {
            public RunAction() {
                this.putValue("SmallIcon", UISupport.createImageIcon("/run_groovy_script.gif"));
                this.putValue("ShortDescription", "Runs this assertion script against the last messageExchange with a mock testContext");
            }

            public void actionPerformed(ActionEvent e) {
                PropertyChangeListener testRequestStep;
                TestStep testStep = GroovyScriptAssertion.this.getAssertable().getTestStep();
                AbstractMessageExchange exchange = null;
                if (testStep instanceof WsdlTestRequestStep) {
                    testRequestStep = (WsdlTestRequestStep)testStep;
                    exchange = new WsdlResponseMessageExchange(((WsdlTestRequestStep)testRequestStep).getTestRequest());
                    exchange.setResponse((WsdlResponse)((WsdlTestRequestStep)testRequestStep).getTestRequest().getResponse());
                } else if (testStep instanceof RestTestRequestStepInterface) {
                    testRequestStep = (RestTestRequestStepInterface)testStep;
                    exchange = new RestResponseMessageExchange((RestRequestInterface)((Object)testRequestStep.getTestRequest()));
                    ((RestResponseMessageExchange)exchange).setResponse(testRequestStep.getTestRequest().getResponse());
                } else if (testStep instanceof HttpTestRequestStepInterface) {
                    testRequestStep = (HttpTestRequestStepInterface)testStep;
                    exchange = new HttpResponseMessageExchange((HttpRequestInterface<?>)testRequestStep.getTestRequest());
                    ((HttpResponseMessageExchange)exchange).setResponse(testRequestStep.getTestRequest().getResponse());
                } else if (testStep instanceof WsdlMockResponseTestStep) {
                    WsdlMockResponseTestStep mockResponseStep = (WsdlMockResponseTestStep)testStep;
                    exchange = new WsdlMockResponseMessageExchange(mockResponseStep.getMockResponse());
                }
                try {
                    GroovyScriptAssertion.this.setScriptText(GroovyScriptAssertionPanel.this.editor.getEditArea().getText());
                    String result = GroovyScriptAssertion.this.assertScript(exchange, new WsdlTestRunContext(testStep), GroovyScriptAssertionPanel.this.logger);
                    UISupport.showInfoMessage("Script Assertion Passed" + (result == null ? "" : ": [" + result + "]"));
                }
                catch (AssertionException e1) {
                    UISupport.showErrorMessage(e1.getMessage());
                }
                catch (Throwable t) {
                    SoapUI.logError(t);
                    UISupport.showErrorMessage(t.getMessage());
                }
                GroovyScriptAssertionPanel.this.editor.requestFocusInWindow();
            }
        }

        private class ScriptStepGroovyEditorModel
        extends AbstractGroovyEditorModel {
            public ScriptStepGroovyEditorModel() {
                super(new String[]{"log", "context", "messageExchange"}, GroovyScriptAssertion.this.getAssertable().getModelItem(), "Assertion");
            }

            public Action getRunAction() {
                return GroovyScriptAssertionPanel.this.runAction;
            }

            public String getScript() {
                return GroovyScriptAssertion.this.getScriptText();
            }

            public void setScript(String text) {
            }
        }

        private final class CancelAction
        extends AbstractAction {
            public CancelAction() {
                super("Cancel");
            }

            public void actionPerformed(ActionEvent e) {
                GroovyScriptAssertion.this.dialog.setVisible(false);
                GroovyScriptAssertionPanel.this.editor.getEditArea().setText(GroovyScriptAssertion.this.oldScriptText);
            }
        }

        private final class OkAction
        extends AbstractAction {
            public OkAction() {
                super("OK");
            }

            public void actionPerformed(ActionEvent e) {
                GroovyScriptAssertion.this.dialog.setVisible(false);
                GroovyScriptAssertion.this.setScriptText(GroovyScriptAssertionPanel.this.editor.getEditArea().getText());
            }
        }
    }
}

