/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.teststeps;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.HttpRequestConfig;
import com.eviware.soapui.config.RequestStepConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.impl.rest.support.RestParamProperty;
import com.eviware.soapui.impl.rest.support.RestRequestConverter;
import com.eviware.soapui.impl.support.AbstractHttpRequest;
import com.eviware.soapui.impl.support.http.HttpRequest;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlSubmit;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SinglePartHttpResponse;
import com.eviware.soapui.impl.wsdl.support.ExternalDependency;
import com.eviware.soapui.impl.wsdl.support.assertions.AssertedXPathsContainer;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestRunContext;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.HttpTestRequestStepInterface;
import com.eviware.soapui.impl.wsdl.teststeps.RestRequestStepResult;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlMessageAssertion;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequest;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestRequestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStepWithProperties;
import com.eviware.soapui.impl.wsdl.teststeps.assertions.TestAssertionRegistry;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.iface.Interface;
import com.eviware.soapui.model.iface.Request;
import com.eviware.soapui.model.iface.Response;
import com.eviware.soapui.model.iface.Submit;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.model.support.DefaultTestStepProperty;
import com.eviware.soapui.model.support.TestPropertyListenerAdapter;
import com.eviware.soapui.model.support.TestStepBeanProperty;
import com.eviware.soapui.model.testsuite.Assertable;
import com.eviware.soapui.model.testsuite.AssertionError;
import com.eviware.soapui.model.testsuite.AssertionsListener;
import com.eviware.soapui.model.testsuite.TestAssertion;
import com.eviware.soapui.model.testsuite.TestCaseRunContext;
import com.eviware.soapui.model.testsuite.TestCaseRunner;
import com.eviware.soapui.model.testsuite.TestProperty;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepProperty;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.security.Securable;
import com.eviware.soapui.support.resolver.ResolveContext;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.beans.PropertyChangeEvent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpTestRequestStep
extends WsdlTestStepWithProperties
implements HttpTestRequestStepInterface,
Securable {
    private static final Logger log = Logger.getLogger(HttpTestRequestStep.class);
    private HttpRequestConfig httpRequestConfig;
    private HttpTestRequest testRequest;
    private WsdlSubmit<HttpRequest> submit;

    public HttpTestRequestStep(WsdlTestCase testCase, TestStepConfig config, boolean forLoadTest) {
        super(testCase, config, true, forLoadTest);
        if (((TestStepConfig)this.getConfig()).getConfig() != null) {
            this.httpRequestConfig = RestRequestConverter.updateIfNeeded(((TestStepConfig)this.getConfig()).getConfig());
            ((TestStepConfig)this.getConfig()).setConfig((XmlObject)this.httpRequestConfig);
            this.httpRequestConfig = (HttpRequestConfig)((TestStepConfig)this.getConfig()).getConfig();
            this.testRequest = this.buildTestRequest(forLoadTest);
            this.testRequest.addPropertyChangeListener(this);
            this.testRequest.addTestPropertyListener(new InternalTestPropertyListener());
            if (config.isSetName()) {
                this.testRequest.setName(config.getName());
            } else {
                config.setName(this.testRequest.getName());
            }
        } else {
            this.httpRequestConfig = (HttpRequestConfig)((TestStepConfig)this.getConfig()).addNewConfig().changeType(HttpRequestConfig.type);
        }
        for (TestProperty property : this.testRequest.getProperties().values()) {
            this.addProperty(new RestTestStepProperty((RestParamProperty)property));
        }
        this.addProperty(new TestStepBeanProperty("Endpoint", false, this.testRequest, "endpoint", this, false));
        this.addProperty(new TestStepBeanProperty("Username", false, this.testRequest, "username", this, true));
        this.addProperty(new TestStepBeanProperty("Password", false, this.testRequest, "password", this, true));
        this.addProperty(new TestStepBeanProperty("Domain", false, this.testRequest, "domain", this, false));
        this.addProperty(new TestStepBeanProperty("Request", false, this.testRequest, "requestContent", this, true){

            public String getDefaultValue() {
                return HttpTestRequestStep.this.createDefaultRequestContent();
            }
        });
        this.addProperty(new TestStepBeanProperty(WsdlTestStepWithProperties.RESPONSE_AS_XML, true, this.testRequest, "responseContentAsXml", this){

            public String getDefaultValue() {
                return HttpTestRequestStep.this.createDefaultResponseXmlContent();
            }
        });
        this.addProperty(new TestStepBeanProperty("Response", true, this.testRequest, "responseContentAsString", this){

            public String getDefaultValue() {
                return HttpTestRequestStep.this.createDefaultRawResponseContent();
            }
        });
        this.addProperty(new DefaultTestStepProperty("RawRequest", true, (WsdlTestStep)this){

            public String getValue() {
                Response response = HttpTestRequestStep.this.testRequest.getResponse();
                return response == null ? null : response.getRequestContent();
            }
        });
    }

    protected HttpTestRequest buildTestRequest(boolean forLoadTest) {
        return new HttpTestRequest(this.httpRequestConfig, this, forLoadTest);
    }

    protected String createDefaultRawResponseContent() {
        return "";
    }

    protected String createDefaultResponseXmlContent() {
        return "";
    }

    protected String createDefaultRequestContent() {
        return "";
    }

    public HttpRequestConfig getRequestStepConfig() {
        return this.httpRequestConfig;
    }

    @Override
    public WsdlTestStep clone(WsdlTestCase targetTestCase, String name) {
        this.beforeSave();
        TestStepConfig config = (TestStepConfig)((TestStepConfig)this.getConfig()).copy();
        RequestStepConfig stepConfig = (RequestStepConfig)config.getConfig().changeType(RequestStepConfig.type);
        while (stepConfig.getRequest().sizeOfAttachmentArray() > 0) {
            stepConfig.getRequest().removeAttachment(0);
        }
        config.setName(name);
        stepConfig.getRequest().setName(name);
        WsdlTestRequestStep result = (WsdlTestRequestStep)targetTestCase.addTestStep(config);
        this.testRequest.copyAttachmentsTo(result.getTestRequest());
        return result;
    }

    @Override
    public void release() {
        super.release();
        if (this.testRequest != null) {
            this.testRequest.removePropertyChangeListener(this);
            this.testRequest.release();
        }
    }

    @Override
    public void resetConfigOnMove(TestStepConfig config) {
        super.resetConfigOnMove(config);
        this.httpRequestConfig = (HttpRequestConfig)config.getConfig().changeType(HttpRequestConfig.type);
        this.testRequest.updateConfig(this.httpRequestConfig);
    }

    @Override
    public ImageIcon getIcon() {
        return this.testRequest == null ? null : this.testRequest.getIcon();
    }

    @Override
    public HttpTestRequest getTestRequest() {
        return this.testRequest;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.testRequest.setName(name);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() == this.testRequest) {
            if (event.getNewValue() instanceof SinglePartHttpResponse) {
                SinglePartHttpResponse response = (SinglePartHttpResponse)event.getNewValue();
                this.firePropertyValueChanged("Response", String.valueOf(response), null);
                String XMLCOntent = response.getContentAsXml();
                this.firePropertyValueChanged("ResponseAsXml", String.valueOf(XMLCOntent), null);
            }
            if (event.getPropertyName().equals("domain")) {
                this.delegatePropertyChange("Domain", event);
            } else if (event.getPropertyName().equals("password")) {
                this.delegatePropertyChange("Password", event);
            } else if (event.getPropertyName().equals("username")) {
                this.delegatePropertyChange("Username", event);
            } else if (event.getPropertyName().equals("endpoint")) {
                this.delegatePropertyChange("Endpoint", event);
            }
        }
        if (event.getPropertyName().equals(TestAssertion.CONFIGURATION_PROPERTY) || event.getPropertyName().equals(TestAssertion.DISABLED_PROPERTY)) {
            if (this.getTestRequest().getResponse() != null) {
                this.getTestRequest().assertResponse(new WsdlTestRunContext(this));
            }
        } else {
            if (event.getSource() == this.testRequest && event.getPropertyName().equals(WsdlTestRequest.NAME_PROPERTY) && !super.getName().equals((String)event.getNewValue())) {
                super.setName((String)event.getNewValue());
            }
            this.notifyPropertyChanged(event.getPropertyName(), event.getOldValue(), event.getNewValue());
        }
    }

    private void delegatePropertyChange(String customPropertyname, PropertyChangeEvent event) {
        this.firePropertyValueChanged(customPropertyname, String.valueOf(event.getOldValue()), String.valueOf(event.getNewValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestStepResult run(TestCaseRunner runner, TestCaseRunContext runContext) {
        RestRequestStepResult testStepResult = new RestRequestStepResult(this);
        try {
            this.submit = this.testRequest.submit(runContext, false);
            HttpResponse response = (HttpResponse)this.submit.getResponse();
            if (this.submit.getStatus() != Submit.Status.CANCELED) {
                if (this.submit.getStatus() == Submit.Status.ERROR) {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    testStepResult.addMessage(this.submit.getError().toString());
                    this.testRequest.setResponse(null, runContext);
                } else if (response == null) {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    testStepResult.addMessage("Request is missing response");
                    this.testRequest.setResponse(null, runContext);
                } else {
                    runContext.setProperty(AssertedXPathsContainer.ASSERTEDXPATHSCONTAINER_PROPERTY, testStepResult);
                    this.testRequest.setResponse(response, runContext);
                    testStepResult.setTimeTaken(response.getTimeTaken());
                    testStepResult.setSize(response.getContentLength());
                    testStepResult.setResponse(response);
                    switch (this.testRequest.getAssertionStatus()) {
                        case FAILED: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                            break;
                        }
                        case VALID: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.OK);
                            break;
                        }
                        case UNKNOWN: {
                            testStepResult.setStatus(TestStepResult.TestStepStatus.UNKNOWN);
                        }
                    }
                }
            } else {
                testStepResult.setStatus(TestStepResult.TestStepStatus.CANCELED);
                testStepResult.addMessage("Request was canceled");
            }
            if (response != null) {
                testStepResult.setRequestContent(response.getRequestContent());
                testStepResult.addProperty("URL", response.getURL() == null ? "<missing>" : response.getURL().toString());
                testStepResult.addProperty("Method", String.valueOf(response.getMethod()));
                testStepResult.addProperty("StatusCode", String.valueOf(response.getStatusCode()));
                testStepResult.addProperty("HTTP Version", response.getHttpVersion());
            } else {
                testStepResult.addMessage("Missing Response");
                testStepResult.setRequestContent(this.testRequest.getRequestContent());
            }
        }
        catch (Request.SubmitException e) {
            testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
            testStepResult.addMessage("SubmitException: " + e);
        }
        finally {
            this.submit = null;
        }
        testStepResult.setDomain(PropertyExpander.expandProperties(runContext, this.testRequest.getDomain()));
        testStepResult.setUsername(PropertyExpander.expandProperties(runContext, this.testRequest.getUsername()));
        testStepResult.setEndpoint(PropertyExpander.expandProperties(runContext, this.testRequest.getEndpoint()));
        testStepResult.setPassword(PropertyExpander.expandProperties(runContext, this.testRequest.getPassword()));
        testStepResult.setEncoding(PropertyExpander.expandProperties(runContext, this.testRequest.getEncoding()));
        if (testStepResult.getStatus() != TestStepResult.TestStepStatus.CANCELED) {
            Assertable.AssertionStatus assertionStatus = this.testRequest.getAssertionStatus();
            switch (assertionStatus) {
                case FAILED: {
                    testStepResult.setStatus(TestStepResult.TestStepStatus.FAILED);
                    if (this.getAssertionCount() == 0) {
                        testStepResult.addMessage("Invalid/empty response");
                        break;
                    }
                    for (int c = 0; c < this.getAssertionCount(); ++c) {
                        WsdlMessageAssertion assertion = this.getAssertionAt(c);
                        AssertionError[] errors = assertion.getErrors();
                        if (errors == null) continue;
                        for (AssertionError error : errors) {
                            testStepResult.addMessage("[" + assertion.getName() + "] " + error.getMessage());
                        }
                    }
                    break;
                }
            }
        }
        if (this.testRequest.isDiscardResponse() && !SoapUI.getDesktop().hasDesktopPanel(this)) {
            this.testRequest.setResponse(null, runContext);
        }
        return testStepResult;
    }

    @Override
    public WsdlMessageAssertion getAssertionAt(int index) {
        return this.testRequest.getAssertionAt(index);
    }

    @Override
    public int getAssertionCount() {
        return this.testRequest == null ? 0 : this.testRequest.getAssertionCount();
    }

    @Override
    public boolean cancel() {
        if (this.submit == null) {
            return false;
        }
        this.submit.cancel();
        return true;
    }

    @Override
    public boolean dependsOn(AbstractWsdlModelItem<?> modelItem) {
        return false;
    }

    @Override
    public void beforeSave() {
        super.beforeSave();
        if (this.testRequest != null) {
            this.testRequest.beforeSave();
        }
    }

    @Override
    public String getDescription() {
        return this.testRequest == null ? "<missing>" : this.testRequest.getDescription();
    }

    @Override
    public void setDescription(String description) {
        if (this.testRequest != null) {
            this.testRequest.setDescription(description);
        }
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.testRequest == null ? Collections.EMPTY_LIST : this.testRequest.getAssertionList();
    }

    @Override
    public PropertyExpansion[] getPropertyExpansions() {
        if (this.testRequest == null) {
            return new PropertyExpansion[0];
        }
        PropertyExpansionsResult result = new PropertyExpansionsResult(this, this.testRequest);
        result.extractAndAddAll("requestContent");
        result.extractAndAddAll("endpoint");
        result.extractAndAddAll("username");
        result.extractAndAddAll("password");
        result.extractAndAddAll("domain");
        StringToStringsMap requestHeaders = this.testRequest.getRequestHeaders();
        for (String key : requestHeaders.keySet()) {
            for (String value : (List)requestHeaders.get(key)) {
                result.extractAndAddAll(new RequestHeaderHolder(key, value, this.testRequest), "value");
            }
        }
        for (String key : this.testRequest.getParams().getPropertyNames()) {
            result.extractAndAddAll(new RequestParamHolder(key), "value");
        }
        return result.toArray(new PropertyExpansion[result.size()]);
    }

    @Override
    public AbstractHttpRequest<?> getHttpRequest() {
        return this.testRequest;
    }

    @Override
    public TestAssertion addAssertion(String type) {
        WsdlMessageAssertion result = this.testRequest.addAssertion(type);
        return result;
    }

    @Override
    public void addAssertionsListener(AssertionsListener listener) {
        this.testRequest.addAssertionsListener(listener);
    }

    @Override
    public TestAssertion cloneAssertion(TestAssertion source, String name) {
        return this.testRequest.cloneAssertion(source, name);
    }

    @Override
    public String getAssertableContent() {
        return this.testRequest.getAssertableContent();
    }

    @Override
    public TestAssertionRegistry.AssertableType getAssertableType() {
        return this.testRequest.getAssertableType();
    }

    @Override
    public TestAssertion getAssertionByName(String name) {
        return this.testRequest.getAssertionByName(name);
    }

    @Override
    public List<TestAssertion> getAssertionList() {
        return this.testRequest.getAssertionList();
    }

    @Override
    public Assertable.AssertionStatus getAssertionStatus() {
        return this.testRequest.getAssertionStatus();
    }

    @Override
    public Interface getInterface() {
        return null;
    }

    @Override
    public TestStep getTestStep() {
        return this;
    }

    @Override
    public void removeAssertion(TestAssertion assertion) {
        this.testRequest.removeAssertion(assertion);
    }

    @Override
    public void removeAssertionsListener(AssertionsListener listener) {
        this.testRequest.removeAssertionsListener(listener);
    }

    @Override
    public TestAssertion moveAssertion(int ix, int offset) {
        return this.testRequest.moveAssertion(ix, offset);
    }

    @Override
    public Map<String, TestAssertion> getAssertions() {
        return this.testRequest.getAssertions();
    }

    @Override
    public void prepare(TestCaseRunner testRunner, TestCaseRunContext testRunContext) throws Exception {
        super.prepare(testRunner, testRunContext);
        this.testRequest.setResponse(null, testRunContext);
        for (TestAssertion assertion : this.testRequest.getAssertionList()) {
            assertion.prepare(testRunner, testRunContext);
        }
    }

    @Override
    public String getDefaultSourcePropertyName() {
        return WsdlTestStepWithProperties.RESPONSE_AS_XML;
    }

    @Override
    public String getDefaultTargetPropertyName() {
        return "Request";
    }

    @Override
    public String getDefaultAssertableContent() {
        return this.testRequest.getDefaultAssertableContent();
    }

    @Override
    public void resolve(ResolveContext<?> context) {
        super.resolve(context);
        this.testRequest.resolve(context);
    }

    @Override
    protected void addExternalDependencies(List<ExternalDependency> dependencies) {
        super.addExternalDependencies(dependencies);
        this.testRequest.addExternalDependencies(dependencies);
    }

    private class RestTestStepProperty
    implements TestStepProperty {
        private RestParamProperty property;

        public RestTestStepProperty(RestParamProperty property) {
            this.property = property;
        }

        public TestStep getTestStep() {
            return HttpTestRequestStep.this;
        }

        public String getName() {
            return this.property.getName();
        }

        public String getDescription() {
            return this.property.getDescription();
        }

        public String getValue() {
            return this.property.getValue();
        }

        public String getDefaultValue() {
            return this.property.getDefaultValue();
        }

        public void setValue(String value) {
            this.property.setValue(value);
        }

        public boolean isReadOnly() {
            return false;
        }

        public QName getType() {
            return this.property.getType();
        }

        public ModelItem getModelItem() {
            return HttpTestRequestStep.this.getTestRequest();
        }

        public boolean isRequestPart() {
            return true;
        }

        public SchemaType getSchemaType() {
            return this.property.getSchemaType();
        }
    }

    private class InternalTestPropertyListener
    extends TestPropertyListenerAdapter {
        private InternalTestPropertyListener() {
        }

        public void propertyAdded(String name) {
            HttpTestRequestStep.this.addProperty(new RestTestStepProperty(HttpTestRequestStep.this.getTestRequest().getProperty(name)), true);
        }

        public void propertyRemoved(String name) {
            HttpTestRequestStep.this.deleteProperty(name, true);
        }

        public void propertyRenamed(String oldName, String newName) {
            HttpTestRequestStep.this.propertyRenamed(oldName);
        }

        public void propertyValueChanged(String name, String oldValue, String newValue) {
            HttpTestRequestStep.this.firePropertyValueChanged(name, oldValue, newValue);
        }

        public void propertyMoved(String name, int oldIndex, int newIndex) {
            HttpTestRequestStep.this.firePropertyMoved(name, oldIndex, newIndex);
        }
    }

    public class RequestParamHolder {
        private final String name;

        public RequestParamHolder(String name) {
            this.name = name;
        }

        public String getValue() {
            return HttpTestRequestStep.this.testRequest.getParams().getPropertyValue(this.name);
        }

        public void setValue(String value) {
            HttpTestRequestStep.this.testRequest.setPropertyValue(this.name, value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RequestHeaderHolder {
        private final String key;
        private final String oldValue;
        private AbstractHttpRequest<?> testRequest;

        public RequestHeaderHolder(String key, String oldValue, AbstractHttpRequest<?> testRequest) {
            this.key = key;
            this.oldValue = oldValue;
            this.testRequest = testRequest;
        }

        public String getValue() {
            return this.oldValue;
        }

        public void setValue(String value) {
            StringToStringsMap valueMap = this.testRequest.getRequestHeaders();
            valueMap.replace(this.key, this.oldValue, value);
            this.testRequest.setRequestHeaders(valueMap);
        }
    }
}

