/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.support.wss.entries;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.WSSEntryConfig;
import com.eviware.soapui.impl.wsdl.support.wss.OutgoingWss;
import com.eviware.soapui.impl.wsdl.support.wss.WssCrypto;
import com.eviware.soapui.impl.wsdl.support.wss.entries.WssContainerListenerAdapter;
import com.eviware.soapui.impl.wsdl.support.wss.entries.WssEntryBase;
import com.eviware.soapui.impl.wsdl.support.wss.saml.callback.AbstractSAMLCallbackHandler;
import com.eviware.soapui.impl.wsdl.support.wss.saml.callback.SAML1CallbackHandler;
import com.eviware.soapui.impl.wsdl.support.wss.saml.callback.SAML2CallbackHandler;
import com.eviware.soapui.impl.wsdl.support.wss.saml.callback.SAMLCallbackHandler;
import com.eviware.soapui.impl.wsdl.support.wss.support.KeystoresComboBoxModel;
import com.eviware.soapui.impl.wsdl.support.wss.support.SAMLAttributeValuesTable;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionsResult;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.XmlObjectConfigurationBuilder;
import com.eviware.soapui.support.xml.XmlObjectConfigurationReader;
import com.google.common.base.Strings;
import com.jgoodies.binding.PresentationModel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.WSSecSAMLToken;
import org.apache.ws.security.saml.WSSecSignatureSAML;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.SAMLParms;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutomaticSAMLEntry
extends WssEntryBase {
    public static final String TYPE = "SAML (Form)";
    public static final String SAML_VERSION_1 = "1.1";
    public static final String SAML_VERSION_2 = "2.0";
    public static final String AUTHENTICATION_ASSERTION_TYPE = "Authentication";
    public static final String ATTRIBUTE_ASSERTION_TYPE = "Attribute";
    public static final String AUTHORIZATION_ASSERTION_TYPE = "Authorization";
    public static final String ATTRIBUTE_VALUES_VALUE_COLUMN = "value";
    public static final String HOLDER_OF_KEY_CONFIRMATION_METHOD = "Holder-of-key";
    public static final String SENDER_VOUCHES_CONFIRMATION_METHOD = "Sender vouches";
    private WssEntryBase.KeyAliasComboBoxModel keyAliasComboBoxModel;
    private InternalWssContainerListener wssContainerListener;
    private String samlVersion;
    private String assertionType;
    private String confirmationMethod;
    private String crypto;
    private String issuer;
    private String subjectName;
    private String subjectQualifier;
    private String digestAlgorithm;
    private String signatureAlgorithm;
    private boolean signed;
    private String attributeName;
    private List<StringToStringMap> attributeValues;
    private SimpleBindingForm form;
    private JCheckBox signedCheckBox;
    private JComboBox confirmationMethodComboBox;
    private JComboBox cryptoComboBox;
    private JComboBox keyAliasComboBox;
    private JPasswordField passwordField;
    private JTextField attributeNameTextField;
    private SAMLAttributeValuesTable samlAttributeValuesTable;

    @Override
    public void init(WSSEntryConfig config, OutgoingWss container) {
        super.init(config, container, TYPE);
    }

    @Override
    protected void load(XmlObjectConfigurationReader reader) {
        this.samlVersion = reader.readString("samlVersion", SAML_VERSION_1);
        this.signed = reader.readBoolean("signed", false);
        this.assertionType = reader.readString("assertionType", AUTHENTICATION_ASSERTION_TYPE);
        this.confirmationMethod = reader.readString("confirmationMethod", SENDER_VOUCHES_CONFIRMATION_METHOD);
        this.crypto = reader.readString("crypto", null);
        this.issuer = reader.readString("issuer", null);
        this.subjectName = reader.readString("subjectName", null);
        this.subjectQualifier = reader.readString("subjectQualifier", null);
        this.digestAlgorithm = reader.readString("digestAlgorithm", "http://www.w3.org/2000/09/xmldsig#sha1");
        this.signatureAlgorithm = reader.readString("signatureAlgorithm", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        this.attributeName = reader.readString("attributeName", null);
        this.attributeValues = this.readTableValues(reader, "attributeValues");
    }

    @Override
    protected void save(XmlObjectConfigurationBuilder builder) {
        builder.add("samlVersion", this.samlVersion);
        builder.add("signed", this.signed);
        builder.add("assertionType", this.assertionType);
        builder.add("confirmationMethod", this.confirmationMethod);
        builder.add("crypto", this.crypto);
        builder.add("issuer", this.issuer);
        builder.add("subjectName", this.subjectName);
        builder.add("subjectQualifier", this.subjectQualifier);
        builder.add("digestAlgorithm", this.digestAlgorithm);
        builder.add("signatureAlgorithm", this.signatureAlgorithm);
        builder.add("attributeName", this.attributeName);
        this.saveTableValues(builder, this.attributeValues, "attributeValues");
    }

    @Override
    protected JComponent buildUI() {
        this.wssContainerListener = new InternalWssContainerListener();
        this.getWssContainer().addWssContainerListener(this.wssContainerListener);
        this.form = new SimpleBindingForm(new PresentationModel((Object)this));
        this.form.addSpace(5);
        this.form.appendComboBox("samlVersion", "SAML version", new String[]{SAML_VERSION_1, SAML_VERSION_2}, "Choose the SAML version");
        this.signedCheckBox = this.form.appendCheckBox("signed", "Signed", null);
        this.signedCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AutomaticSAMLEntry.this.checkSigned();
            }
        });
        this.form.appendComboBox("assertionType", "Assertion type", new String[]{AUTHENTICATION_ASSERTION_TYPE, ATTRIBUTE_ASSERTION_TYPE, AUTHORIZATION_ASSERTION_TYPE}, "Choose the type of assertion").addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AutomaticSAMLEntry.this.checkAssertionType();
            }
        });
        this.confirmationMethodComboBox = this.form.appendComboBox("confirmationMethod", "Confirmation method", new String[]{SENDER_VOUCHES_CONFIRMATION_METHOD}, "Choose the confirmation method");
        this.cryptoComboBox = this.form.appendComboBox("crypto", "Keystore", new KeystoresComboBoxModel(this.getWssContainer(), this.getWssContainer().getCryptoByName(this.crypto), true), "Selects the Keystore containing the key to use for signing the SAML message");
        this.cryptoComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AutomaticSAMLEntry.this.keyAliasComboBoxModel.update(AutomaticSAMLEntry.this.getWssContainer().getCryptoByName(AutomaticSAMLEntry.this.crypto));
            }
        });
        this.keyAliasComboBoxModel = new WssEntryBase.KeyAliasComboBoxModel(this, this.getWssContainer().getCryptoByName(this.crypto));
        this.keyAliasComboBox = this.form.appendComboBox("username", "Alias", this.keyAliasComboBoxModel, "The alias for the key to use for encryption");
        this.passwordField = this.form.appendPasswordField("password", "Password", "The certificate password");
        this.form.appendTextField("issuer", "Issuer", "The issuer");
        this.form.appendTextField("subjectName", "Subject Name", "The subject qualifier");
        this.form.appendTextField("subjectQualifier", "Subject Qualifier", "The subject qualifier");
        this.form.appendComboBox("digestAlgorithm", "Digest Algorithm", new String[]{"http://www.w3.org/2000/09/xmldsig#sha1", "http://www.w3.org/2001/04/xmlenc#sha256", "http://www.w3.org/2001/04/xmldsig-more#sha384", "http://www.w3.org/2001/04/xmlenc#sha512"}, "Set the digest algorithm to use");
        this.form.appendComboBox("signatureAlgorithm", "Signature Algorithm", new String[]{"http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "http://www.w3.org/2000/09/xmldsig#hmac-sha1", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha256", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha384", "http://www.w3.org/2001/04/xmldsig-more#hmac-sha512"}, "Set the name of the signature encryption algorithm to use");
        this.attributeNameTextField = this.form.appendTextField("attributeName", "Attribute name", "The name of the attribute");
        this.samlAttributeValuesTable = new SAMLAttributeValuesTable(this.attributeValues, this);
        this.form.append("Attribute values", this.samlAttributeValuesTable);
        this.initComponentsEnabledState();
        return new JScrollPane(this.form.getPanel());
    }

    private void initComponentsEnabledState() {
        this.checkSigned();
        this.checkAssertionType();
    }

    private void checkSigned() {
        if (!this.signed) {
            this.form.setComboBoxItems("confirmationMethod", this.confirmationMethodComboBox, new String[]{SENDER_VOUCHES_CONFIRMATION_METHOD});
            this.confirmationMethodComboBox.setSelectedIndex(0);
            this.cryptoComboBox.setEnabled(false);
            this.keyAliasComboBox.setEnabled(false);
            this.passwordField.setEnabled(false);
        } else {
            this.form.setComboBoxItems("confirmationMethod", this.confirmationMethodComboBox, new String[]{SENDER_VOUCHES_CONFIRMATION_METHOD, HOLDER_OF_KEY_CONFIRMATION_METHOD});
            this.cryptoComboBox.setEnabled(true);
            this.keyAliasComboBox.setEnabled(true);
            this.passwordField.setEnabled(true);
        }
    }

    private void checkAssertionType() {
        if (this.assertionType.equals(AUTHORIZATION_ASSERTION_TYPE)) {
            this.signed = false;
            this.signedCheckBox.setSelected(false);
            this.signedCheckBox.setEnabled(false);
        } else {
            this.signedCheckBox.setEnabled(true);
        }
        if (this.assertionType.equals(ATTRIBUTE_ASSERTION_TYPE)) {
            this.attributeNameTextField.setEnabled(true);
            this.samlAttributeValuesTable.setEnabled(true);
        } else {
            this.attributeNameTextField.setEnabled(false);
            this.samlAttributeValuesTable.setEnabled(false);
        }
    }

    @Override
    public void process(WSSecHeader secHeader, Document doc, PropertyExpansionContext context) {
        try {
            SAMLParms samlParms = new SAMLParms();
            AbstractSAMLCallbackHandler callbackHandler = null;
            if (!this.signed) {
                WSSecSAMLToken wsSecSAMLToken = new WSSecSAMLToken();
                if (this.samlVersion.equals(SAML_VERSION_1)) {
                    callbackHandler = new SAML1CallbackHandler(this.assertionType, this.confirmationMethod);
                } else if (this.samlVersion.equals(SAML_VERSION_2)) {
                    callbackHandler = new SAML2CallbackHandler(this.assertionType, this.confirmationMethod);
                }
                AssertionWrapper assertion = this.createAssertion(context, samlParms, callbackHandler);
                wsSecSAMLToken.build(doc, assertion, secHeader);
            } else {
                WSSecSignatureSAML wsSecSignatureSAML = new WSSecSignatureSAML();
                WssCrypto wssCrypto = this.getWssContainer().getCryptoByName(this.crypto, true);
                String alias = context.expand(this.getUsername());
                if (wssCrypto == null) {
                    throw new RuntimeException("Missing keystore [" + this.crypto + "] for signature entry");
                }
                if (Strings.isNullOrEmpty((String)alias)) {
                    throw new RuntimeException(" No alias was provided for the keystore '" + this.crypto + "'. Please check your SAML (Form) configurations");
                }
                if (this.samlVersion.equals(SAML_VERSION_1)) {
                    callbackHandler = new SAML1CallbackHandler(wssCrypto.getCrypto(), alias, this.assertionType, this.confirmationMethod);
                } else if (this.samlVersion.equals(SAML_VERSION_2)) {
                    callbackHandler = new SAML2CallbackHandler(wssCrypto.getCrypto(), alias, this.assertionType, this.confirmationMethod);
                }
                AssertionWrapper assertion = this.createAssertion(context, samlParms, callbackHandler);
                assertion.signAssertion(context.expand(this.getUsername()), context.expand(this.getPassword()), wssCrypto.getCrypto(), false);
                wsSecSignatureSAML.setUserInfo(context.expand(this.getUsername()), context.expand(this.getPassword()));
                if (this.confirmationMethod.equals(SENDER_VOUCHES_CONFIRMATION_METHOD)) {
                    wsSecSignatureSAML.setKeyIdentifierType(1);
                    wsSecSignatureSAML.build(doc, null, assertion, wssCrypto.getCrypto(), context.expand(this.getUsername()), context.expand(this.getPassword()), secHeader);
                } else if (this.confirmationMethod.equals(HOLDER_OF_KEY_CONFIRMATION_METHOD)) {
                    wsSecSignatureSAML.setDigestAlgo(this.digestAlgorithm);
                    if (this.assertionType.equals(AUTHENTICATION_ASSERTION_TYPE)) {
                        wsSecSignatureSAML.setKeyIdentifierType(1);
                        wsSecSignatureSAML.setSignatureAlgorithm(this.signatureAlgorithm);
                    } else if (this.assertionType.equals(ATTRIBUTE_ASSERTION_TYPE)) {
                        wsSecSignatureSAML.setKeyIdentifierType(3);
                        wsSecSignatureSAML.setSignatureAlgorithm(this.signatureAlgorithm);
                        byte[] ephemeralKey = callbackHandler.getEphemeralKey();
                        wsSecSignatureSAML.setSecretKey(ephemeralKey);
                    }
                    wsSecSignatureSAML.build(doc, wssCrypto.getCrypto(), assertion, null, null, null, secHeader);
                }
            }
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
    }

    private AssertionWrapper createAssertion(PropertyExpansionContext context, SAMLParms samlParms, SAMLCallbackHandler callbackHandler) throws WSSecurityException {
        if (this.assertionType.equals(ATTRIBUTE_ASSERTION_TYPE)) {
            callbackHandler.setCustomAttributeName(context.expand(this.attributeName));
            callbackHandler.setCustomAttributeValues(this.extractValueColumnValues(this.attributeValues, context));
        }
        callbackHandler.setIssuer(context.expand(this.issuer));
        callbackHandler.setSubjectName(context.expand(this.subjectName));
        callbackHandler.setSubjectQualifier(context.expand(this.subjectQualifier));
        samlParms.setCallbackHandler((CallbackHandler)callbackHandler);
        return new AssertionWrapper(samlParms);
    }

    private List<String> extractValueColumnValues(List<StringToStringMap> table, PropertyExpansionContext context) {
        ArrayList<String> firstColumnValues = new ArrayList<String>();
        for (StringToStringMap row : table) {
            String columnValue = (String)row.get(ATTRIBUTE_VALUES_VALUE_COLUMN);
            firstColumnValues.add(columnValue);
        }
        return firstColumnValues;
    }

    public void relase() {
        if (this.wssContainerListener != null) {
            this.getWssContainer().removeWssContainerListener(this.wssContainerListener);
        }
    }

    @Override
    protected void addPropertyExpansions(PropertyExpansionsResult result) {
        super.addPropertyExpansions(result);
        result.extractAndAddAll(this, "issuer");
        result.extractAndAddAll(this, "subjectName");
        result.extractAndAddAll(this, "subjectQualifier");
        result.extractAndAddAll(this, "attributeName");
    }

    public String getSamlVersion() {
        return this.samlVersion;
    }

    public void setSamlVersion(String samlVersion) {
        this.samlVersion = samlVersion;
        this.saveConfig();
    }

    public String getAssertionType() {
        return this.assertionType;
    }

    public void setAssertionType(String assertionType) {
        this.assertionType = assertionType;
        this.saveConfig();
    }

    public String getConfirmationMethod() {
        return this.confirmationMethod;
    }

    public void setConfirmationMethod(String confirmationMethod) {
        this.confirmationMethod = confirmationMethod;
        this.saveConfig();
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
        this.saveConfig();
    }

    public String getCrypto() {
        return this.crypto;
    }

    public void setCrypto(String crypto) {
        this.crypto = crypto;
        this.saveConfig();
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
        this.saveConfig();
    }

    public String getSubjectQualifier() {
        return this.subjectQualifier;
    }

    public void setSubjectQualifier(String subjectQualifier) {
        this.subjectQualifier = subjectQualifier;
        this.saveConfig();
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        this.saveConfig();
    }

    public String getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        this.saveConfig();
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
        this.saveConfig();
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
        this.saveConfig();
    }

    public List<StringToStringMap> getAttributeValues() {
        return this.attributeValues;
    }

    public void setAttributeValues(List<StringToStringMap> attributeValues) {
        this.attributeValues = attributeValues;
        this.saveConfig();
    }

    private final class InternalWssContainerListener
    extends WssContainerListenerAdapter {
        private InternalWssContainerListener() {
        }

        public void cryptoUpdated(WssCrypto crypto) {
            if (crypto.getLabel().equals(AutomaticSAMLEntry.this.getCrypto())) {
                AutomaticSAMLEntry.this.keyAliasComboBoxModel.update(crypto);
            }
        }
    }
}

