/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.jms.util;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.SoapUIExtensionClassLoader;
import com.eviware.soapui.actions.SoapUIPreferencesAction;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.settings.ToolsSettings;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import hermes.Hermes;
import hermes.HermesInitialContextFactory;
import hermes.JAXBHermesLoader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class HermesUtils {
    private static boolean hermesJarsLoaded = false;
    private static Map<String, Context> contextMap = new HashMap<String, Context>();
    public static String HERMES_CONFIG_XML = "hermes-config.xml";

    public static Context hermesContext(WsdlProject project) throws NamingException, MalformedURLException, IOException {
        String expandedHermesConfigPath = PropertyExpander.expandProperties(project, project.getHermesConfig());
        String key = project.getName() + expandedHermesConfigPath;
        return HermesUtils.getHermes(key, expandedHermesConfigPath);
    }

    public static Context hermesContext(WsdlProject project, String hermesConfigPath) throws NamingException, MalformedURLException, IOException {
        String expandedHermesConfigPath = PropertyExpander.expandProperties(project, hermesConfigPath);
        String key = project.getName() + expandedHermesConfigPath;
        return HermesUtils.getHermes(key, expandedHermesConfigPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Context getHermes(String key, String hermesConfigPath) throws IOException, MalformedURLException, NamingException {
        SoapUIExtensionClassLoader.SoapUIClassLoaderState state = SoapUIExtensionClassLoader.ensure();
        if (!hermesJarsLoaded) {
            HermesUtils.addHermesJarsToClasspath();
            hermesJarsLoaded = true;
        }
        if (contextMap.containsKey(key)) {
            return contextMap.get(key);
        }
        try {
            Thread.currentThread().setContextClassLoader(JAXBHermesLoader.class.getClassLoader());
            Properties props = new Properties();
            props.put("java.naming.factory.initial", HermesInitialContextFactory.class.getName());
            props.put("java.naming.provider.url", hermesConfigPath + File.separator + HERMES_CONFIG_XML);
            props.put("hermes.loader", JAXBHermesLoader.class.getName());
            InitialContext ctx = new InitialContext(props);
            contextMap.put(key, ctx);
            InitialContext initialContext = ctx;
            Object var7_6 = null;
            state.restore();
            return initialContext;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            state.restore();
            throw throwable;
        }
    }

    private static void addHermesJarsToClasspath() throws IOException, MalformedURLException {
        String hermesHome = SoapUI.getSettings().getString(ToolsSettings.HERMES_JMS, HermesUtils.defaultHermesJMSPath());
        if ((hermesHome == null || "".equals(hermesHome)) && (hermesHome = HermesUtils.createHermesHomeSetting()) == null) {
            throw new FileNotFoundException("HermesJMS home not specified !!!");
        }
        System.setProperty("hermes.home", hermesHome);
        String hermesLib = hermesHome + File.separator + "lib";
        File dir = new File(hermesLib);
        File[] children = dir.listFiles();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (File file : children) {
            String filename = file.getName();
            if (!filename.endsWith(".jar") || filename.equals("cglib-2.1.3.jar")) continue;
            urls.add(file.toURI().toURL());
            SoapUIExtensionClassLoader.addUrlToClassLoader(new File(dir, filename).toURI().toURL(), JAXBHermesLoader.class.getClassLoader());
        }
    }

    public static void flushHermesCache() {
        contextMap.clear();
    }

    private static String createHermesHomeSetting() {
        if (Tools.isEmpty(SoapUI.getSettings().getString(ToolsSettings.HERMES_JMS, HermesUtils.defaultHermesJMSPath()))) {
            UISupport.showErrorMessage("HermesJMS Home must be set in global preferences");
            if (UISupport.getMainFrame() != null && SoapUIPreferencesAction.getInstance().show("Tools")) {
                return SoapUI.getSettings().getString(ToolsSettings.HERMES_JMS, HermesUtils.defaultHermesJMSPath());
            }
        }
        return null;
    }

    public static String defaultHermesJMSPath() {
        try {
            String path = SoapUI.getSettings().getString(ToolsSettings.HERMES_JMS, null);
            if (path == null || "".equals(path)) {
                String temp = System.getProperty("soapui.home").substring(0, System.getProperty("soapui.home").lastIndexOf("bin") - 1);
                path = new File(temp + File.separator + "hermesJMS").getAbsolutePath().toString();
                SoapUI.log("HermesJMS path: " + path);
            }
            HermesUtils.setHermesJMSPath(path);
            return path;
        }
        catch (Exception e) {
            SoapUI.log("No HermesJMS on default path %SOAPUI_HOME%/hermesJMS");
            return null;
        }
    }

    public static void setHermesJMSPath(String path) {
        if (path != null) {
            SoapUI.getSettings().setString(ToolsSettings.HERMES_JMS, path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Hermes getHermes(WsdlProject project, String sessionName) throws NamingException {
        SoapUIExtensionClassLoader.SoapUIClassLoaderState state = SoapUIExtensionClassLoader.ensure();
        try {
            try {
                Hermes hermes;
                Context ctx = HermesUtils.hermesContext(project);
                Hermes hermes2 = hermes = (Hermes)ctx.lookup(sessionName);
                Object var7_9 = null;
                state.restore();
                return hermes2;
            }
            catch (NamingException ne) {
                UISupport.showErrorMessage("Hermes configuration is not valid. Please check that 'Hermes Config' project property is set to path of proper hermes-config.xml file");
                throw new NamingException("Session name '" + sessionName + "' does not exist in Hermes configuration or path to Hermes config ( " + project.getHermesConfig() + " )is not valid !!!!");
            }
            catch (MalformedURLException mue) {
                SoapUI.logError(mue);
                Object var7_10 = null;
                state.restore();
                return null;
            }
            catch (IOException ioe) {
                SoapUI.logError(ioe);
                Object var7_11 = null;
                state.restore();
                return null;
            }
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            state.restore();
            throw throwable;
        }
    }

    public static boolean isHermesJMSSupported() {
        return !UISupport.isIdePlugin();
    }
}

