/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http.support.attachments;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.support.AbstractHttpOperation;
import com.eviware.soapui.impl.support.HttpUtils;
import com.eviware.soapui.impl.wsdl.WsdlOperation;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.Tools;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class BodyPartAttachment
implements Attachment {
    private final BodyPart bodyPart;
    private File tempFile;
    private AbstractHttpOperation operation;
    private final boolean isRequest;
    private byte[] data;
    private Attachment.AttachmentType attachmentType;

    public BodyPartAttachment(BodyPart bodyPart, AbstractHttpOperation operation, boolean isRequest, Attachment.AttachmentType attachmentType) {
        this.bodyPart = bodyPart;
        this.operation = operation;
        this.isRequest = isRequest;
        this.attachmentType = attachmentType;
    }

    public BodyPart getBodyPart() {
        return this.bodyPart;
    }

    public String getContentType() {
        try {
            return this.bodyPart.getContentType();
        }
        catch (MessagingException e) {
            SoapUI.logError(e);
            return null;
        }
    }

    public Attachment.AttachmentEncoding getEncoding() {
        return this.operation == null ? Attachment.AttachmentEncoding.NONE : this.operation.getAttachmentEncoding(this.getPart(), !this.isRequest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized InputStream getInputStream() throws Exception {
        if (this.data != null) {
            return new ByteArrayInputStream(this.data);
        }
        Attachment.AttachmentEncoding encoding = this.getEncoding();
        if (encoding == Attachment.AttachmentEncoding.NONE) {
            return this.bodyPart.getInputStream();
        }
        this.data = Tools.readAll(this.bodyPart.getInputStream(), 0L).toByteArray();
        if (encoding == Attachment.AttachmentEncoding.BASE64) {
            if (!Base64.isArrayByteBase64((byte[])this.data)) throw new Exception("Attachment content for part [" + this.getPart() + "] is not base64 encoded");
            this.data = Tools.readAll(new ByteArrayInputStream(Base64.decodeBase64((byte[])this.data)), 0L).toByteArray();
            return new ByteArrayInputStream(this.data);
        } else {
            if (encoding != Attachment.AttachmentEncoding.HEX) return new ByteArrayInputStream(this.data);
            this.data = Hex.decodeHex((char[])new String(this.data).toCharArray());
        }
        return new ByteArrayInputStream(this.data);
    }

    public String getName() {
        try {
            String[] values = this.bodyPart.getHeader("Content-Disposition");
            String disposition = values == null || values.length == 0 ? null : values[0];
            String name = HttpUtils.extractHttpHeaderParameter(disposition, "name");
            if (StringUtils.hasContent(name)) {
                return name;
            }
            values = this.bodyPart.getHeader("Content-Type");
            disposition = values == null || values.length == 0 ? null : values[0];
            name = HttpUtils.extractHttpHeaderParameter(disposition, "name");
            if (StringUtils.hasContent(name)) {
                return name;
            }
            String[] header = this.bodyPart.getHeader("Content-Id");
            if (header == null || header.length == 0) {
                return "<missing name>";
            }
            if (header[0].startsWith("<") && header[0].endsWith(">")) {
                header[0] = header[0].substring(1, header[0].length() - 1);
            }
            return header[0];
        }
        catch (MessagingException e) {
            SoapUI.logError(e);
            return null;
        }
    }

    public String getPart() {
        String name = this.getName();
        int ix = name.indexOf(61);
        if (ix > 0) {
            name = name.substring(0, ix);
        }
        return name;
    }

    public long getSize() {
        try {
            this.getInputStream();
            return this.data == null ? (long)this.bodyPart.getSize() : (long)this.data.length;
        }
        catch (Exception e) {
            SoapUI.logError(e);
            return -1L;
        }
    }

    public String getUrl() {
        if (this.tempFile == null) {
            String contentType = this.getContentType();
            int ix = contentType.lastIndexOf(47);
            int iy = -1;
            if (ix != -1) {
                iy = contentType.indexOf(59, ix);
            }
            try {
                this.tempFile = File.createTempFile("response-attachment", ix == -1 ? ".dat" : "." + (iy == -1 ? contentType.substring(ix + 1) : contentType.substring(ix + 1, iy)));
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.tempFile));
                InputStream inputStream = this.getInputStream();
                ((OutputStream)out).write(Tools.readAll(inputStream, 0L).toByteArray());
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
                inputStream.reset();
            }
            catch (Exception e) {
                SoapUI.logError(e);
            }
        }
        try {
            return this.tempFile.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            SoapUI.logError(e);
            return null;
        }
    }

    public void setContentType(String contentType) {
    }

    public void setPart(String part) {
    }

    public boolean isCached() {
        return true;
    }

    public Attachment.AttachmentType getAttachmentType() {
        return this.attachmentType == null ? Attachment.AttachmentType.UNKNOWN : this.attachmentType;
    }

    public void release() {
        this.operation = null;
    }

    public String getContentID() {
        try {
            String[] header = this.bodyPart.getHeader("Content-ID");
            if (header != null && header.length > 0) {
                return header[0];
            }
        }
        catch (MessagingException e) {
            SoapUI.logError(e);
        }
        return null;
    }

    public void setOperation(WsdlOperation operation) {
        this.operation = operation;
    }

    public void setAttachmentType(Attachment.AttachmentType attachmentType) {
        this.attachmentType = attachmentType;
    }

    public String getContentEncoding() {
        Attachment.AttachmentEncoding encoding = this.getEncoding();
        if (encoding == Attachment.AttachmentEncoding.BASE64) {
            return "base64";
        }
        if (encoding == Attachment.AttachmentEncoding.HEX) {
            return "hex";
        }
        return "binary";
    }

    public String getId() {
        return null;
    }
}

