/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.submit.transports.http;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.rest.support.MediaTypeHandler;
import com.eviware.soapui.impl.rest.support.MediaTypeHandlerRegistry;
import com.eviware.soapui.impl.support.AbstractHttpRequestInterface;
import com.eviware.soapui.impl.support.http.HttpRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HTMLPageSourceDownloader;
import com.eviware.soapui.impl.wsdl.submit.transports.http.HttpResponse;
import com.eviware.soapui.impl.wsdl.submit.transports.http.SSLInfo;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.metrics.SoapUIMetrics;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.teststeps.TestRequest;
import com.eviware.soapui.model.iface.Attachment;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionContext;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.List;
import org.apache.http.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseHttpResponse
implements HttpResponse {
    private StringToStringsMap requestHeaders;
    private StringToStringsMap responseHeaders;
    private long timeTaken;
    private long timestamp;
    private String contentType;
    private SSLInfo sslInfo;
    private URL url;
    private WeakReference<AbstractHttpRequestInterface<?>> httpRequest;
    private String method;
    private String version;
    private StringToStringMap properties;
    private byte[] rawRequestData;
    private byte[] rawResponseData;
    private int requestContentPos = -1;
    private String xmlContent;
    private boolean downloadIncludedResources;
    private Attachment[] attachments = new Attachment[0];
    protected HTMLPageSourceDownloader downloader;
    private int statusCode;

    public BaseHttpResponse(ExtendedHttpMethod httpMethod, AbstractHttpRequestInterface<?> httpRequest, PropertyExpansionContext context) {
        TestCase tc;
        this.httpRequest = new WeakReference(httpRequest);
        this.timeTaken = httpMethod.getTimeTaken();
        SoapUIMetrics metrics = httpMethod.getMetrics();
        this.method = httpMethod.getMethod();
        this.version = httpMethod.getProtocolVersion().toString();
        try {
            this.url = httpMethod.getURI().toURL();
        }
        catch (Exception e1) {
            SoapUI.logError(e1);
        }
        if (!httpMethod.isFailed()) {
            Settings settings = httpRequest.getSettings();
            try {
                httpMethod.getResponseBody();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (settings.getBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN)) {
                this.timeTaken += httpMethod.getResponseReadTime();
            }
            metrics.getReadTimer().add(httpMethod.getResponseReadTime());
            metrics.getTotalTimer().add(httpMethod.getResponseReadTime());
            try {
                this.timestamp = System.currentTimeMillis();
                this.contentType = httpMethod.getResponseContentType();
                this.statusCode = httpMethod.hasHttpResponse() ? httpMethod.getHttpResponse().getStatusLine().getStatusCode() : 0;
                this.sslInfo = httpMethod.getSSLInfo();
                this.url = httpMethod.getURI().toURL();
                metrics.setTimestamp(this.getTimestamp());
                metrics.setHttpStatus(this.getStatusCode());
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (httpRequest instanceof TestRequest && (tc = ((TestRequest)((Object)httpRequest)).getTestStep().getTestCase()) instanceof WsdlTestCase && ((WsdlTestCase)tc).isForLoadTest()) {
            this.initHeadersForLoadTest(httpMethod);
            return;
        }
        this.initHeaders(httpMethod);
        if (this.httpRequest.get() instanceof HttpRequest) {
            boolean bl = this.downloadIncludedResources = (HttpRequest)this.httpRequest.get() != null ? ((HttpRequest)this.httpRequest.get()).getDownloadIncludedResources() : false;
            if (this.downloadIncludedResources) {
                long beforeNanos = System.nanoTime();
                this.addIncludedContentsAsAttachments();
                long afterNanos = System.nanoTime();
                this.timeTaken += (afterNanos - beforeNanos) / 1000000L;
                metrics.getTotalTimer().add(afterNanos - beforeNanos);
                context.setProperty("MissingResourcesList", this.downloader.getMissingResourcesList());
            }
        }
    }

    private void addIncludedContentsAsAttachments() {
        this.downloader = new HTMLPageSourceDownloader();
        try {
            List<Attachment> attachmentList = this.downloader.downloadCssAndImages(this.url.toString(), (HttpRequest)this.httpRequest.get());
            this.attachments = attachmentList.toArray(new Attachment[attachmentList.size()]);
        }
        catch (ClassCastException cce) {
            this.attachments = new Attachment[1];
            try {
                this.attachments[0] = this.downloader.createAttachment(this.rawResponseData, this.url, (HttpRequest)this.httpRequest.get());
            }
            catch (IOException e) {
                SoapUI.log.error((Object)e);
            }
        }
        catch (Exception e) {
            SoapUI.log.error((Object)e);
        }
    }

    protected void initHeaders(ExtendedHttpMethod httpMethod) {
        try {
            Header[] headers;
            ByteArrayOutputStream rawResponse = new ByteArrayOutputStream();
            ByteArrayOutputStream rawRequest = new ByteArrayOutputStream();
            if (!httpMethod.isFailed() && httpMethod.hasHttpResponse()) {
                try {
                    rawResponse.write(String.valueOf(httpMethod.getHttpResponse().getStatusLine()).getBytes());
                    rawResponse.write("\r\n".getBytes());
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            rawRequest.write((this.method + " " + String.valueOf(this.url) + " " + this.version + "\r\n").getBytes());
            this.requestHeaders = new StringToStringsMap();
            for (Header header : headers = httpMethod.getAllHeaders()) {
                this.requestHeaders.put(header.getName(), header.getValue());
                rawRequest.write(this.toExternalForm(header).getBytes());
            }
            this.responseHeaders = new StringToStringsMap();
            if (!httpMethod.isFailed() && httpMethod.hasHttpResponse()) {
                for (Header header : headers = httpMethod.getHttpResponse().getAllHeaders()) {
                    this.responseHeaders.put(header.getName(), header.getValue());
                    rawResponse.write(this.toExternalForm(header).getBytes());
                }
                this.responseHeaders.put("#status#", String.valueOf(httpMethod.getHttpResponse().getStatusLine()));
            }
            if (httpMethod.getRequestEntity() != null) {
                rawRequest.write("\r\n".getBytes());
                if (httpMethod.getRequestEntity().isRepeatable()) {
                    this.requestContentPos = rawRequest.size();
                    MaxSizeByteArrayOutputStream tempOut = new MaxSizeByteArrayOutputStream(SoapUI.getSettings().getLong(UISettings.RAW_REQUEST_MESSAGE_SIZE, 0L));
                    httpMethod.getRequestEntity().writeTo((OutputStream)tempOut);
                    tempOut.writeTo(rawRequest);
                } else {
                    rawRequest.write("<request data not available>".getBytes());
                }
            }
            if (!httpMethod.isFailed() && httpMethod.hasHttpResponse() && httpMethod.getResponseBody() != null) {
                rawResponse.write("\r\n".getBytes());
                rawResponse.write(httpMethod.getResponseBody());
            }
            this.rawResponseData = rawResponse.toByteArray();
            this.rawRequestData = rawRequest.toByteArray();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void initHeadersForLoadTest(ExtendedHttpMethod httpMethod) {
        try {
            Header[] headers;
            this.requestHeaders = new StringToStringsMap();
            for (Header header : headers = httpMethod.getAllHeaders()) {
                this.requestHeaders.put(header.getName(), header.getValue());
            }
            if (!httpMethod.isFailed() && httpMethod.hasHttpResponse()) {
                this.responseHeaders = new StringToStringsMap();
                for (Header header : headers = httpMethod.getHttpResponse().getAllHeaders()) {
                    this.responseHeaders.put(header.getName(), header.getValue());
                }
                this.responseHeaders.put("#status#", String.valueOf(httpMethod.getHttpResponse().getStatusLine()));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        return this.responseHeaders;
    }

    @Override
    public long getTimeTaken() {
        return this.timeTaken;
    }

    @Override
    public SSLInfo getSSLInfo() {
        return this.sslInfo;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public AbstractHttpRequestInterface<?> getRequest() {
        return (AbstractHttpRequestInterface)this.httpRequest.get();
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public Attachment[] getAttachments() {
        return this.attachments;
    }

    @Override
    public Attachment[] getAttachmentsForPart(String partName) {
        return new Attachment[0];
    }

    @Override
    public byte[] getRawRequestData() {
        return this.rawRequestData;
    }

    @Override
    public byte[] getRawResponseData() {
        return this.rawResponseData;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getHttpVersion() {
        return this.version;
    }

    @Override
    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new StringToStringMap();
        }
        this.properties.put(name, value);
    }

    @Override
    public String getProperty(String name) {
        return this.properties == null ? null : (String)this.properties.get(name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.properties == null ? new String[]{} : this.properties.getKeys();
    }

    @Override
    public String getRequestContent() {
        return this.requestContentPos == -1 || this.rawRequestData == null ? null : new String(this.rawRequestData, this.requestContentPos, this.rawRequestData.length - this.requestContentPos);
    }

    @Override
    public String getContentAsXml() {
        if (this.xmlContent == null) {
            MediaTypeHandler typeHandler = MediaTypeHandlerRegistry.getTypeHandler(this.getContentType());
            this.xmlContent = typeHandler == null ? "<xml/>" : typeHandler.createXmlRepresentation(this);
        }
        return this.xmlContent;
    }

    public String toExternalForm(Header header) {
        return (null == header.getName() ? "" : header.getName()) + ": " + (null == header.getValue() ? "" : header.getValue()) + "\r\n";
    }

    public static class MaxSizeByteArrayOutputStream
    extends ByteArrayOutputStream {
        private final long maxSize;

        public MaxSizeByteArrayOutputStream(long maxSize) {
            this.maxSize = maxSize;
        }

        public synchronized void write(int b) {
            if (this.maxSize > 0L && (long)this.size() < this.maxSize) {
                super.write(b);
            }
        }

        public synchronized void write(byte[] b, int off, int len) {
            if (this.maxSize > 0L && (long)this.size() < this.maxSize) {
                if ((long)(this.size() + len) < this.maxSize) {
                    super.write(b, off, len);
                } else {
                    super.write(b, off, (int)(this.maxSize - (long)this.size()));
                }
            }
        }

        public void write(byte[] b) throws IOException {
            if (this.maxSize > 0L && (long)this.size() < this.maxSize) {
                if ((long)(this.size() + b.length) < this.maxSize) {
                    super.write(b);
                } else {
                    super.write(b, 0, (int)(this.maxSize - (long)this.size()));
                }
            }
        }
    }
}

