/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.teststeps.amf;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.panels.teststeps.amf.AMFRequest;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPostMethod;
import com.eviware.soapui.model.iface.SubmitContext;
import com.eviware.soapui.model.support.AbstractResponse;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.thoughtworks.xstream.XStream;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.MessageHeader;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.http.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AMFResponse
extends AbstractResponse<AMFRequest> {
    public static final String AMF_POST_METHOD = "AMF_POST_METHOD";
    public static final String AMF_RESPONSE_HEADERS = "responseHeaders";
    public static final String AMF_RESPONSE_ACTION_MESSAGE = "AMF_RESPONSE_ACTION_MESSAGE";
    public static final String AMF_RAW_RESPONSE_BODY = "AMF_RAW_RESPONSE_BODY";
    private String responseContentXML = "";
    private long timeTaken;
    private long timestamp;
    private AMFRequest request;
    private StringToStringsMap requestHeaders;
    private StringToStringsMap responseHeaders;
    private StringToStringMap responseAMFHeaders = new StringToStringMap();
    private byte[] rawRequestData;
    private byte[] rawResponseData;
    private ActionMessage actionMessage;
    private byte[] rawResponseBody;

    public AMFResponse(AMFRequest request, SubmitContext submitContext, Object responseContent) throws SQLException, ParserConfigurationException, TransformerConfigurationException, TransformerException {
        super(request);
        this.request = request;
        if (responseContent != null) {
            this.setResponseContentXML(new XStream().toXML(responseContent));
        }
        this.actionMessage = (ActionMessage)submitContext.getProperty(AMF_RESPONSE_ACTION_MESSAGE);
        this.rawResponseBody = (byte[])submitContext.getProperty(AMF_RAW_RESPONSE_BODY);
        this.initHeaders((ExtendedPostMethod)submitContext.getProperty(AMF_POST_METHOD));
    }

    @Override
    public String getContentAsString() {
        return this.getResponseContentXML();
    }

    @Override
    public String getContentType() {
        return "text/xml";
    }

    @Override
    public long getContentLength() {
        return this.rawResponseData != null ? (long)this.rawResponseData.length : 0L;
    }

    @Override
    public String getRequestContent() {
        return this.request.toString();
    }

    @Override
    public long getTimeTaken() {
        return this.timeTaken;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimeTaken(long timeTaken) {
        this.timeTaken = timeTaken;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setResponseContentXML(String responseContentXML) {
        this.responseContentXML = responseContentXML;
    }

    public String getResponseContentXML() {
        return this.responseContentXML;
    }

    protected void initHeaders(ExtendedPostMethod postMethod) {
        this.requestHeaders = new StringToStringsMap();
        this.responseHeaders = new StringToStringsMap();
        if (postMethod == null) {
            return;
        }
        try {
            Header[] headers;
            ByteArrayOutputStream rawResponse = new ByteArrayOutputStream();
            ByteArrayOutputStream rawRequest = new ByteArrayOutputStream();
            if (!postMethod.isFailed() && postMethod.hasHttpResponse()) {
                rawResponse.write(String.valueOf(postMethod.getHttpResponse().getStatusLine()).getBytes());
                rawResponse.write("\r\n".getBytes());
            }
            rawRequest.write((postMethod.getMethod() + " " + postMethod.getURI().toString() + " " + postMethod.getProtocolVersion().toString() + "\r\n").getBytes());
            for (Header header : headers = postMethod.getAllHeaders()) {
                this.requestHeaders.add(header.getName(), header.getValue());
                rawRequest.write(this.toExternalForm(header).getBytes());
            }
            if (!postMethod.isFailed() && postMethod.hasHttpResponse()) {
                for (Header header : headers = postMethod.getHttpResponse().getAllHeaders()) {
                    this.responseHeaders.add(header.getName(), header.getValue());
                    rawResponse.write(this.toExternalForm(header).getBytes());
                }
                this.responseHeaders.add("#status#", String.valueOf(postMethod.getHttpResponse().getStatusLine()));
            }
            if (postMethod.getRequestEntity() != null) {
                rawRequest.write("\r\n".getBytes());
                if (postMethod.getRequestEntity().isRepeatable() && postMethod.getEntity() != null) {
                    postMethod.getEntity().writeTo((OutputStream)rawRequest);
                } else {
                    rawRequest.write("<request data not available>".getBytes());
                }
            }
            if (!postMethod.isFailed()) {
                rawResponse.write("\r\n".getBytes());
                rawResponse.write(this.rawResponseBody);
            }
            this.rawResponseData = rawResponse.toByteArray();
            this.rawRequestData = rawRequest.toByteArray();
            this.initAMFHeaders(postMethod);
        }
        catch (Throwable e) {
            SoapUI.logError(e);
        }
    }

    private void initAMFHeaders(ExtendedPostMethod postMethod) {
        if (!postMethod.isFailed() && this.actionMessage != null) {
            ArrayList amfHeaders = this.actionMessage.getHeaders();
            for (MessageHeader header : amfHeaders) {
                this.responseAMFHeaders.put(header.getName(), header.getData().toString());
            }
        }
    }

    @Override
    public byte[] getRawRequestData() {
        return this.rawRequestData;
    }

    @Override
    public byte[] getRawResponseData() {
        return this.rawResponseData;
    }

    @Override
    public StringToStringsMap getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public StringToStringsMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public StringToStringMap getResponseAMFHeaders() {
        return this.responseAMFHeaders;
    }

    public String toExternalForm(Header header) {
        return (null == header.getName() ? "" : header.getName()) + ": " + (null == header.getValue() ? "" : header.getValue()) + "\r\n";
    }
}

