/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.monitor.jettyproxy;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.monitor.CaptureInputStream;
import com.eviware.soapui.impl.wsdl.monitor.JProxyServletWsdlMonitorMessageExchange;
import com.eviware.soapui.impl.wsdl.monitor.SoapMonitor;
import com.eviware.soapui.impl.wsdl.monitor.jettyproxy.ProxyServlet;
import com.eviware.soapui.impl.wsdl.submit.transports.http.ExtendedHttpMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedGetMethod;
import com.eviware.soapui.impl.wsdl.submit.transports.http.support.methods.ExtendedPostMethod;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.support.http.ProxyUtils;
import com.eviware.soapui.model.propertyexpansion.DefaultPropertyExpansionContext;
import com.eviware.soapui.support.types.StringToStringsMap;
import com.eviware.soapui.support.xml.XmlUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.protocol.BasicHttpContext;
import org.mortbay.util.IO;

public class TunnelServlet
extends ProxyServlet {
    private String sslEndPoint;
    private int sslPort = 443;
    private String prot = "https://";

    public TunnelServlet(SoapMonitor soapMonitor, String sslEndpoint) {
        super(soapMonitor);
        int prefix;
        int c;
        if (!sslEndpoint.startsWith("https")) {
            this.prot = "http://";
        }
        if ((c = sslEndpoint.indexOf(prefix = sslEndpoint.indexOf("://"), 58)) > 0) {
            this.sslPort = Integer.parseInt(sslEndpoint.substring(c + 1));
            this.sslEndPoint = sslEndpoint.substring(prefix, c);
        } else if (prefix > 0) {
            this.sslEndPoint = sslEndpoint.substring(prefix + 3);
        }
    }

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        this.context = config.getServletContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        this.monitor.fireOnRequest(request, response);
        if (response.isCommitted()) {
            return;
        }
        InetSocketAddress inetAddress = new InetSocketAddress(this.sslEndPoint, this.sslPort);
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        ExtendedHttpMethod postMethod = httpRequest.getMethod().equals("GET") ? new ExtendedGetMethod() : new ExtendedPostMethod();
        JProxyServletWsdlMonitorMessageExchange capturedData = new JProxyServletWsdlMonitorMessageExchange(this.project);
        capturedData.setRequestHost(httpRequest.getRemoteHost());
        capturedData.setRequestHeader(httpRequest);
        capturedData.setTargetURL(this.prot + inetAddress.getHostName());
        CaptureInputStream capture = new CaptureInputStream((InputStream)httpRequest.getInputStream());
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String val;
            Enumeration vals;
            String hdr = (String)headerNames.nextElement();
            String lhdr = hdr.toLowerCase();
            if ("content-length".equals(lhdr) || "transfer-encoding".equals(lhdr)) continue;
            if ("host".equals(lhdr)) {
                vals = httpRequest.getHeaders(hdr);
                while (vals.hasMoreElements()) {
                    val = (String)vals.nextElement();
                    if (!val.startsWith("127.0.0.1")) continue;
                    postMethod.addHeader(hdr, this.sslEndPoint);
                }
                continue;
            }
            vals = httpRequest.getHeaders(hdr);
            while (vals.hasMoreElements()) {
                val = (String)vals.nextElement();
                if (val == null) continue;
                postMethod.addHeader(hdr, val);
            }
        }
        if (postMethod instanceof ExtendedPostMethod) {
            InputStreamEntity entity = new InputStreamEntity((InputStream)capture, -1L);
            entity.setContentType(request.getContentType());
            ((ExtendedPostMethod)postMethod).setEntity((HttpEntity)entity);
        }
        URI uri = null;
        try {
            uri = new URI(this.prot + this.sslEndPoint);
        }
        catch (URISyntaxException e) {
            SoapUI.logError(e);
        }
        postMethod.getParams().setParameter("soapui.sslConfig", (Object)(this.settings.getString("HTTP tunnel - Set SSL Client Key Store path", "") + " " + this.settings.getString("HTTP tunnel - Set SSL Client Key Store Password", "")));
        ProxyUtils.initProxySettings(this.settings, postMethod, this.httpState, this.prot + this.sslEndPoint, new DefaultPropertyExpansionContext(this.project));
        String path = null;
        path = this.sslEndPoint.indexOf("/") < 0 ? "/" : this.sslEndPoint.substring(this.sslEndPoint.indexOf("/"), this.sslEndPoint.length());
        if (uri != null) {
            try {
                postMethod.setURI(URIUtils.createURI((String)uri.getScheme(), (String)uri.getHost(), (int)uri.getPort(), (String)path, (String)uri.getQuery(), (String)uri.getFragment()));
            }
            catch (URISyntaxException e) {
                SoapUI.logError(e);
            }
        }
        this.monitor.fireBeforeProxy(request, response, postMethod);
        if (this.settings.getBoolean("Reuse request state")) {
            if (this.httpState == null) {
                this.httpState = new BasicHttpContext();
            }
            HttpClientSupport.execute(postMethod, this.httpState);
        } else {
            HttpClientSupport.execute(postMethod);
        }
        capturedData.stopCapture();
        capturedData.setRequest(capture.getCapturedData());
        capturedData.setRawResponseBody(postMethod.getResponseBody());
        capturedData.setResponseHeader(postMethod.getHttpResponse());
        capturedData.setRawRequestData(this.getRequestToBytes(request.toString(), postMethod, capture));
        capturedData.setRawResponseData(this.getResponseToBytes(response.toString(), postMethod, capturedData.getRawResponseBody()));
        this.monitor.fireAfterProxy(request, response, postMethod, capturedData);
        StringToStringsMap responseHeaders = capturedData.getResponseHeaders();
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        for (String name : responseHeaders.keySet()) {
            for (String header : (List)responseHeaders.get(name)) {
                httpServletResponse.addHeader(name, header);
            }
        }
        IO.copy((InputStream)new ByteArrayInputStream(capturedData.getRawResponseBody()), (OutputStream)httpServletResponse.getOutputStream());
        TunnelServlet tunnelServlet = this;
        synchronized (tunnelServlet) {
            this.monitor.addMessageExchange(capturedData);
        }
        capturedData = null;
    }

    private byte[] getResponseToBytes(String footer, ExtendedHttpMethod postMethod, byte[] res) {
        String response = footer;
        if (postMethod.hasHttpResponse()) {
            Header[] headers;
            for (Header header : headers = postMethod.getHttpResponse().getAllHeaders()) {
                response = response + header.toString().trim() + "\n";
            }
            response = response + "\n";
            response = response + XmlUtils.prettyPrintXml(new String(res));
        }
        return response.getBytes();
    }

    private byte[] getRequestToBytes(String footer, ExtendedHttpMethod postMethod, CaptureInputStream capture) {
        String request = footer;
        request = request + "\n";
        request = request + XmlUtils.prettyPrintXml(new String(capture.getCapturedData()));
        return request.getBytes();
    }
}

