/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.mock.dispatch;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.MockOperationQueryMatchDispatchConfig;
import com.eviware.soapui.impl.support.actions.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.DispatchException;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockOperation;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.mock.dispatch.AbstractMockOperationDispatcher;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatchFactory;
import com.eviware.soapui.impl.wsdl.mock.dispatch.MockOperationDispatcher;
import com.eviware.soapui.model.mock.MockResponse;
import com.eviware.soapui.model.propertyexpansion.PropertyExpander;
import com.eviware.soapui.support.AbstractPropertyChangeNotifier;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.components.SimpleBindingForm;
import com.eviware.soapui.support.xml.XmlUtils;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.jgoodies.binding.PresentationModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;

public class QueryMatchMockOperationDispatcher
extends AbstractMockOperationDispatcher
implements PropertyChangeListener {
    private MockOperationQueryMatchDispatchConfig conf;
    private List<Query> queries = new ArrayList<Query>();
    private PresentationModel<Query> queryDetailFormPresentationModel;
    private QueryItemListModel queryItemListModel;
    private JList itemList;
    private JButton deleteButton;
    private JButton copyButton;
    private JButton renameButton;
    private SimpleBindingForm detailForm;
    private JButton runButton;
    private JButton declareNsButton = new JButton(new DeclareNamespacesAction());
    private JButton extractFromCurrentButton = new JButton(new ExtractFromCurrentAction());

    public QueryMatchMockOperationDispatcher(WsdlMockOperation mockOperation) {
        super(mockOperation);
        try {
            this.conf = MockOperationQueryMatchDispatchConfig.Factory.parse((String)this.getConfig().xmlText());
            for (MockOperationQueryMatchDispatchConfig.Query query : this.conf.getQueryList()) {
                this.queries.add(new Query(query));
            }
        }
        catch (XmlException e) {
            e.printStackTrace();
        }
        mockOperation.addPropertyChangeListener("mockResponses", this);
    }

    public void release() {
        this.getMockOperation().removePropertyChangeListener("mockResponses", this);
        super.release();
    }

    public JComponent getEditorComponent() {
        JSplitPane splitPane = UISupport.createHorizontalSplit(this.buildQueryListComponent(), this.buildQueryDetailComponent());
        splitPane.setDividerLocation(300);
        this.setEnabled();
        return splitPane;
    }

    protected Component buildQueryListComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        this.queryItemListModel = new QueryItemListModel();
        this.itemList = new JList(this.queryItemListModel);
        this.itemList.setCellRenderer(new QueryItemListCellRenderer());
        this.itemList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                QueryMatchMockOperationDispatcher.this.queryDetailFormPresentationModel.setBean((Object)((Query)QueryMatchMockOperationDispatcher.this.itemList.getSelectedValue()));
                QueryMatchMockOperationDispatcher.this.setEnabled();
            }
        });
        panel.add((Component)this.buildItemsToolbar(), "North");
        panel.add((Component)new JScrollPane(this.itemList), "Center");
        return panel;
    }

    protected void setEnabled() {
        Query bean = (Query)this.queryDetailFormPresentationModel.getBean();
        this.detailForm.setEnabled(bean != null);
        this.renameButton.setEnabled(bean != null);
        this.deleteButton.setEnabled(bean != null);
        this.copyButton.setEnabled(bean != null);
        this.extractFromCurrentButton.setEnabled(bean != null);
        this.copyButton.setEnabled(bean != null);
        this.declareNsButton.setEnabled(bean != null);
        this.runButton.setEnabled(this.getQueryCount() > 0);
    }

    private JXToolBar buildItemsToolbar() {
        JXToolBar toolbar = UISupport.createSmallToolbar();
        this.runButton = UISupport.createToolbarButton(new RunAction());
        toolbar.addFixed(this.runButton);
        toolbar.addSeparator();
        toolbar.addFixed(UISupport.createToolbarButton(new AddAction()));
        this.deleteButton = UISupport.createToolbarButton(new DeleteAction());
        this.deleteButton.setEnabled(false);
        toolbar.addFixed(this.deleteButton);
        toolbar.addSeparator();
        this.copyButton = UISupport.createToolbarButton(new CopyAction());
        this.copyButton.setEnabled(false);
        toolbar.addFixed(this.copyButton);
        this.renameButton = UISupport.createToolbarButton(new RenameAction());
        this.renameButton.setEnabled(false);
        toolbar.addFixed(this.renameButton);
        toolbar.addSeparator();
        return toolbar;
    }

    protected Component buildQueryDetailComponent() {
        this.queryDetailFormPresentationModel = new PresentationModel(null);
        this.detailForm = new SimpleBindingForm(this.queryDetailFormPresentationModel);
        this.detailForm.setDefaultTextAreaRows(5);
        this.detailForm.setDefaultTextAreaColumns(50);
        this.detailForm.append(this.buildQueryToolbar());
        this.detailForm.appendTextArea("query", "XPath", "The XPath to query in the request");
        this.detailForm.appendTextArea("match", "Expected Value", "The value to match");
        JComboBox comboBox = this.detailForm.appendComboBox("response", "Dispatch to", new MockResponsesComboBoxModel(), "The MockResponse to dispatch to");
        UISupport.setFixedSize(comboBox, 150, 20);
        this.detailForm.appendCheckBox("disabled", "Disabled", "Disables this Query");
        return new JScrollPane(this.detailForm.getPanel());
    }

    protected JXToolBar buildQueryToolbar() {
        JXToolBar toolBar = UISupport.createSmallToolbar();
        this.addQueryToolbarActions(toolBar);
        toolBar.addGlue();
        toolBar.addFixed(ModelItemDesktopPanel.createActionButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/operations.html#Query/Match_Dispatching"), true));
        return toolBar;
    }

    protected void addQueryToolbarActions(JXToolBar toolBar) {
        toolBar.addFixed(this.declareNsButton);
        toolBar.addFixed(this.extractFromCurrentButton);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WsdlMockResponse selectMockResponse(WsdlMockRequest request, WsdlMockResult result) throws DispatchException {
        HashMap<String, XmlCursor> cursorCache = new HashMap<String, XmlCursor>();
        try {
            WsdlMockResponse wsdlMockResponse;
            try {
                XmlObject xmlObject = request.getRequestXmlObject();
                for (Query query : this.getQueries()) {
                    String value;
                    String path;
                    if (query.isDisabled() || !StringUtils.hasContent(path = PropertyExpander.expandProperties(request.getContext(), query.getQuery()))) continue;
                    XmlCursor cursor = (XmlCursor)cursorCache.get(path);
                    if (cursor == null && !cursorCache.containsKey(path)) {
                        cursor = xmlObject.newCursor();
                        cursor.selectPath(path);
                        if (!cursor.toNextSelection()) {
                            cursor.dispose();
                            cursor = null;
                        }
                    }
                    if (cursor != null && (value = PropertyExpander.expandProperties(request.getContext(), query.getMatch())).equals(XmlUtils.getValueForMatch(cursor))) {
                        WsdlMockResponse wsdlMockResponse2;
                        request.getRequestContext().put("usedQueryMatch", (Object)query.getName());
                        WsdlMockResponse resp = null;
                        for (MockResponse mockResponse : this.getMockOperation().getMockResponses()) {
                            if (!query.getResponse().equals(mockResponse.getName())) continue;
                            resp = (WsdlMockResponse)mockResponse;
                        }
                        if (resp != null) {
                            wsdlMockResponse2 = resp;
                            Object var16_16 = null;
                            for (XmlCursor cursor2 : cursorCache.values()) {
                                if (cursor2 == null) continue;
                                cursor2.dispose();
                            }
                            return wsdlMockResponse2;
                        }
                        wsdlMockResponse2 = this.getMockOperation().getMockResponseByName(query.getResponse());
                        Object var16_17 = null;
                        for (XmlCursor cursor2 : cursorCache.values()) {
                            if (cursor2 == null) continue;
                            cursor2.dispose();
                        }
                        return wsdlMockResponse2;
                    }
                    cursorCache.put(path, cursor);
                }
                wsdlMockResponse = null;
                Object var16_18 = null;
            }
            catch (Throwable e) {
                throw new DispatchException(e);
            }
            for (XmlCursor cursor2 : cursorCache.values()) {
                if (cursor2 == null) continue;
                cursor2.dispose();
            }
            return wsdlMockResponse;
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            Iterator i$ = cursorCache.values().iterator();
            while (true) {
                if (!i$.hasNext()) {
                    throw throwable;
                }
                XmlCursor cursor2 = (XmlCursor)i$.next();
                if (cursor2 == null) continue;
                cursor2.dispose();
            }
        }
    }

    public Query addQuery(String name) {
        Query query = new Query(this.conf.addNewQuery());
        query.setName(name);
        this.queries.add(query);
        this.getPropertyChangeSupport().firePropertyChange("queries", null, query);
        if (this.queryItemListModel != null) {
            this.queryItemListModel.fireAdded();
        }
        return query;
    }

    public void deleteQuery(Query query) {
        int ix = this.queries.indexOf(query);
        this.queries.remove(ix);
        this.getPropertyChangeSupport().firePropertyChange("queries", query, null);
        if (this.queryItemListModel != null) {
            this.queryItemListModel.fireRemoved(ix);
        }
        this.conf.removeQuery(ix);
        this.saveConfig();
    }

    public Query[] getQueries() {
        return this.queries.toArray(new Query[this.queries.size()]);
    }

    public int getQueryCount() {
        return this.queries.size();
    }

    public Query getQueryByName(String name) {
        for (Query q : this.queries) {
            if (!q.getName().equals(name)) continue;
            return q;
        }
        return null;
    }

    public Query getQueryAt(int index) {
        return this.queries.get(index);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.queryItemListModel != null) {
            this.queryItemListModel.refresh();
        }
    }

    private void saveConfig() {
        this.saveConfig((XmlObject)this.conf);
    }

    protected Query getSelectedQuery() {
        return this.queryDetailFormPresentationModel == null ? null : (Query)this.queryDetailFormPresentationModel.getBean();
    }

    private class QueryItemListCellRenderer
    extends DefaultListCellRenderer {
        private Color defaultForeground = this.getForeground();

        private QueryItemListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel component = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            Query query = (Query)value;
            component.setText(query.getName());
            component.setForeground(((Query)value).isDisabled() ? Color.GRAY : this.defaultForeground);
            return component;
        }
    }

    private final class ExtractFromCurrentAction
    extends AbstractAction {
        public ExtractFromCurrentAction() {
            super("Extract");
            this.putValue("ShortDescription", "Extracts the current value into the Value field");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void actionPerformed(ActionEvent e) {
            String content;
            Query selectedQuery = QueryMatchMockOperationDispatcher.this.getSelectedQuery();
            if (selectedQuery == null) {
                return;
            }
            WsdlMockResult result = QueryMatchMockOperationDispatcher.this.getMockOperation().getLastMockResult();
            if (result != null && StringUtils.hasContent(result.getMockRequest().getRequestContent())) {
                content = result.getMockRequest().getRequestContent();
            } else {
                if (!UISupport.confirm("Missing last result, extract from default request instead?", "Extract Match")) {
                    return;
                }
                content = QueryMatchMockOperationDispatcher.this.getMockOperation().getOperation().createRequest(true);
            }
            XmlCursor cursor = null;
            try {
                try {
                    XmlObject xmlObject = XmlUtils.createXmlObject(content);
                    cursor = xmlObject.newCursor();
                    cursor.selectPath(selectedQuery.getQuery());
                    if (!cursor.toNextSelection()) {
                        UISupport.showErrorMessage("Missing match in request");
                    }
                    selectedQuery.setMatch(XmlUtils.getValueForMatch(cursor));
                }
                catch (Throwable e1) {
                    SoapUI.logError(e1);
                    Object var8_9 = null;
                    if (cursor == null) return;
                    cursor.dispose();
                    return;
                }
                Object var8_8 = null;
                if (cursor == null) return;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (cursor == null) throw throwable;
                cursor.dispose();
                throw throwable;
            }
            cursor.dispose();
        }
    }

    private final class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run.gif"));
            this.putValue("ShortDescription", "Runs Queries on last request");
        }

        public void actionPerformed(ActionEvent e) {
            WsdlMockResult result = QueryMatchMockOperationDispatcher.this.getMockOperation().getLastMockResult();
            if (result != null) {
                try {
                    UISupport.showInfoMessage("Selected [" + QueryMatchMockOperationDispatcher.this.selectMockResponse(result.getMockRequest(), result).getName() + "]");
                }
                catch (DispatchException e1) {
                    UISupport.showErrorMessage(e1);
                }
            } else {
                UISupport.showErrorMessage("Missing request to query");
            }
        }
    }

    private final class DeclareNamespacesAction
    extends AbstractAction {
        public DeclareNamespacesAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/declareNs.gif"));
            this.putValue("ShortDescription", "Declare request namespaces in current query");
        }

        public void actionPerformed(ActionEvent e) {
            Query selectedQuery = QueryMatchMockOperationDispatcher.this.getSelectedQuery();
            if (selectedQuery == null) {
                return;
            }
            try {
                WsdlMockResult lastResult = QueryMatchMockOperationDispatcher.this.getMockOperation().getLastMockResult();
                String content = null;
                if (lastResult == null) {
                    if (!UISupport.confirm("Missing last result, declare from default request instead?", "Declare Namespaces")) {
                        return;
                    }
                    content = QueryMatchMockOperationDispatcher.this.getMockOperation().getOperation().createRequest(true);
                } else {
                    content = lastResult.getMockRequest().getRequestContent();
                }
                String path = selectedQuery.getQuery();
                if (path == null) {
                    path = "";
                }
                selectedQuery.setQuery(XmlUtils.declareXPathNamespaces(content) + path);
            }
            catch (Exception e1) {
                UISupport.showErrorMessage(e1);
            }
        }
    }

    private final class RenameAction
    extends AbstractAction {
        public RenameAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/rename.gif"));
            this.putValue("ShortDescription", "Renames the selected Property Transfer");
        }

        public void actionPerformed(ActionEvent e) {
            Query selectedQuery = QueryMatchMockOperationDispatcher.this.getSelectedQuery();
            if (selectedQuery == null) {
                return;
            }
            String newName = UISupport.prompt("Specify new name for Query", "Rename Query", selectedQuery.getName());
            if (newName != null && !selectedQuery.getName().equals(newName)) {
                selectedQuery.setName(newName);
                QueryMatchMockOperationDispatcher.this.queryItemListModel.refresh();
            }
        }
    }

    private final class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/remove_property.gif"));
            this.putValue("ShortDescription", "Deletes the selected Property Transfer");
        }

        public void actionPerformed(ActionEvent e) {
            Query selectedQuery = QueryMatchMockOperationDispatcher.this.getSelectedQuery();
            if (selectedQuery == null) {
                return;
            }
            if (UISupport.confirm("Delete selected Query", "Delete Query")) {
                QueryMatchMockOperationDispatcher.this.deleteQuery(selectedQuery);
                if (QueryMatchMockOperationDispatcher.this.getQueryCount() > 0) {
                    QueryMatchMockOperationDispatcher.this.itemList.setSelectedIndex(0);
                }
            }
        }
    }

    private final class CopyAction
    extends AbstractAction {
        public CopyAction() {
            this.putValue("ShortDescription", "Copies the selected Match");
            this.putValue("SmallIcon", UISupport.createImageIcon("/clone_request.gif"));
        }

        public void actionPerformed(ActionEvent e) {
            Query selectedQuery = QueryMatchMockOperationDispatcher.this.getSelectedQuery();
            if (selectedQuery == null) {
                return;
            }
            String name = UISupport.prompt("Specify name for copied Query", "Copy Query", selectedQuery.getName());
            if (name == null || name.trim().length() == 0) {
                return;
            }
            Query query = QueryMatchMockOperationDispatcher.this.addQuery(name);
            query.setMatch(selectedQuery.getMatch());
            query.setQuery(selectedQuery.getQuery());
            query.setResponse(selectedQuery.getResponse());
            QueryMatchMockOperationDispatcher.this.itemList.setSelectedIndex(QueryMatchMockOperationDispatcher.this.getQueryCount() - 1);
        }
    }

    private final class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("ShortDescription", "Adds a new Match");
            this.putValue("SmallIcon", UISupport.createImageIcon("/add_property.gif"));
        }

        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify name for Match", "Add Query Match", "");
            if (name == null || name.trim().length() == 0) {
                return;
            }
            QueryMatchMockOperationDispatcher.this.addQuery(name);
        }
    }

    private class MockResponsesComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private MockResponsesComboBoxModel() {
        }

        public int getSize() {
            return QueryMatchMockOperationDispatcher.this.getMockOperation().getMockResponseCount();
        }

        public Object getElementAt(int index) {
            return QueryMatchMockOperationDispatcher.this.getMockOperation().getMockResponseAt(index).getName();
        }

        public void setSelectedItem(Object anItem) {
            Query query = QueryMatchMockOperationDispatcher.this.getSelectedQuery();
            if (query != null) {
                query.setResponse(String.valueOf(anItem));
            }
        }

        public Object getSelectedItem() {
            Query query = QueryMatchMockOperationDispatcher.this.getSelectedQuery();
            return query != null ? query.getResponse() : null;
        }
    }

    private class QueryItemListModel
    extends AbstractListModel {
        private QueryItemListModel() {
        }

        public int getSize() {
            return QueryMatchMockOperationDispatcher.this.getQueryCount();
        }

        public Object getElementAt(int index) {
            return QueryMatchMockOperationDispatcher.this.getQueryAt(index);
        }

        public void refresh() {
            this.fireContentsChanged(this, 0, QueryMatchMockOperationDispatcher.this.getQueryCount());
        }

        public void fireAdded() {
            this.fireIntervalAdded(this, QueryMatchMockOperationDispatcher.this.getQueryCount(), QueryMatchMockOperationDispatcher.this.getQueryCount());
        }

        public void fireRemoved(int index) {
            this.fireIntervalRemoved(this, index, index);
        }
    }

    public class Query
    extends AbstractPropertyChangeNotifier {
        private MockOperationQueryMatchDispatchConfig.Query config;

        protected Query(MockOperationQueryMatchDispatchConfig.Query config) {
            this.config = config;
        }

        public String getName() {
            return this.config.getName();
        }

        public void setName(String s) {
            String old = this.config.getName();
            this.config.setName(s);
            QueryMatchMockOperationDispatcher.this.saveConfig();
            this.firePropertyChange("name", old, s);
        }

        public boolean isDisabled() {
            return this.config.getDisabled();
        }

        public void setDisabled(boolean disabled) {
            boolean old = this.config.getDisabled();
            if (old == disabled) {
                return;
            }
            this.config.setDisabled(disabled);
            QueryMatchMockOperationDispatcher.this.saveConfig();
            this.firePropertyChange("disabled", old, disabled);
            QueryMatchMockOperationDispatcher.this.queryItemListModel.refresh();
        }

        public String getQuery() {
            return this.config.getQuery();
        }

        public void setQuery(String s) {
            String old = this.config.getQuery();
            this.config.setQuery(s);
            QueryMatchMockOperationDispatcher.this.saveConfig();
            this.firePropertyChange("query", old, s);
        }

        public String getMatch() {
            return this.config.getMatch();
        }

        public void setMatch(String s) {
            String old = this.config.getMatch();
            this.config.setMatch(s);
            QueryMatchMockOperationDispatcher.this.saveConfig();
            this.firePropertyChange("match", old, s);
        }

        public String getResponse() {
            return this.config.getResponse();
        }

        public void setResponse(String s) {
            String old = this.config.getResponse();
            this.config.setResponse(s);
            QueryMatchMockOperationDispatcher.this.saveConfig();
            this.firePropertyChange("response", old, s);
        }
    }

    public static class Factory
    implements MockOperationDispatchFactory {
        public MockOperationDispatcher build(WsdlMockOperation mockOperation) {
            return new QueryMatchMockOperationDispatcher(mockOperation);
        }
    }
}

