/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.log;

import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLogEntry;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.action.swing.ActionList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.swing.ImageIcon;

public class LoadTestLogErrorEntry
implements LoadTestLogEntry {
    private final String error;
    private TestStepResult result;
    private String type;
    private ImageIcon icon;
    private long timestamp;
    private boolean discarded;
    private String targetStepName;
    private final int threadIndex;

    public LoadTestLogErrorEntry(String type, String error, TestStepResult result, ImageIcon icon, int threadIndex) {
        this.icon = icon;
        this.type = type;
        this.error = error;
        this.result = result;
        this.threadIndex = threadIndex;
        this.targetStepName = result == null ? null : result.getTestStep().getName();
        this.timestamp = result == null ? System.currentTimeMillis() : result.getTimeStamp();
    }

    public LoadTestLogErrorEntry(String type, String message, ImageIcon icon, int threadIndex) {
        this.type = type;
        this.error = message;
        this.icon = icon;
        this.threadIndex = threadIndex;
        this.targetStepName = "- Total -";
        this.timestamp = System.currentTimeMillis();
    }

    public String getMessage() {
        if (this.discarded) {
            return this.error + " [discarded]";
        }
        return this.error + " [threadIndex=" + this.threadIndex + "]";
    }

    public TestStepResult getTestStepResult() {
        return this.result;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public String getTargetStepName() {
        return this.targetStepName;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getType() {
        return this.type;
    }

    public boolean isError() {
        return true;
    }

    public ActionList getActions() {
        return this.result == null ? null : this.result.getActions();
    }

    public void exportToFile(String fileName) throws IOException {
        PrintWriter writer = new PrintWriter(fileName);
        writer.write(new Date(this.timestamp).toString());
        writer.write(":");
        writer.write(this.targetStepName);
        writer.write(":");
        writer.write(this.error);
        writer.write(":");
        writer.print(this.threadIndex);
        writer.println();
        if (this.result != null) {
            writer.println("----------------------------------------------------");
            this.result.writeTo(writer);
        } else if (this.discarded) {
            writer.println("-> Discarded");
        }
        writer.close();
    }

    public void discard() {
        this.result = null;
        this.discarded = true;
    }

    public boolean isDiscarded() {
        return this.discarded;
    }
}

