/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.assertions;

import com.eviware.soapui.config.LoadTestAssertionConfig;
import com.eviware.soapui.impl.wsdl.loadtest.LoadTestAssertion;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.support.Configurable;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.support.TestSuiteListenerAdapter;
import com.eviware.soapui.model.testsuite.LoadTestRunContext;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.apache.log4j.Logger;
import org.apache.xmlbeans.XmlObject;

public abstract class AbstractLoadTestAssertion
implements LoadTestAssertion {
    private LoadTestAssertionConfig assertionConfig;
    private static final Logger log = Logger.getLogger(AbstractLoadTestAssertion.class);
    private ImageIcon icon;
    private final WsdlLoadTest loadTest;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String testStepName;
    private TestStep testStep;
    private TestStepPropertyChangeListener testStepPropertyChangeListener = new TestStepPropertyChangeListener();
    private InternalTestSuiteListener testSuiteListener = new InternalTestSuiteListener();
    protected static final String TEST_STEP_ELEMENT = "test-step";
    protected static final String TEST_STEP_FIELD = "TestStep";

    public AbstractLoadTestAssertion(LoadTestAssertionConfig assertionConfig, WsdlLoadTest loadTest) {
        this.assertionConfig = assertionConfig;
        this.loadTest = loadTest;
        loadTest.getTestCase().getTestSuite().addTestSuiteListener(this.testSuiteListener);
    }

    public void initIcon(String url) {
        this.icon = UISupport.createImageIcon(url);
    }

    public LoadTestAssertionConfig getConfiguration() {
        return this.assertionConfig;
    }

    public void updateConfiguration(LoadTestAssertionConfig configuration) {
        this.assertionConfig = configuration;
    }

    protected void setConfiguration(XmlObject configuration) {
        XmlObject oldConfig = this.assertionConfig.getConfiguration();
        this.assertionConfig.setConfiguration(configuration);
        this.propertyChangeSupport.firePropertyChange(CONFIGURATION_PROPERTY, oldConfig, configuration);
    }

    public String getName() {
        return this.assertionConfig.isSetName() ? this.assertionConfig.getName() : this.assertionConfig.getType();
    }

    public void setName(String name) {
        String old = this.getName();
        this.assertionConfig.setName(name);
        this.propertyChangeSupport.firePropertyChange(NAME_PROPERTY, old, name);
    }

    public WsdlLoadTest getLoadTest() {
        return this.loadTest;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected String returnErrorOrFail(String message, int maxErrors, LoadTestRunner testRunner, LoadTestRunContext context) {
        String propertyKey = this.getClass().getName() + this.hashCode();
        Long errorCount = (Long)context.getProperty(propertyKey);
        errorCount = errorCount == null ? Long.valueOf(1L) : new Long(errorCount + 1L);
        if (maxErrors >= 0 && errorCount >= (long)maxErrors) {
            testRunner.fail("Maximum number of errors [" + maxErrors + "] for assertion [" + this.getName() + "] exceeded");
        }
        context.setProperty(propertyKey, errorCount);
        return message;
    }

    public String getTargetStep() {
        return this.testStepName;
    }

    public void setTargetStep(String name) {
        this.testStepName = name;
        this.initTestStep();
    }

    protected abstract void updateConfiguration();

    protected boolean targetStepMatches(TestStep testStep) {
        return this.testStepName == null || this.testStepName.equals("- Any -") || testStep.getName().equals(this.testStepName);
    }

    protected String[] getTargetStepOptions(boolean includeAll) {
        if (includeAll) {
            return ModelSupport.getNames(new String[]{"- Any -", "- Total -"}, this.getLoadTest().getTestCase().getTestStepList());
        }
        return ModelSupport.getNames(new String[]{"- Any -"}, this.getLoadTest().getTestCase().getTestStepList());
    }

    private void initTestStep() {
        if (this.testStep != null) {
            this.testStep.removePropertyChangeListener(this.testStepPropertyChangeListener);
        }
        this.testStep = this.getLoadTest().getTestCase().getTestStepByName(this.testStepName);
        if (this.testStep != null) {
            this.testStep.addPropertyChangeListener(TestStep.NAME_PROPERTY, this.testStepPropertyChangeListener);
        }
    }

    public void release() {
        if (this.testStep != null) {
            this.testStep.removePropertyChangeListener(this.testStepPropertyChangeListener);
        }
        this.loadTest.getTestCase().getTestSuite().removeTestSuiteListener(this.testSuiteListener);
    }

    private final class TestStepPropertyChangeListener
    implements PropertyChangeListener {
        private TestStepPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            AbstractLoadTestAssertion.this.testStepName = evt.getNewValue().toString();
            AbstractLoadTestAssertion.this.updateConfiguration();
        }
    }

    private final class InternalTestSuiteListener
    extends TestSuiteListenerAdapter {
        private InternalTestSuiteListener() {
        }

        public void testStepRemoved(TestStep removedTestStep, int index) {
            if (removedTestStep.getName().equals(AbstractLoadTestAssertion.this.testStepName) && removedTestStep.getTestCase() == AbstractLoadTestAssertion.this.testStep.getTestCase()) {
                AbstractLoadTestAssertion.this.testStepName = "- Any -";
                AbstractLoadTestAssertion.this.updateConfiguration();
            }
        }
    }

    public class ConfigureAssertionAction
    extends AbstractAction {
        public ConfigureAssertionAction() {
            super("Configure");
            this.putValue("ShortDescription", "Configures this assertion");
        }

        public void actionPerformed(ActionEvent e) {
            ((Configurable)((Object)AbstractLoadTestAssertion.this)).configure();
        }
    }

    public class RenameAssertionAction
    extends AbstractAction {
        public RenameAssertionAction() {
            super("Rename");
            this.putValue("ShortDescription", "Renames this assertion");
        }

        public void actionPerformed(ActionEvent e) {
            String name = UISupport.prompt("Specify name for this assertion", "Rename Assertion", AbstractLoadTestAssertion.this.getName());
            if (name == null || name.equals(AbstractLoadTestAssertion.this.getName())) {
                return;
            }
            AbstractLoadTestAssertion.this.setName(name);
        }
    }
}

