/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.config.LoadTestConfig;
import com.eviware.soapui.config.SecurityTestConfig;
import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.config.TestCaseDocumentConfig;
import com.eviware.soapui.config.TestStepConfig;
import com.eviware.soapui.config.TestStepSecurityTestConfig;
import com.eviware.soapui.config.TestSuiteConfig;
import com.eviware.soapui.config.TestSuiteRunTypesConfig;
import com.eviware.soapui.impl.wsdl.AbstractTestPropertyHolderWsdlModelItem;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestSuiteRunner;
import com.eviware.soapui.impl.wsdl.teststeps.WsdlTestStep;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.support.ModelSupport;
import com.eviware.soapui.model.testsuite.TestCase;
import com.eviware.soapui.model.testsuite.TestSuite;
import com.eviware.soapui.model.testsuite.TestSuiteListener;
import com.eviware.soapui.model.testsuite.TestSuiteRunContext;
import com.eviware.soapui.model.testsuite.TestSuiteRunListener;
import com.eviware.soapui.model.testsuite.TestSuiteRunner;
import com.eviware.soapui.security.SecurityTest;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.resolver.ResolveDialog;
import com.eviware.soapui.support.scripting.SoapUIScriptEngine;
import com.eviware.soapui.support.scripting.SoapUIScriptEngineRegistry;
import com.eviware.soapui.support.types.StringToObjectMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WsdlTestSuite
extends AbstractTestPropertyHolderWsdlModelItem<TestSuiteConfig>
implements TestSuite {
    public static final String SETUP_SCRIPT_PROPERTY = WsdlTestSuite.class.getName() + "@setupScript";
    public static final String TEARDOWN_SCRIPT_PROPERTY = WsdlTestSuite.class.getName() + "@tearDownScript";
    private final WsdlProject project;
    private List<WsdlTestCase> testCases = new ArrayList<WsdlTestCase>();
    private Set<TestSuiteListener> testSuiteListeners = new HashSet<TestSuiteListener>();
    private Set<TestSuiteRunListener> testSuiteRunListeners = new HashSet<TestSuiteRunListener>();
    private SoapUIScriptEngine setupScriptEngine;
    private SoapUIScriptEngine tearDownScriptEngine;

    public WsdlTestSuite(WsdlProject project, TestSuiteConfig config) {
        super(config, project, "/testSuite.gif");
        this.project = project;
        if (!config.isSetProperties()) {
            config.addNewProperties();
        }
        this.setPropertiesConfig(config.getProperties());
        List testCaseConfigs = config.getTestCaseList();
        for (int i = 0; i < testCaseConfigs.size(); ++i) {
            this.testCases.add(this.buildTestCase((TestCaseConfig)testCaseConfigs.get(i), false));
        }
        if (!config.isSetRunType()) {
            config.setRunType(TestSuiteRunTypesConfig.SEQUENTIAL);
        }
        for (TestSuiteListener testSuiteListener : SoapUI.getListenerRegistry().getListeners(TestSuiteListener.class)) {
            this.addTestSuiteListener(testSuiteListener);
        }
        for (TestSuiteRunListener testSuiteRunListener : SoapUI.getListenerRegistry().getListeners(TestSuiteRunListener.class)) {
            this.addTestSuiteRunListener(testSuiteRunListener);
        }
    }

    public WsdlTestCase buildTestCase(TestCaseConfig testCaseConfig, boolean forLoadTest) {
        return new WsdlTestCase(this, testCaseConfig, forLoadTest);
    }

    @Override
    public TestSuite.TestSuiteRunType getRunType() {
        TestSuiteRunTypesConfig.Enum runType = ((TestSuiteConfig)this.getConfig()).getRunType();
        if (runType.equals(TestSuiteRunTypesConfig.PARALLELL)) {
            return TestSuite.TestSuiteRunType.PARALLEL;
        }
        return TestSuite.TestSuiteRunType.SEQUENTIAL;
    }

    public void setRunType(TestSuite.TestSuiteRunType runType) {
        TestSuite.TestSuiteRunType oldRunType = this.getRunType();
        if (runType == TestSuite.TestSuiteRunType.PARALLEL && oldRunType != TestSuite.TestSuiteRunType.PARALLEL) {
            ((TestSuiteConfig)this.getConfig()).setRunType(TestSuiteRunTypesConfig.PARALLELL);
            this.notifyPropertyChanged(RUNTYPE_PROPERTY, (Object)oldRunType, (Object)runType);
        } else if (runType == TestSuite.TestSuiteRunType.SEQUENTIAL && oldRunType != TestSuite.TestSuiteRunType.SEQUENTIAL) {
            ((TestSuiteConfig)this.getConfig()).setRunType(TestSuiteRunTypesConfig.SEQUENTIAL);
            this.notifyPropertyChanged(RUNTYPE_PROPERTY, (Object)oldRunType, (Object)runType);
        }
    }

    @Override
    public WsdlProject getProject() {
        return this.project;
    }

    @Override
    public int getTestCaseCount() {
        return this.testCases.size();
    }

    @Override
    public WsdlTestCase getTestCaseAt(int index) {
        return this.testCases.get(index);
    }

    @Override
    public WsdlTestCase getTestCaseByName(String testCaseName) {
        return (WsdlTestCase)this.getWsdlModelItemByName(this.testCases, testCaseName);
    }

    public WsdlTestCase cloneTestCase(WsdlTestCase testCase, String name) {
        testCase.beforeSave();
        TestCaseConfig newTestCase = ((TestSuiteConfig)this.getConfig()).addNewTestCase();
        newTestCase.set(testCase.getConfig());
        newTestCase.setName(name);
        WsdlTestCase newWsdlTestCase = this.buildTestCase(newTestCase, false);
        ModelSupport.unsetIds(newWsdlTestCase);
        newWsdlTestCase.afterLoad();
        this.testCases.add(newWsdlTestCase);
        this.fireTestCaseAdded(newWsdlTestCase);
        return newWsdlTestCase;
    }

    public WsdlTestCase addNewTestCase(String name) {
        WsdlTestCase testCase = this.buildTestCase(((TestSuiteConfig)this.getConfig()).addNewTestCase(), false);
        testCase.setName(name);
        testCase.setFailOnError(true);
        testCase.setSearchProperties(true);
        this.testCases.add(testCase);
        this.fireTestCaseAdded(testCase);
        return testCase;
    }

    public WsdlTestCase importTestCase(WsdlTestCase testCase, String name, int index, boolean includeLoadTests, boolean includeSecurityTests, boolean createCopy) {
        testCase.beforeSave();
        if (index >= this.testCases.size()) {
            index = -1;
        }
        TestCaseConfig testCaseConfig = index == -1 ? (TestCaseConfig)((TestSuiteConfig)this.getConfig()).addNewTestCase().set(((TestCaseConfig)testCase.getConfig()).copy()) : (TestCaseConfig)((TestSuiteConfig)this.getConfig()).insertNewTestCase(index).set(((TestCaseConfig)testCase.getConfig()).copy());
        testCaseConfig.setName(name);
        if (!includeLoadTests) {
            testCaseConfig.setLoadTestArray(new LoadTestConfig[0]);
        }
        if (createCopy) {
            testCaseConfig.setSecurityTestArray(new SecurityTestConfig[0]);
        }
        WsdlTestCase oldTestCase = testCase;
        testCase = this.buildTestCase(testCaseConfig, false);
        if (createCopy) {
            ModelSupport.unsetIds(testCase);
        }
        if (index == -1) {
            this.testCases.add(testCase);
        } else {
            this.testCases.add(index, testCase);
        }
        testCase.afterLoad();
        if (createCopy) {
            testCase.afterCopy(null, oldTestCase);
            if (includeSecurityTests) {
                testCase.importSecurityTests(null, oldTestCase);
            }
        }
        this.fireTestCaseAdded(testCase);
        this.resolveImportedTestCase(testCase);
        return testCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTestCase(WsdlTestCase testCase) {
        int ix = this.testCases.indexOf(testCase);
        this.testCases.remove(ix);
        try {
            this.fireTestCaseRemoved(testCase);
            Object var4_3 = null;
            testCase.release();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            testCase.release();
            ((TestSuiteConfig)this.getConfig()).removeTestCase(ix);
            throw throwable;
        }
        ((TestSuiteConfig)this.getConfig()).removeTestCase(ix);
    }

    public void fireTestCaseAdded(WsdlTestCase testCase) {
        TestSuiteListener[] a = this.testSuiteListeners.toArray(new TestSuiteListener[this.testSuiteListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testCaseAdded(testCase);
        }
    }

    public void fireTestCaseRemoved(WsdlTestCase testCase) {
        TestSuiteListener[] a = this.testSuiteListeners.toArray(new TestSuiteListener[this.testSuiteListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testCaseRemoved(testCase);
        }
    }

    private void fireTestCaseMoved(WsdlTestCase testCase, int ix, int offset) {
        TestSuiteListener[] a = this.testSuiteListeners.toArray(new TestSuiteListener[this.testSuiteListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testCaseMoved(testCase, ix, offset);
        }
    }

    public void fireTestStepAdded(WsdlTestStep testStep, int index) {
        TestSuiteListener[] a = this.testSuiteListeners.toArray(new TestSuiteListener[this.testSuiteListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testStepAdded(testStep, index);
        }
    }

    public void fireTestStepRemoved(WsdlTestStep testStep, int ix) {
        TestSuiteListener[] a = this.testSuiteListeners.toArray(new TestSuiteListener[this.testSuiteListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testStepRemoved(testStep, ix);
        }
    }

    public void fireTestStepMoved(WsdlTestStep testStep, int ix, int offset) {
        TestSuiteListener[] a = this.testSuiteListeners.toArray(new TestSuiteListener[this.testSuiteListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].testStepMoved(testStep, ix, offset);
        }
    }

    public void fireLoadTestAdded(WsdlLoadTest loadTest) {
        TestSuiteListener[] a = this.testSuiteListeners.toArray(new TestSuiteListener[this.testSuiteListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].loadTestAdded(loadTest);
        }
    }

    public void fireLoadTestRemoved(WsdlLoadTest loadTest) {
        TestSuiteListener[] a = this.testSuiteListeners.toArray(new TestSuiteListener[this.testSuiteListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].loadTestRemoved(loadTest);
        }
    }

    @Override
    public void addTestSuiteListener(TestSuiteListener listener) {
        this.testSuiteListeners.add(listener);
    }

    @Override
    public void removeTestSuiteListener(TestSuiteListener listener) {
        this.testSuiteListeners.remove(listener);
    }

    @Override
    public void addTestSuiteRunListener(TestSuiteRunListener listener) {
        this.testSuiteRunListeners.add(listener);
    }

    @Override
    public void removeTestSuiteRunListener(TestSuiteRunListener listener) {
        this.testSuiteRunListeners.remove(listener);
    }

    public int getTestCaseIndex(TestCase testCase) {
        return this.testCases.indexOf(testCase);
    }

    @Override
    public void release() {
        super.release();
        for (WsdlTestCase testCase : this.testCases) {
            testCase.release();
        }
        this.testSuiteListeners.clear();
        if (this.setupScriptEngine != null) {
            this.setupScriptEngine.release();
        }
        if (this.tearDownScriptEngine != null) {
            this.tearDownScriptEngine.release();
        }
    }

    @Override
    public List<TestCase> getTestCaseList() {
        ArrayList<TestCase> result = new ArrayList<TestCase>();
        for (WsdlTestCase testCase : this.testCases) {
            result.add(testCase);
        }
        return result;
    }

    public Map<String, TestCase> getTestCases() {
        HashMap<String, TestCase> result = new HashMap<String, TestCase>();
        for (TestCase testCase : this.testCases) {
            result.put(testCase.getName(), testCase);
        }
        return result;
    }

    public WsdlTestCase moveTestCase(int ix, int offset) {
        int c;
        WsdlTestCase testCase = this.testCases.get(ix);
        if (offset == 0) {
            return testCase;
        }
        this.testCases.remove(ix);
        this.testCases.add(ix + offset, testCase);
        TestCaseConfig[] configs = new TestCaseConfig[this.testCases.size()];
        for (c = 0; c < this.testCases.size(); ++c) {
            if (offset > 0) {
                if (c < ix) {
                    configs[c] = (TestCaseConfig)((TestSuiteConfig)this.getConfig()).getTestCaseArray(c).copy();
                    continue;
                }
                if (c < ix + offset) {
                    configs[c] = (TestCaseConfig)((TestSuiteConfig)this.getConfig()).getTestCaseArray(c + 1).copy();
                    continue;
                }
                if (c == ix + offset) {
                    configs[c] = (TestCaseConfig)((TestSuiteConfig)this.getConfig()).getTestCaseArray(ix).copy();
                    continue;
                }
                configs[c] = (TestCaseConfig)((TestSuiteConfig)this.getConfig()).getTestCaseArray(c).copy();
                continue;
            }
            configs[c] = c < ix + offset ? (TestCaseConfig)((TestSuiteConfig)this.getConfig()).getTestCaseArray(c).copy() : (c == ix + offset ? (TestCaseConfig)((TestSuiteConfig)this.getConfig()).getTestCaseArray(ix).copy() : (c <= ix ? (TestCaseConfig)((TestSuiteConfig)this.getConfig()).getTestCaseArray(c - 1).copy() : (TestCaseConfig)((TestSuiteConfig)this.getConfig()).getTestCaseArray(c).copy()));
        }
        ((TestSuiteConfig)this.getConfig()).setTestCaseArray(configs);
        for (c = 0; c < configs.length; ++c) {
            this.testCases.get(c).resetConfigOnMove(((TestSuiteConfig)this.getConfig()).getTestCaseArray(c));
        }
        this.fireTestCaseMoved(testCase, ix, offset);
        return testCase;
    }

    @Override
    public int getIndexOfTestCase(TestCase testCase) {
        return this.testCases.indexOf(testCase);
    }

    @Override
    public List<? extends ModelItem> getChildren() {
        return this.getTestCaseList();
    }

    public void setSetupScript(String script) {
        String oldScript = this.getSetupScript();
        if (!((TestSuiteConfig)this.getConfig()).isSetSetupScript()) {
            ((TestSuiteConfig)this.getConfig()).addNewSetupScript();
        }
        ((TestSuiteConfig)this.getConfig()).getSetupScript().setStringValue(script);
        if (this.setupScriptEngine != null) {
            this.setupScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(SETUP_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getSetupScript() {
        return ((TestSuiteConfig)this.getConfig()).isSetSetupScript() ? ((TestSuiteConfig)this.getConfig()).getSetupScript().getStringValue() : null;
    }

    public void setTearDownScript(String script) {
        String oldScript = this.getTearDownScript();
        if (!((TestSuiteConfig)this.getConfig()).isSetTearDownScript()) {
            ((TestSuiteConfig)this.getConfig()).addNewTearDownScript();
        }
        ((TestSuiteConfig)this.getConfig()).getTearDownScript().setStringValue(script);
        if (this.tearDownScriptEngine != null) {
            this.tearDownScriptEngine.setScript(script);
        }
        this.notifyPropertyChanged(TEARDOWN_SCRIPT_PROPERTY, oldScript, script);
    }

    public String getTearDownScript() {
        return ((TestSuiteConfig)this.getConfig()).isSetTearDownScript() ? ((TestSuiteConfig)this.getConfig()).getTearDownScript().getStringValue() : null;
    }

    public Object runSetupScript(TestSuiteRunContext context, TestSuiteRunner runner) throws Exception {
        String script = this.getSetupScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.setupScriptEngine == null) {
            this.setupScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.setupScriptEngine.setScript(script);
        }
        this.setupScriptEngine.setVariable("runner", runner);
        this.setupScriptEngine.setVariable("context", context);
        this.setupScriptEngine.setVariable("testSuite", this);
        this.setupScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.setupScriptEngine.run();
    }

    public Object runTearDownScript(TestSuiteRunContext context, TestSuiteRunner runner) throws Exception {
        String script = this.getTearDownScript();
        if (StringUtils.isNullOrEmpty(script)) {
            return null;
        }
        if (this.tearDownScriptEngine == null) {
            this.tearDownScriptEngine = SoapUIScriptEngineRegistry.create(this);
            this.tearDownScriptEngine.setScript(script);
        }
        this.tearDownScriptEngine.setVariable("runner", runner);
        this.tearDownScriptEngine.setVariable("context", context);
        this.tearDownScriptEngine.setVariable("testSuite", this);
        this.tearDownScriptEngine.setVariable("log", SoapUI.ensureGroovyLog());
        return this.tearDownScriptEngine.run();
    }

    @Override
    public void setName(String name) {
        String oldLabel = this.getLabel();
        super.setName(name);
        String label = this.getLabel();
        if (oldLabel != null && !oldLabel.equals(label)) {
            this.notifyPropertyChanged(LABEL_PROPERTY, oldLabel, label);
        }
    }

    @Override
    public String getLabel() {
        String name = this.getName();
        if (this.isDisabled()) {
            return name + " (disabled)";
        }
        return name;
    }

    public boolean isFailOnErrors() {
        return ((TestSuiteConfig)this.getConfig()).getFailOnErrors();
    }

    public void setFailOnErrors(boolean failOnErrors) {
        ((TestSuiteConfig)this.getConfig()).setFailOnErrors(failOnErrors);
    }

    public boolean isAbortOnError() {
        return ((TestSuiteConfig)this.getConfig()).getAbortOnError();
    }

    public void setAbortOnError(boolean abortOnError) {
        ((TestSuiteConfig)this.getConfig()).setAbortOnError(abortOnError);
    }

    public long getTimeout() {
        return ((TestSuiteConfig)this.getConfig()).getTimeout();
    }

    public void setTimeout(long timeout) {
        ((TestSuiteConfig)this.getConfig()).setTimeout(timeout);
    }

    @Override
    public boolean isDisabled() {
        return ((TestSuiteConfig)this.getConfig()).getDisabled();
    }

    public void setDisabled(boolean disabled) {
        String oldLabel = this.getLabel();
        boolean oldDisabled = this.isDisabled();
        if (oldDisabled == disabled) {
            return;
        }
        if (disabled) {
            ((TestSuiteConfig)this.getConfig()).setDisabled(disabled);
        } else if (((TestSuiteConfig)this.getConfig()).isSetDisabled()) {
            ((TestSuiteConfig)this.getConfig()).unsetDisabled();
        }
        this.notifyPropertyChanged(DISABLED_PROPERTY, oldDisabled, disabled);
        String label = this.getLabel();
        if (!oldLabel.equals(label)) {
            this.notifyPropertyChanged(LABEL_PROPERTY, oldLabel, label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(WsdlTestCase testCase, TestCaseConfig newTestCase) {
        int ix = this.testCases.indexOf(testCase);
        this.testCases.remove(ix);
        try {
            this.fireTestCaseRemoved(testCase);
            Object var5_4 = null;
            testCase.release();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            testCase.release();
            ((TestSuiteConfig)this.getConfig()).removeTestCase(ix);
            throw throwable;
        }
        ((TestSuiteConfig)this.getConfig()).removeTestCase(ix);
        TestCaseConfig newConfig = (TestCaseConfig)((TestSuiteConfig)this.getConfig()).insertNewTestCase(ix).set((XmlObject)newTestCase).changeType(TestCaseConfig.type);
        testCase = this.buildTestCase(newConfig, false);
        this.testCases.add(ix, testCase);
        testCase.afterLoad();
        this.fireTestCaseAdded(testCase);
        this.resolveImportedTestCase(testCase);
    }

    public void importTestCase(File file) {
        TestCaseConfig importTestCaseConfig = null;
        if (!file.exists()) {
            UISupport.showErrorMessage("Error loading test case ");
            return;
        }
        try {
            importTestCaseConfig = TestCaseDocumentConfig.Factory.parse((File)file).getTestCase();
        }
        catch (Exception e) {
            SoapUI.logError(e);
        }
        if (importTestCaseConfig != null) {
            TestCaseConfig newConfig = (TestCaseConfig)((TestSuiteConfig)this.getConfig()).addNewTestCase().set((XmlObject)importTestCaseConfig).changeType(TestCaseConfig.type);
            WsdlTestCase newTestCase = this.buildTestCase(newConfig, false);
            ModelSupport.unsetIds(newTestCase);
            LinkedHashMap<String, String> oldNewIds = new LinkedHashMap<String, String>();
            for (int cnt = 0; cnt < importTestCaseConfig.getTestStepList().size(); ++cnt) {
                oldNewIds.put(((TestStepConfig)importTestCaseConfig.getTestStepList().get(cnt)).getId(), newTestCase.getTestStepList().get(cnt).getId());
            }
            for (SecurityTest scan : newTestCase.getSecurityTests().values()) {
                for (TestStepSecurityTestConfig secStepConfig : ((SecurityTestConfig)scan.getConfig()).getTestStepSecurityTestList()) {
                    if (!oldNewIds.containsKey(secStepConfig.getTestStepId())) continue;
                    secStepConfig.setTestStepId((String)oldNewIds.get(secStepConfig.getTestStepId()));
                }
            }
            newTestCase.afterLoad();
            this.testCases.add(newTestCase);
            this.fireTestCaseAdded(newTestCase);
            this.resolveImportedTestCase(newTestCase);
        } else {
            UISupport.showErrorMessage("Not valid test case xml");
        }
    }

    private void resolveImportedTestCase(WsdlTestCase newTestCase) {
        ResolveDialog resolver = new ResolveDialog("Validate TestCase", "Checks TestCase for inconsistencies", null);
        resolver.setShowOkMessage(false);
        resolver.resolve(newTestCase);
    }

    public void export(File file) {
        try {
            ((TestSuiteConfig)this.getConfig()).newCursor().save(file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void afterCopy(WsdlTestSuite oldTestSuite) {
        for (int i = 0; i < this.testCases.size(); ++i) {
            WsdlTestCase testCase = this.getTestCaseAt(i);
            WsdlTestCase oldTestCase = oldTestSuite.getTestCaseAt(i);
            testCase.afterCopy(oldTestSuite, oldTestCase);
            testCase.importSecurityTests(oldTestSuite, oldTestCase);
        }
    }

    @Override
    public WsdlTestSuiteRunner run(StringToObjectMap context, boolean async) {
        WsdlTestSuiteRunner testSuiteRunner = new WsdlTestSuiteRunner(this, context);
        testSuiteRunner.start(async);
        return testSuiteRunner;
    }

    public TestSuiteRunListener[] getTestSuiteRunListeners() {
        return this.testSuiteRunListeners.toArray(new TestSuiteRunListener[this.testSuiteRunListeners.size()]);
    }

    public void resetConfigOnMove(TestSuiteConfig testSuiteConfig) {
        this.setConfig(testSuiteConfig);
        List configs = ((TestSuiteConfig)this.getConfig()).getTestCaseList();
        for (int c = 0; c < configs.size(); ++c) {
            this.testCases.get(c).resetConfigOnMove((TestCaseConfig)configs.get(c));
        }
        this.setPropertiesConfig(testSuiteConfig.getProperties());
    }

    public void fireSecurityTestAdded(SecurityTest securityTest) {
        TestSuiteListener[] a = this.testSuiteListeners.toArray(new TestSuiteListener[this.testSuiteListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].securityTestAdded(securityTest);
        }
    }

    public void fireSecurityTestRemoved(SecurityTest securityTest) {
        TestSuiteListener[] a = this.testSuiteListeners.toArray(new TestSuiteListener[this.testSuiteListeners.size()]);
        for (int c = 0; c < a.length; ++c) {
            a[c].securityTestRemoved(securityTest);
        }
    }
}

