/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui;

import com.eviware.soapui.SoapUI;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class SoapUIExtensionClassLoader
extends URLClassLoader {
    private static Map<ClassLoader, SoapUIClassLoaderState> clStates = new HashMap<ClassLoader, SoapUIClassLoaderState>();

    public SoapUIExtensionClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void addURL(URL url) {
        super.addURL(url);
    }

    public void addFile(File file) throws MalformedURLException {
        this.addURL(file.toURI().toURL());
    }

    public static SoapUIClassLoaderState ensure() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        SoapUIClassLoaderState state = clStates.get(contextClassLoader);
        if (state == null) {
            ClassLoader cl;
            for (cl = contextClassLoader; cl != null && !(cl instanceof SoapUIExtensionClassLoader); cl = cl.getParent()) {
            }
            state = new SoapUIClassLoaderState(cl == null ? contextClassLoader : null);
            clStates.put(contextClassLoader, state);
        }
        return state.activate();
    }

    public static SoapUIExtensionClassLoader create(String root, ClassLoader parent) throws MalformedURLException {
        String extDir = System.getProperty("soapui.ext.libraries");
        File dir = extDir != null ? new File(extDir) : new File(new File(root), "ext");
        ArrayList<URL> urls = new ArrayList<URL>();
        if (dir.exists() && dir.isDirectory()) {
            File[] files;
            for (File file : files = dir.listFiles()) {
                if (!file.getName().toLowerCase().endsWith(".jar")) continue;
                urls.add(file.toURI().toURL());
                SoapUI.log.info((Object)("Adding [" + file.getAbsolutePath() + "] to extensions classpath"));
            }
        } else {
            SoapUI.log.warn((Object)("Missing folder [" + dir.getAbsolutePath() + "] for external libraries"));
        }
        return new SoapUIExtensionClassLoader(urls.toArray(new URL[urls.size()]), parent);
    }

    public static void addUrlToClassLoader(URL u, ClassLoader classLoader) throws IOException {
        try {
            Method method = classLoader.getClass().getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, u);
            SoapUI.log.info((Object)("Added [" + u.toString() + "] to classpath"));
        }
        catch (NoSuchMethodException e) {
            try {
                Method method = classLoader.getClass().getSuperclass().getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)classLoader, u);
                SoapUI.log.info((Object)("Added [" + u.toString() + "] to classpath"));
            }
            catch (NoSuchMethodException ex) {
                try {
                    Method method = classLoader.getClass().getSuperclass().getSuperclass().getDeclaredMethod("addURL", URL.class);
                    method.setAccessible(true);
                    method.invoke((Object)classLoader, u);
                    SoapUI.log.info((Object)("Added [" + u.toString() + "] to classpath"));
                }
                catch (Throwable t) {
                    try {
                        if (classLoader.getParent() == null) {
                            throw new IOException("Error, could not add URL to classloader " + classLoader.getClass().getName());
                        }
                        SoapUI.log.info((Object)("Failed to add jar to " + classLoader.getClass().getName() + ", trying parent"));
                        SoapUIExtensionClassLoader.addUrlToClassLoader(u, classLoader.getParent());
                    }
                    catch (IOException e3) {
                        SoapUI.logError(t);
                        throw e3;
                    }
                }
            }
            catch (Throwable t) {
                SoapUI.logError(t);
                throw new IOException("Error, could not add URL to system classloader " + classLoader.getClass().getName());
            }
        }
        catch (Throwable t) {
            SoapUI.logError(t);
            throw new IOException("Error, could not add URL to system classloader " + classLoader.getClass().getName());
        }
    }

    public static class SoapUIClassLoaderState {
        private ClassLoader cl;

        private SoapUIClassLoaderState(ClassLoader cl) {
            this.cl = cl;
        }

        private SoapUIClassLoaderState activate() {
            if (this.cl != null && SoapUI.getSoapUICore() != null) {
                Thread.currentThread().setContextClassLoader(SoapUI.getSoapUICore().getExtensionClassLoader());
            }
            return this;
        }

        public void restore() {
            if (this.cl != null) {
                Thread.currentThread().setContextClassLoader(this.cl);
            }
        }
    }
}

