/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.SoapUICore;
import com.eviware.soapui.SoapUIExtensionClassLoader;
import com.eviware.soapui.config.SoapuiSettingsDocumentConfig;
import com.eviware.soapui.impl.settings.XmlBeansSettingsImpl;
import com.eviware.soapui.impl.wsdl.support.http.HttpClientSupport;
import com.eviware.soapui.impl.wsdl.support.soap.SoapVersion;
import com.eviware.soapui.model.propertyexpansion.PropertyExpansionUtils;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.monitor.JettyMockEngine;
import com.eviware.soapui.monitor.MockEngine;
import com.eviware.soapui.security.registry.SecurityScanRegistry;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.settings.ProxySettings;
import com.eviware.soapui.settings.SecuritySettings;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.settings.VersionUpdateSettings;
import com.eviware.soapui.settings.WSISettings;
import com.eviware.soapui.settings.WebRecordingSettings;
import com.eviware.soapui.settings.WsaSettings;
import com.eviware.soapui.settings.WsdlSettings;
import com.eviware.soapui.support.SecurityScanUtil;
import com.eviware.soapui.support.StringUtils;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.SoapUIActionRegistry;
import com.eviware.soapui.support.factory.SoapUIFactoryRegistry;
import com.eviware.soapui.support.listener.SoapUIListenerRegistry;
import com.eviware.soapui.support.types.StringList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.GeneralSecurityException;
import java.util.TimerTask;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import org.apache.commons.ssl.OpenSSL;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;

public class DefaultSoapUICore
implements SoapUICore {
    public static Logger log;
    private boolean logIsInitialized;
    private String root;
    protected SoapuiSettingsDocumentConfig settingsDocument;
    private MockEngine mockEngine;
    private XmlBeansSettingsImpl settings;
    private SoapUIListenerRegistry listenerRegistry;
    private SoapUIActionRegistry actionRegistry;
    private SoapUIFactoryRegistry factoryRegistry;
    private long lastSettingsLoad = 0L;
    private String settingsFile;
    private String password;
    protected boolean initialImport;
    private TimerTask settingsWatcher;
    private SoapUIExtensionClassLoader extClassLoader;
    public boolean isSavingSettings;
    protected SecurityScanRegistry securityScanRegistry;

    public boolean getInitialImport() {
        return this.initialImport;
    }

    public void setInitialImport(boolean initialImport) {
        this.initialImport = initialImport;
    }

    public static DefaultSoapUICore createDefault() {
        return new DefaultSoapUICore(null, "soapui-settings.xml");
    }

    public DefaultSoapUICore() {
    }

    public DefaultSoapUICore(boolean settingPassword, String soapUISettingsPassword) {
        this.password = soapUISettingsPassword;
    }

    public DefaultSoapUICore(String root) {
        this.root = root;
    }

    public DefaultSoapUICore(String root, String settingsFile) {
        this(root);
        this.init(settingsFile);
    }

    public DefaultSoapUICore(String root, String settingsFile, String password) {
        this(root);
        this.password = password;
        this.init(settingsFile);
    }

    public void init(String settingsFile) {
        this.initLog();
        SoapUI.setSoapUICore(this);
        this.loadExternalLibraries();
        this.initSettings(settingsFile == null ? "soapui-settings.xml" : settingsFile);
        this.initExtensions(this.getExtensionClassLoader());
        this.initPlugins();
        this.initCoreComponents();
        SoapVersion.Soap11.equals(SoapVersion.Soap12);
    }

    protected void initPlugins() {
        File[] pluginFiles = new File("plugins").listFiles();
        if (pluginFiles != null) {
            for (File pluginFile : pluginFiles) {
                if (!pluginFile.getName().toLowerCase().endsWith("-plugin.jar")) continue;
                try {
                    log.info((Object)("Adding plugin from [" + pluginFile.getAbsolutePath() + "]"));
                    this.getExtensionClassLoader().addFile(pluginFile);
                    JarFile jarFile = new JarFile(pluginFile);
                    JarEntry entry = jarFile.getJarEntry("META-INF/factories.xml");
                    if (entry != null) {
                        this.getFactoryRegistry().addConfig(jarFile.getInputStream(entry), this.extClassLoader);
                    }
                    if ((entry = jarFile.getJarEntry("META-INF/listeners.xml")) != null) {
                        this.getListenerRegistry().addConfig(jarFile.getInputStream(entry), this.extClassLoader);
                    }
                    if ((entry = jarFile.getJarEntry("META-INF/actions.xml")) != null) {
                        this.getActionRegistry().addConfig(jarFile.getInputStream(entry), this.extClassLoader);
                    }
                    UISupport.addResourceClassLoader(new URLClassLoader(new URL[]{pluginFile.toURI().toURL()}));
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        }
    }

    protected void initExtensions(ClassLoader extensionClassLoader) {
        String extDir = System.getProperty("soapui.ext.listeners");
        this.addExternalListeners(extDir != null ? extDir : (this.root == null ? "listeners" : this.root + File.separatorChar + "listeners"), extensionClassLoader);
        String factoriesDir = System.getProperty("soapui.ext.factories");
        this.addExternalFactories(factoriesDir != null ? factoriesDir : (this.root == null ? "factories" : this.root + File.separatorChar + "factories"), extensionClassLoader);
    }

    protected void initCoreComponents() {
    }

    public String getRoot() {
        if (this.root == null || this.root.length() == 0) {
            this.root = System.getProperty("soapui.home", new File(".").getAbsolutePath());
        }
        return this.root;
    }

    protected Settings initSettings(String fileName) {
        StringList list;
        File settingsFile;
        block23: {
            settingsFile = new File(fileName).exists() ? new File(fileName) : null;
            try {
                if (settingsFile == null) {
                    settingsFile = new File(new File(this.getRoot()), "soapui-settings.xml");
                    if (!settingsFile.exists()) {
                        settingsFile = new File(new File(System.getProperty("user.home", ".")), "soapui-settings.xml");
                        this.lastSettingsLoad = 0L;
                    }
                } else {
                    settingsFile = new File(fileName);
                    if (!settingsFile.getAbsolutePath().equals(this.settingsFile)) {
                        this.lastSettingsLoad = 0L;
                    }
                }
                if (!settingsFile.exists()) {
                    if (this.settingsDocument == null) {
                        log.info((Object)("Creating new settings at [" + settingsFile.getAbsolutePath() + "]"));
                        this.settingsDocument = SoapuiSettingsDocumentConfig.Factory.newInstance();
                        this.setInitialImport(true);
                    }
                    this.lastSettingsLoad = System.currentTimeMillis();
                    break block23;
                }
                if (settingsFile.lastModified() <= this.lastSettingsLoad) break block23;
                this.settingsDocument = SoapuiSettingsDocumentConfig.Factory.parse((File)settingsFile);
                byte[] encryptedContent = this.settingsDocument.getSoapuiSettings().getEncryptedContent();
                if (encryptedContent != null) {
                    char[] password = null;
                    if (this.password == null) {
                        JPasswordField passwordField = new JPasswordField();
                        JLabel qLabel = new JLabel("Password");
                        JOptionPane.showConfirmDialog(null, new Object[]{qLabel, passwordField}, "Global Settings", 2);
                        password = passwordField.getPassword();
                    } else {
                        password = this.password.toCharArray();
                    }
                    byte[] data = OpenSSL.decrypt((String)"des3", (char[])password, (byte[])encryptedContent);
                    try {
                        this.settingsDocument = SoapuiSettingsDocumentConfig.Factory.parse((String)new String(data, "UTF-8"));
                    }
                    catch (Exception e) {
                        log.warn((Object)"Wrong password.");
                        JOptionPane.showMessageDialog(null, "Wrong password, creating backup settings file [ " + settingsFile.getAbsolutePath() + ".bak.xml. ]\nSwitch to default settings.", "Error - Wrong Password", 0);
                        this.settingsDocument.save(new File(settingsFile.getAbsolutePath() + ".bak.xml"));
                        throw e;
                    }
                }
                log.info((Object)("initialized soapui-settings from [" + settingsFile.getAbsolutePath() + "]"));
                this.lastSettingsLoad = settingsFile.lastModified();
                if (this.settingsWatcher == null) {
                    this.settingsWatcher = new SettingsWatcher();
                    SoapUI.getSoapUITimer().scheduleAtFixedRate(this.settingsWatcher, 10000L, 10000L);
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to load settings from [" + e.getMessage() + "], creating new"));
                this.settingsDocument = SoapuiSettingsDocumentConfig.Factory.newInstance();
                this.lastSettingsLoad = 0L;
            }
        }
        if (this.settingsDocument.getSoapuiSettings() == null) {
            this.settingsDocument.addNewSoapuiSettings();
            this.settings = new XmlBeansSettingsImpl(null, null, this.settingsDocument.getSoapuiSettings());
            this.initDefaultSettings(this.settings);
        } else {
            this.settings = new XmlBeansSettingsImpl(null, null, this.settingsDocument.getSoapuiSettings());
        }
        this.settingsFile = settingsFile.getAbsolutePath();
        if (!this.settings.isSet(WsdlSettings.EXCLUDED_TYPES)) {
            list = new StringList();
            list.add("schema@http://www.w3.org/2001/XMLSchema");
            this.settings.setString(WsdlSettings.EXCLUDED_TYPES, list.toXml());
        }
        if (!this.settings.isSet(WebRecordingSettings.EXCLUDED_HEADERS)) {
            list = new StringList();
            list.add("Cookie");
            list.add("Set-Cookie");
            list.add("Referer");
            list.add("Keep-Alive");
            list.add("Connection");
            list.add("Proxy-Connection");
            list.add("Pragma");
            list.add("Cache-Control");
            list.add("Transfer-Encoding");
            list.add("Date");
            this.settings.setString(WebRecordingSettings.EXCLUDED_HEADERS, list.toXml());
        }
        if (this.settings.getString(HttpSettings.HTTP_VERSION, "1.1").equals("0.9")) {
            this.settings.setString(HttpSettings.HTTP_VERSION, "1.1");
        }
        this.setIfNotSet(WsdlSettings.NAME_WITH_BINDING, true);
        this.setIfNotSet(WsdlSettings.NAME_WITH_BINDING, 500L);
        this.setIfNotSet(HttpSettings.HTTP_VERSION, "1.1");
        this.setIfNotSet(HttpSettings.MAX_TOTAL_CONNECTIONS, 2000L);
        this.setIfNotSet(HttpSettings.RESPONSE_COMPRESSION, true);
        this.setIfNotSet(HttpSettings.LEAVE_MOCKENGINE, true);
        this.setIfNotSet(UISettings.AUTO_SAVE_PROJECTS_ON_EXIT, true);
        this.setIfNotSet(UISettings.SHOW_DESCRIPTIONS, true);
        this.setIfNotSet(WsdlSettings.XML_GENERATION_ALWAYS_INCLUDE_OPTIONAL_ELEMENTS, true);
        this.setIfNotSet(WsaSettings.USE_DEFAULT_RELATES_TO, true);
        this.setIfNotSet(WsaSettings.USE_DEFAULT_RELATIONSHIP_TYPE, true);
        this.setIfNotSet(UISettings.SHOW_STARTUP_PAGE, true);
        this.setIfNotSet(UISettings.GC_INTERVAL, "60");
        this.setIfNotSet(WsdlSettings.CACHE_WSDLS, true);
        this.setIfNotSet(WsdlSettings.PRETTY_PRINT_RESPONSE_MESSAGES, true);
        this.setIfNotSet(HttpSettings.RESPONSE_COMPRESSION, true);
        this.setIfNotSet(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN, true);
        this.setIfNotSet(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN, true);
        this.setIfNotSet(HttpSettings.LEAVE_MOCKENGINE, true);
        this.setIfNotSet(UISettings.AUTO_SAVE_INTERVAL, "0");
        this.setIfNotSet(UISettings.GC_INTERVAL, "60");
        this.setIfNotSet(UISettings.SHOW_STARTUP_PAGE, true);
        this.setIfNotSet(WsaSettings.SOAP_ACTION_OVERRIDES_WSA_ACTION, false);
        this.setIfNotSet(WsaSettings.USE_DEFAULT_RELATIONSHIP_TYPE, true);
        this.setIfNotSet(WsaSettings.USE_DEFAULT_RELATES_TO, true);
        this.setIfNotSet(WsaSettings.OVERRIDE_EXISTING_HEADERS, false);
        this.setIfNotSet(WsaSettings.ENABLE_FOR_OPTIONAL, false);
        this.setIfNotSet(VersionUpdateSettings.AUTO_CHECK_VERSION_UPDATE, true);
        boolean setWsiDir = false;
        String wsiLocationString = this.settings.getString(WSISettings.WSI_LOCATION, null);
        if (StringUtils.isNullOrEmpty(wsiLocationString)) {
            setWsiDir = true;
        } else {
            File wsiFile = new File(wsiLocationString);
            if (!wsiFile.exists()) {
                setWsiDir = true;
            }
        }
        if (setWsiDir) {
            String wsiDir = System.getProperty("wsi.dir", new File(".").getAbsolutePath());
            this.settings.setString(WSISettings.WSI_LOCATION, wsiDir);
        }
        HttpClientSupport.addSSLListener(this.settings);
        return this.settings;
    }

    private void setIfNotSet(String id, boolean value) {
        if (!this.settings.isSet(id)) {
            this.settings.setBoolean(id, true);
        }
    }

    private void setIfNotSet(String id, String value) {
        if (!this.settings.isSet(id)) {
            this.settings.setString(id, value);
        }
    }

    private void setIfNotSet(String id, long value) {
        if (!this.settings.isSet(id)) {
            this.settings.setLong(id, value);
        }
    }

    public Settings importSettings(File file) throws Exception {
        if (file != null) {
            log.info((Object)("Importing preferences from [" + file.getAbsolutePath() + "]"));
            return this.initSettings(file.getAbsolutePath());
        }
        return null;
    }

    public Settings getSettings() {
        if (this.settings == null) {
            this.initSettings("soapui-settings.xml");
        }
        return this.settings;
    }

    protected void initDefaultSettings(Settings settings2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveSettings() throws Exception {
        PropertyExpansionUtils.saveGlobalProperties();
        SecurityScanUtil.saveGlobalSecuritySettings();
        this.isSavingSettings = true;
        try {
            File file;
            if (this.settingsFile == null) {
                this.settingsFile = this.getRoot() + File.separatorChar + "soapui-settings.xml";
            }
            if (!(file = new File(this.settingsFile)).canWrite()) {
                file = new File(new File(System.getProperty("user.home", ".")), "soapui-settings.xml");
            }
            SoapuiSettingsDocumentConfig settingsDocument = (SoapuiSettingsDocumentConfig)this.settingsDocument.copy();
            String password = this.settings.getString(SecuritySettings.SHADOW_PASSWORD, null);
            if (password != null && password.length() > 0) {
                try {
                    byte[] data = settingsDocument.xmlText().getBytes();
                    byte[] encryptedData = OpenSSL.encrypt((String)"des3", (char[])password.toCharArray(), (byte[])data);
                    settingsDocument.setSoapuiSettings(null);
                    settingsDocument.getSoapuiSettings().setEncryptedContent(encryptedData);
                }
                catch (UnsupportedEncodingException e) {
                    log.error((Object)"Encryption error", (Throwable)e);
                }
                catch (IOException e) {
                    log.error((Object)"Encryption error", (Throwable)e);
                }
                catch (GeneralSecurityException e) {
                    log.error((Object)"Encryption error", (Throwable)e);
                }
            }
            FileOutputStream out = new FileOutputStream(file);
            settingsDocument.save((OutputStream)out);
            out.flush();
            out.close();
            log.info((Object)("Settings saved to [" + file.getAbsolutePath() + "]"));
            this.lastSettingsLoad = file.lastModified();
            String string = file.getAbsolutePath();
            Object var7_9 = null;
            this.isSavingSettings = false;
            return string;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.isSavingSettings = false;
            throw throwable;
        }
    }

    public String getSettingsFile() {
        return this.settingsFile;
    }

    public void setSettingsFile(String settingsFile) {
        this.settingsFile = settingsFile;
    }

    protected void initLog() {
        if (!this.logIsInitialized) {
            File log4jconfig;
            String logFileName = System.getProperty("soapui.log4j.config", "soapui-log4j.xml");
            File file = log4jconfig = this.root == null ? new File(logFileName) : new File(new File(this.getRoot()), logFileName);
            if (log4jconfig.exists()) {
                System.out.println("Configuring log4j from [" + log4jconfig.getAbsolutePath() + "]");
                DOMConfigurator.configureAndWatch((String)log4jconfig.getAbsolutePath(), (long)5000L);
            } else {
                URL url = SoapUI.class.getResource("/com/eviware/soapui/resources/conf/soapui-log4j.xml");
                if (url != null) {
                    DOMConfigurator.configure((URL)url);
                } else {
                    System.err.println("Missing soapui-log4j.xml configuration");
                }
            }
            this.logIsInitialized = true;
            log = Logger.getLogger(DefaultSoapUICore.class);
        }
    }

    public synchronized void loadExternalLibraries() {
        if (this.extClassLoader == null) {
            try {
                this.extClassLoader = SoapUIExtensionClassLoader.create(this.getRoot(), this.getExtensionClassLoaderParent());
            }
            catch (MalformedURLException e) {
                SoapUI.logError(e);
            }
        }
    }

    protected ClassLoader getExtensionClassLoaderParent() {
        return SoapUI.class.getClassLoader();
    }

    public SoapUIExtensionClassLoader getExtensionClassLoader() {
        if (this.extClassLoader == null) {
            this.loadExternalLibraries();
        }
        return this.extClassLoader;
    }

    public MockEngine getMockEngine() {
        if (this.mockEngine == null) {
            this.mockEngine = this.buildMockEngine();
        }
        return this.mockEngine;
    }

    protected MockEngine buildMockEngine() {
        return new JettyMockEngine();
    }

    public SoapUIListenerRegistry getListenerRegistry() {
        if (this.listenerRegistry == null) {
            this.initListenerRegistry();
        }
        return this.listenerRegistry;
    }

    protected void initListenerRegistry() {
        this.listenerRegistry = new SoapUIListenerRegistry(null);
    }

    public SoapUIActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = this.initActionRegistry();
        }
        return this.actionRegistry;
    }

    protected SoapUIActionRegistry initActionRegistry() {
        return new SoapUIActionRegistry(DefaultSoapUICore.class.getResourceAsStream("/com/eviware/soapui/resources/conf/soapui-actions.xml"));
    }

    protected void addExternalListeners(String folder, ClassLoader classLoader) {
        File[] actionFiles = new File(folder).listFiles();
        if (actionFiles != null) {
            for (File actionFile : actionFiles) {
                if (actionFile.isDirectory()) {
                    this.addExternalListeners(actionFile.getAbsolutePath(), classLoader);
                    continue;
                }
                if (!actionFile.getName().toLowerCase().endsWith("-listeners.xml")) continue;
                try {
                    log.info((Object)("Adding listeners from [" + actionFile.getAbsolutePath() + "]"));
                    SoapUI.getListenerRegistry().addConfig(new FileInputStream(actionFile), classLoader);
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        }
    }

    protected void addExternalFactories(String folder, ClassLoader classLoader) {
        File[] factoryFiles = new File(folder).listFiles();
        if (factoryFiles != null) {
            for (File factoryFile : factoryFiles) {
                if (factoryFile.isDirectory()) {
                    this.addExternalListeners(factoryFile.getAbsolutePath(), classLoader);
                    continue;
                }
                if (!factoryFile.getName().toLowerCase().endsWith("-factories.xml")) continue;
                try {
                    log.info((Object)("Adding factories from [" + factoryFile.getAbsolutePath() + "]"));
                    this.getFactoryRegistry().addConfig(new FileInputStream(factoryFile), classLoader);
                }
                catch (Exception e) {
                    SoapUI.logError(e);
                }
            }
        }
    }

    public SoapUIFactoryRegistry getFactoryRegistry() {
        if (this.factoryRegistry == null) {
            this.initFactoryRegistry();
        }
        return this.factoryRegistry;
    }

    protected void initFactoryRegistry() {
        this.factoryRegistry = new SoapUIFactoryRegistry(null);
    }

    protected void initSecurityScanRegistry() {
        this.securityScanRegistry = SecurityScanRegistry.getInstance();
    }

    public SecurityScanRegistry getSecurityScanRegistry() {
        if (this.securityScanRegistry == null) {
            this.initSecurityScanRegistry();
        }
        return this.securityScanRegistry;
    }

    private class SettingsWatcher
    extends TimerTask {
        private SettingsWatcher() {
        }

        public void run() {
            File file;
            if (DefaultSoapUICore.this.settingsFile != null && !DefaultSoapUICore.this.isSavingSettings && (file = new File(DefaultSoapUICore.this.settingsFile)).exists() && file.lastModified() > DefaultSoapUICore.this.lastSettingsLoad) {
                log.info((Object)"Reloading updated settings file");
                DefaultSoapUICore.this.initSettings(DefaultSoapUICore.this.settingsFile);
                SoapUI.setProxyEnabled(DefaultSoapUICore.this.getSettings().getBoolean(ProxySettings.ENABLE_PROXY));
            }
        }
    }
}

