/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.util.Resize;

public class ShapePainter
extends AbstractPainter {
    private Shape shape;
    private Stroke stroke;
    private Paint fillPaint;
    private Paint strokePaint;
    private Point2D location = new Point2D.Double(0.0, 0.0);
    private Resize resizeLocation = Resize.BOTH;
    private Resize resize = Resize.BOTH;
    private Style style = Style.BOTH;

    public ShapePainter() {
    }

    public ShapePainter(Shape shape) {
        this.shape = shape;
    }

    public ShapePainter(Shape shape, Paint paint) {
        this.shape = shape;
        this.fillPaint = paint;
    }

    public ShapePainter(Shape shape, Paint paint, Style style) {
        this.shape = shape;
        this.fillPaint = paint;
        this.style = style == null ? Style.BOTH : style;
    }

    public void setShape(Shape s) {
        Shape old = this.getShape();
        this.shape = s;
        this.firePropertyChange("shape", old, this.getShape());
    }

    public Shape getShape() {
        return this.shape;
    }

    public void setStroke(Stroke s) {
        Stroke old = this.getStroke();
        this.stroke = s;
        this.firePropertyChange("stroke", old, this.getStroke());
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setFillPaint(Paint p) {
        Paint old = this.getFillPaint();
        this.fillPaint = p;
        this.firePropertyChange("fillPaint", old, this.getFillPaint());
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setStrokePaint(Paint p) {
        Paint old = this.getStrokePaint();
        this.strokePaint = p;
        this.firePropertyChange("strokePaint", old, this.getStrokePaint());
    }

    public Paint getStrokePaint() {
        return this.strokePaint;
    }

    public void setLocation(Point2D location) {
        Point2D old = this.getLocation();
        this.location = location == null ? new Point2D.Double(0.0, 0.0) : location;
        this.firePropertyChange("location", old, this.getLocation());
    }

    public Point2D getLocation() {
        return this.location;
    }

    public void setStyle(Style s) {
        Style old = this.getStyle();
        this.style = s == null ? Style.BOTH : s;
        this.firePropertyChange("style", (Object)old, (Object)this.getStyle());
    }

    public Style getStyle() {
        return this.style;
    }

    public void setResizeLocation(Resize r) {
        Resize old = this.getResizeLocation();
        this.resizeLocation = r == null ? Resize.NONE : r;
        this.firePropertyChange("resizeLocation", (Object)old, (Object)this.getResizeLocation());
    }

    public Resize getResizeLocation() {
        return this.resizeLocation;
    }

    public void setResize(Resize r) {
        Resize old = this.getResize();
        this.resize = r == null ? Resize.NONE : r;
        this.firePropertyChange("resize", (Object)old, (Object)this.getResize());
    }

    public Resize getResize() {
        return this.resize;
    }

    public void paintBackground(Graphics2D g, JComponent component) {
        Stroke s = this.getStroke();
        if (s != null) {
            g.setStroke(s);
        }
        Point2D location = this.getLocation();
        Resize resizeLocation = this.getResizeLocation();
        double x = location.getX();
        double y = location.getY();
        if (resizeLocation == Resize.HORIZONTAL || resizeLocation == Resize.BOTH) {
            x *= (double)component.getWidth();
        }
        if (resizeLocation == Resize.VERTICAL || resizeLocation == Resize.BOTH) {
            y *= (double)component.getHeight();
        }
        g.translate(-location.getX(), -location.getY());
        Shape shape = this.getShape();
        Rectangle2D bounds = shape.getBounds2D();
        double width = 1.0;
        double height = 1.0;
        Resize resize = this.getResize();
        if (resize == Resize.HORIZONTAL || resize == Resize.BOTH) {
            width = component.getWidth() - 1;
        }
        if (resize == Resize.VERTICAL || resize == Resize.BOTH) {
            height = component.getHeight() - 1;
        }
        if (shape instanceof RoundRectangle2D) {
            RoundRectangle2D rect = (RoundRectangle2D)shape;
            shape = new RoundRectangle2D.Double(rect.getX(), rect.getY(), width, height, rect.getArcWidth(), rect.getArcHeight());
        } else {
            shape = AffineTransform.getScaleInstance(width, height).createTransformedShape(shape);
        }
        switch (this.getStyle()) {
            case BOTH: {
                g.setPaint(this.calculateStrokePaint(component));
                g.draw(shape);
                g.setPaint(this.calculateFillPaint(component));
                g.fill(shape);
                break;
            }
            case FILLED: {
                g.setPaint(this.calculateFillPaint(component));
                g.fill(shape);
                break;
            }
            case OUTLINE: {
                g.setPaint(this.calculateStrokePaint(component));
                g.draw(shape);
            }
        }
    }

    private Paint calculateStrokePaint(JComponent component) {
        Paint p = this.getStrokePaint();
        if (p == null) {
            p = component.getForeground();
        }
        return p;
    }

    private Paint calculateFillPaint(JComponent component) {
        Paint p = this.getFillPaint();
        if (p == null) {
            p = component.getBackground();
        }
        return p;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        BOTH,
        FILLED,
        OUTLINE;

    }
}

