/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.painter.AbstractPainter;

public class ImagePainter
extends AbstractPainter {
    private static final Logger LOG = Logger.getLogger(ImagePainter.class.getName());
    private Image img;
    private Style style = Style.CENTERED;
    private Point2D imagePosition = new Point2D.Double(0.0, 0.0);
    private double imageScale = 1.0;

    public ImagePainter() {
    }

    public ImagePainter(Image image) {
        this.img = image;
    }

    public ImagePainter(Image image, Style style) {
        this.img = image;
        this.style = style;
    }

    public void setImage(Image image) {
        if (image != this.img) {
            Image oldImage = this.img;
            this.img = image;
            this.firePropertyChange("image", oldImage, this.img);
        }
    }

    public Image getImage() {
        return this.img;
    }

    public void setStyle(Style s) {
        if (this.style != s) {
            Style oldStyle = this.style;
            this.style = s;
            this.firePropertyChange("style", (Object)oldStyle, (Object)s);
        }
    }

    public Style getStyle() {
        return this.style;
    }

    public void paintBackground(Graphics2D g, JComponent component) {
        if (this.img != null) {
            int imgWidth = this.img.getWidth(null);
            int imgHeight = this.img.getHeight(null);
            if (imgWidth != -1 && imgHeight != -1) {
                switch (this.style) {
                    case CENTERED: {
                        Rectangle clipRect = g.getClipBounds();
                        int imageX = (component.getWidth() - imgWidth) / 2;
                        int imageY = (component.getHeight() - imgHeight) / 2;
                        Rectangle r = SwingUtilities.computeIntersection(imageX, imageY, imgWidth, imgHeight, clipRect);
                        if (r.x == 0 && r.y == 0 && (r.width == 0 || r.height == 0)) {
                            return;
                        }
                        clipRect = r;
                        int txClipX = clipRect.x - imageX;
                        int txClipY = clipRect.y - imageY;
                        int txClipW = clipRect.width;
                        int txClipH = clipRect.height;
                        g.drawImage(this.img, clipRect.x, clipRect.y, clipRect.x + clipRect.width, clipRect.y + clipRect.height, txClipX, txClipY, txClipX + txClipW, txClipY + txClipH, null);
                        break;
                    }
                    case TILED: {
                        if (this.img instanceof BufferedImage) {
                            BufferedImage b = (BufferedImage)this.img;
                            TexturePaint paint = new TexturePaint(b, new Rectangle2D.Double(0.0, 0.0, b.getWidth(), b.getHeight()));
                            g.setPaint(paint);
                            g.fillRect(0, 0, component.getWidth(), component.getHeight());
                        } else {
                            LOG.fine("unimplemented");
                        }
                    }
                    case SCALED: {
                        g.drawImage(this.img, 0, 0, component.getWidth(), component.getHeight(), null);
                        break;
                    }
                    case POSITIONED: {
                        g.drawImage(this.img, (int)this.imagePosition.getX(), (int)this.imagePosition.getY(), (int)((double)this.img.getWidth(null) * this.imageScale), (int)((double)this.img.getHeight(null) * this.imageScale), null);
                        break;
                    }
                    case CSS_POSITIONED: {
                        double x = this.imagePosition.getX() * (double)(component.getWidth() - this.img.getWidth(null));
                        double y = this.imagePosition.getY() * (double)(component.getHeight() - this.img.getHeight(null));
                        g.drawImage(this.img, (int)x, (int)y, null);
                        break;
                    }
                    default: {
                        LOG.fine("unimplemented");
                        g.drawImage(this.img, 0, 0, null);
                    }
                }
            }
        }
    }

    public void setImagePosition(Point2D imagePosition) {
        this.imagePosition = imagePosition;
    }

    public Point2D getImagePosition() {
        return this.imagePosition;
    }

    public void setImageScale(double imageScale) {
        this.imageScale = imageScale;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        CENTERED,
        TILED,
        SCALED,
        POSITIONED,
        CSS_POSITIONED;

    }
}

