/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.xml.schema;

import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.WSIException;
import org.wsi.test.util.TestUtils;
import org.wsi.xml.XMLDocumentCache;
import org.wsi.xml.XMLTags;
import org.wsi.xml.XMLUtils;
import org.wsi.xml.schema.XMLSchemaProcessor;

public class TargetNamespaceProcessor
extends XMLSchemaProcessor {
    public TargetNamespaceProcessor(String string, XMLDocumentCache xMLDocumentCache) {
        super(string, xMLDocumentCache, false);
    }

    protected void processSchema(Element element) {
        String string = null;
        Attr attr = XMLUtils.getAttribute(element, XMLTags.ATTR_XSD_TARGETNAMESPACE);
        if (attr != null && (string = attr.getValue()) != null) {
            this.returnList.add(string);
        }
    }

    public List processAllSchema(Node node) throws WSIException {
        return this.processAllSchema(node, this.context);
    }

    private List processAllSchema(Node node, String string) throws WSIException {
        if (XMLUtils.equals(node, XMLTags.ELEM_XSD_SCHEMA)) {
            this.processSchema((Element)node);
            for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                Attr attr;
                if (1 != node2.getNodeType() || !XMLUtils.equals(node2, XMLTags.ELEM_XSD_IMPORT) || (attr = XMLUtils.getAttribute((Element)node2, XMLTags.ATTR_XSD_SCHEMALOCATION)) == null || attr.getValue() == null || this.schemaLocations.contains(attr.getValue())) continue;
                this.schemaLocations.add(attr.getValue());
                try {
                    Document document = this.parseXMLDocumentURL(attr.getValue(), string, TestUtils.getXMLSchemaLocation());
                    this.processAllSchema(document.getDocumentElement(), XMLUtils.createURLString(attr.getValue(), string));
                    continue;
                }
                catch (WSIException wSIException) {
                    if (!this.throwException) continue;
                    throw wSIException;
                }
                catch (Throwable throwable) {
                    if (!this.throwException) continue;
                    throw new WSIException(throwable.getMessage(), throwable);
                }
            }
        }
        return this.returnList;
    }
}

