/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.xml;

import com.ibm.wsdl.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.jaxp.SAXParserFactoryImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.util.NullUtil;
import org.wsi.xml.jaxp.DocumentBuilderFactoryImpl;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public final class XMLUtils {
    public static final String FEATURE_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    public static final String FEATURE_NAMESPACES = "http://xml.org/sax/features/namespaces";
    public static final String FEATURE_VALIDATION_SCHEMA = "http://apache.org/xml/features/validation/schema";
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String W3C_SOAP_12_SCHEMA = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String PROPERTY_EXTERNAL_SCHEMA_LOCATION = "http://apache.org/xml/properties/schema/external-schemaLocation";
    public static final String SOAP_ELEM_ENVELOPE = "Envelope";
    public static final String SOAP_ELEM_HEADER = "Header";
    public static final String SOAP_ELEM_BODY = "Body";
    public static final String SOAP_ELEM_FAULT = "Fault";
    public static final String SOAP_ELEM_FAULT_CODE = "faultcode";
    public static final String SOAP_ELEM_FAULT_STRING = "faultstring";
    public static final String SOAP_ELEM_FAULT_DETAIL = "detail";
    public static final String SOAP_ELEM_FAULT_ACTOR = "faultactor";
    public static final String SOAP_ATTR_MUST_UNDERSTAND = "mustUnderstand";
    public static final String SOAP_ATTR_ACTOR = "actor";
    static /* synthetic */ Class class$org$wsi$xml$XMLUtils;

    public static XMLReader getXMLReader() throws WSIException {
        XMLReader xMLReader = null;
        try {
            xMLReader = new SAXParserFactoryImpl().newSAXParser().getXMLReader();
            xMLReader.setFeature(FEATURE_NAMESPACE_PREFIXES, true);
            xMLReader.setFeature(FEATURE_NAMESPACES, true);
        }
        catch (Exception exception) {
            throw new WSIException("Could not get XMLReader implementation.", exception);
        }
        return xMLReader;
    }

    public static Document parseXML(String string, boolean bl) throws WSIException {
        return XMLUtils.parseXML((Reader)new StringReader(string), bl);
    }

    public static Document parseXML(String string) throws WSIException {
        return XMLUtils.parseXML(new StringReader(string));
    }

    public static Document parseXMLDocument(String string) throws WSIException, IOException {
        return XMLUtils.parseXMLDocument(string, null);
    }

    public static Document parseXMLDocument(String string, String string2) throws WSIException, IOException {
        URL uRL = StringUtils.getURL(null, (String)string);
        InputStream inputStream = StringUtils.getContentAsInputStream((URL)uRL);
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(uRL.toString());
        if (string2 == null) {
            return XMLUtils.parseXML(inputSource, false);
        }
        return XMLUtils.parseXML(inputSource, string2);
    }

    public static Document parseXMLDocumentURL(String string, String string2, String string3) throws WSIException {
        Document document = null;
        try {
            document = XMLUtils.parseXMLDocumentURL(XMLUtils.createURL(string, string3), string2);
        }
        catch (Exception exception) {
            throw new WSIException(exception.getMessage(), exception);
        }
        return XMLUtils.parseXMLDocumentURL(string, string2);
    }

    public static Document parseXMLDocumentURL(URL uRL, String string) throws WSIException {
        try {
            InputStream inputStream = StringUtils.getContentAsInputStream((URL)uRL);
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(uRL.toString());
            Document document = null;
            document = string == null ? XMLUtils.parseXML(inputSource) : XMLUtils.parseXML(inputSource, string);
            inputStream.close();
            return document;
        }
        catch (WSIException wSIException) {
            throw wSIException;
        }
        catch (Throwable throwable) {
            throw new WSIException(throwable.getMessage());
        }
    }

    public static Document parseXMLDocumentURL(String string, String string2) throws WSIException {
        Document document = null;
        try {
            URL uRL = XMLUtils.createURL(string, string2);
            document = XMLUtils.parseXMLDocumentURL(uRL);
        }
        catch (WSIException wSIException) {
            throw wSIException;
        }
        catch (Exception exception) {
            throw new WSIException(exception.getMessage(), exception);
        }
        return document;
    }

    public static Document parseXMLDocumentURL(URL uRL) throws WSIException {
        Document document = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            InputSource inputSource = new InputSource(inputStreamReader);
            inputSource.setSystemId(uRL.toString());
            document = XMLUtils.parseXML(inputSource);
            ((Reader)inputStreamReader).close();
        }
        catch (Exception exception) {
            throw new WSIException(exception.getMessage(), exception);
        }
        return document;
    }

    public static Document parseXML(InputSource inputSource, boolean bl) throws WSIException {
        Document document = null;
        DocumentBuilderFactoryImpl documentBuilderFactoryImpl = new DocumentBuilderFactoryImpl();
        documentBuilderFactoryImpl.setNamespaceAware(true);
        documentBuilderFactoryImpl.setIgnoringElementContentWhitespace(true);
        documentBuilderFactoryImpl.setValidating(bl);
        try {
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)documentBuilderFactoryImpl).newDocumentBuilder();
            document = documentBuilder.parse(inputSource);
            if (document instanceof DocumentImpl && ((DocumentImpl)document).getXmlVersion().equals("1.1")) {
                throw new WSIException("Fatal Error: XML version &quot;1.1&quot; is not supported, only XML 1.0 is supported.");
            }
        }
        catch (Exception exception) {
            throw new WSIException("Could not parse XML document.", exception);
        }
        return document;
    }

    public static Document parseXML(Reader reader, boolean bl) throws WSIException {
        Document document = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((class$org$wsi$xml$XMLUtils == null ? (class$org$wsi$xml$XMLUtils = XMLUtils.class$("org.wsi.xml.XMLUtils")) : class$org$wsi$xml$XMLUtils).getClassLoader());
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            InputSource inputSource = new InputSource(reader);
            DocumentBuilderFactoryImpl documentBuilderFactoryImpl = new DocumentBuilderFactoryImpl();
            documentBuilderFactoryImpl.setNamespaceAware(true);
            documentBuilderFactoryImpl.setIgnoringElementContentWhitespace(true);
            documentBuilderFactoryImpl.setValidating(bl);
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)documentBuilderFactoryImpl).newDocumentBuilder();
            document = documentBuilder.parse(inputSource);
            if (document instanceof DocumentImpl && ((DocumentImpl)document).getXmlVersion().equals("1.1")) {
                throw new WSIException("Fatal Error: XML version &quot;1.1&quot; is not supported, only XML 1.0 is supported.");
            }
        }
        catch (Exception exception) {
            throw new WSIException("Could not parse XML document.", exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return document;
    }

    public static Document parseXML(Reader reader) throws WSIException {
        return XMLUtils.parseXML(reader, false);
    }

    public static Document parseXML(InputSource inputSource) throws WSIException {
        return XMLUtils.parseXML(inputSource, false);
    }

    public static Document parseXML(String string, String string2) throws WSIException {
        return XMLUtils.parseXML((Reader)new StringReader(string), string2);
    }

    public static Document parseXML(String string, Collection collection) throws WSIException {
        return XMLUtils.parseXML((Reader)new StringReader(string), collection);
    }

    public static Document parseXML(String string, StringReader stringReader) throws WSIException, IOException {
        return XMLUtils.parseXML((Reader)new StringReader(string), stringReader);
    }

    public static Document parseXML(Reader reader, String string) throws WSIException {
        Document document = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((class$org$wsi$xml$XMLUtils == null ? (class$org$wsi$xml$XMLUtils = XMLUtils.class$("org.wsi.xml.XMLUtils")) : class$org$wsi$xml$XMLUtils).getClassLoader());
            InputSource inputSource = new InputSource(reader);
            DocumentBuilderFactoryImpl documentBuilderFactoryImpl = new DocumentBuilderFactoryImpl();
            documentBuilderFactoryImpl.setNamespaceAware(true);
            documentBuilderFactoryImpl.setIgnoringElementContentWhitespace(true);
            try {
                documentBuilderFactoryImpl.setValidating(true);
                ((DocumentBuilderFactory)documentBuilderFactoryImpl).setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string2 = "Error: JAXP DocumentBuilderFactory attribute not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage\nCheck to see if parser conforms to JAXP 1.2 spec.";
                throw new WSIException(string2, illegalArgumentException);
            }
            ((DocumentBuilderFactory)documentBuilderFactoryImpl).setAttribute(JAXP_SCHEMA_SOURCE, new InputSource(string));
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)documentBuilderFactoryImpl).newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrHandler());
            document = documentBuilder.parse(inputSource);
            if (document instanceof DocumentImpl && ((DocumentImpl)document).getXmlVersion().equals("1.1")) {
                throw new WSIException("Fatal Error: XML version &quot;1.1&quot; is not supported, only XML 1.0 is supported.");
            }
        }
        catch (Exception exception) {
            throw new WSIException("Could not parse XML document.", exception);
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        return document;
    }

    public static Document parseXML(InputSource inputSource, String string) throws WSIException {
        Document document = null;
        DocumentBuilderFactoryImpl documentBuilderFactoryImpl = new DocumentBuilderFactoryImpl();
        documentBuilderFactoryImpl.setNamespaceAware(true);
        documentBuilderFactoryImpl.setIgnoringElementContentWhitespace(true);
        documentBuilderFactoryImpl.setValidating(true);
        try {
            ((DocumentBuilderFactory)documentBuilderFactoryImpl).setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = "Error: JAXP DocumentBuilderFactory attribute not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage\nCheck to see if parser conforms to JAXP 1.2 spec.";
            throw new WSIException(string2, illegalArgumentException);
        }
        ((DocumentBuilderFactory)documentBuilderFactoryImpl).setAttribute(JAXP_SCHEMA_SOURCE, new InputSource(string));
        try {
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)documentBuilderFactoryImpl).newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrHandler());
            document = documentBuilder.parse(inputSource);
            if (document instanceof DocumentImpl && ((DocumentImpl)document).getXmlVersion().equals("1.1")) {
                throw new WSIException("Fatal Error: XML version &quot;1.1&quot; is not supported, only XML 1.0 is supported.");
            }
        }
        catch (Exception exception) {
            throw new WSIException("Could not parse XML document.", exception);
        }
        return document;
    }

    public static Document parseXML(Reader reader, StringReader stringReader) throws WSIException {
        Document document = null;
        InputSource inputSource = new InputSource(reader);
        DocumentBuilderFactoryImpl documentBuilderFactoryImpl = new DocumentBuilderFactoryImpl();
        documentBuilderFactoryImpl.setNamespaceAware(true);
        documentBuilderFactoryImpl.setIgnoringElementContentWhitespace(true);
        documentBuilderFactoryImpl.setValidating(true);
        try {
            ((DocumentBuilderFactory)documentBuilderFactoryImpl).setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = "Error: JAXP DocumentBuilderFactory attribute not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage\nCheck to see if parser conforms to JAXP 1.2 spec.";
            throw new WSIException(string, illegalArgumentException);
        }
        ((DocumentBuilderFactory)documentBuilderFactoryImpl).setAttribute(JAXP_SCHEMA_SOURCE, new InputSource(stringReader));
        try {
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)documentBuilderFactoryImpl).newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrHandler());
            document = documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            throw new WSIException("Could not parse XML document.", exception);
        }
        return document;
    }

    public static Document parseXML(Reader reader, Collection collection) throws WSIException {
        InputSource[] inputSourceArray;
        Document document = null;
        InputSource inputSource = new InputSource(reader);
        DocumentBuilderFactoryImpl documentBuilderFactoryImpl = new DocumentBuilderFactoryImpl();
        documentBuilderFactoryImpl.setNamespaceAware(true);
        documentBuilderFactoryImpl.setIgnoringElementContentWhitespace(true);
        documentBuilderFactoryImpl.setValidating(true);
        try {
            ((DocumentBuilderFactory)documentBuilderFactoryImpl).setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = "Error: JAXP DocumentBuilderFactory attribute not recognized: http://java.sun.com/xml/jaxp/properties/schemaLanguage\nCheck to see if parser conforms to JAXP 1.2 spec.";
            throw new WSIException(string, illegalArgumentException);
        }
        Iterator iterator = collection.iterator();
        Vector<InputSource> vector = new Vector<InputSource>();
        while (iterator.hasNext()) {
            inputSourceArray = (InputSource[])iterator.next();
            vector.add(new InputSource(new StringReader((String)inputSourceArray)));
        }
        inputSourceArray = vector.toArray(new InputSource[0]);
        ((DocumentBuilderFactory)documentBuilderFactoryImpl).setAttribute(JAXP_SCHEMA_SOURCE, inputSourceArray);
        try {
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)documentBuilderFactoryImpl).newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrHandler());
            document = documentBuilder.parse(inputSource);
        }
        catch (Exception exception) {
            throw new WSIException("Could not parse XML document.", exception);
        }
        return document;
    }

    public static String getAttributeValue(Element element, String string) {
        String string2 = null;
        Attr attr = null;
        attr = element.getAttributeNode(string);
        if (attr != null) {
            string2 = attr.getValue().trim();
        }
        return string2;
    }

    public static String getAttributeValue(Element element, String string, String string2) {
        String string3 = string2;
        String string4 = null;
        string4 = XMLUtils.getAttributeValue(element, string);
        if (string4 != null) {
            string3 = string4;
        }
        return string3;
    }

    public static String getAttributeValueNS(Element element, String string, String string2) {
        String string3 = null;
        Attr attr = null;
        attr = element.getAttributeNodeNS(string, string2);
        if (attr != null) {
            string3 = attr.getValue().trim();
        }
        return string3;
    }

    public static Element getFirstChild(Element element) {
        return XMLUtils.findNextSibling(element.getFirstChild());
    }

    public static Element getNextSibling(Element element) {
        return XMLUtils.findNextSibling(element.getNextSibling());
    }

    protected static Element findNextSibling(Node node) {
        Node node2 = null;
        Element element = null;
        for (node2 = node; node2 != null && element == null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            element = (Element)node2;
        }
        return element;
    }

    public static Element findPreviousSibling(Node node) {
        if (node == null) {
            return null;
        }
        while (node != null) {
            if ((node = node.getPreviousSibling()) == null) {
                return null;
            }
            if (node.getNodeType() != 1) continue;
            return (Element)node;
        }
        return null;
    }

    public static String getText(Element element) {
        String string = null;
        for (Node node = element.getFirstChild(); node != null && string == null; node = node.getNextSibling()) {
            if (node.getNodeType() != 3 && node.getNodeType() != 4) continue;
            string = ((CharacterData)node).getData();
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    public static boolean equals(QName qName, Element element) {
        boolean bl = false;
        if (qName.getNamespaceURI().equals(element.getNamespaceURI()) && qName.getLocalPart().equals(element.getLocalName())) {
            bl = true;
        }
        return bl;
    }

    public static String xmlEscapedString(String string) {
        if (string == null) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = string.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block8;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block8;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block8;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block8;
                }
                case '\r': {
                    stringBuffer.append("&#xd;");
                    continue block8;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Element getElement(String string, Element element) {
        Element element2 = null;
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList != null) {
            element2 = (Element)nodeList.item(0);
        }
        return element2;
    }

    public static boolean isElement(Element element, String string, String string2) {
        boolean bl = false;
        if (element != null && element.getNamespaceURI().equals(string) && element.getLocalName().equals(string2)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isElement(Element element, List list, String string) {
        boolean bl = false;
        if (element != null && list.contains(element.getNamespaceURI()) && element.getLocalName().equals(string)) {
            bl = true;
        }
        return bl;
    }

    public static boolean getBooleanValue(Element element, boolean bl) {
        boolean bl2 = bl;
        String string = null;
        string = XMLUtils.getText(element);
        if (string != null) {
            bl2 = Boolean.valueOf(string);
        }
        return bl2;
    }

    public static boolean getBooleanValue(Element element, String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = null;
        string2 = XMLUtils.getAttributeValue(element, string);
        if (string2 != null) {
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    public static QName createQName(String string) {
        QName qName = null;
        int n = string.lastIndexOf(":");
        qName = n != -1 ? new QName(string.substring(0, n), string.substring(n + 1)) : new QName(string);
        return qName;
    }

    public static boolean isNmtoken(String string) {
        boolean bl = true;
        return bl;
    }

    public static Element findChildElement(Element element, QName qName) {
        if (element == null) {
            throw new IllegalArgumentException("Parent element can not be NULL");
        }
        if (qName == null) {
            throw new IllegalArgumentException("Element name can not be NULL");
        }
        if (qName.getLocalPart() == null) {
            throw new IllegalArgumentException("Local part of the element name can not be NULL");
        }
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (1 != node.getNodeType() || !string.equals(node.getLocalName()) || !NullUtil.equals(string2, node.getNamespaceURI())) continue;
            return (Element)node;
        }
        return null;
    }

    public static Element findElement(Element element, QName qName) {
        if (element == null) {
            throw new IllegalArgumentException("Active element can not be NULL");
        }
        if (qName == null) {
            throw new IllegalArgumentException("Element name can not be NULL");
        }
        if (qName.getLocalPart() == null) {
            throw new IllegalArgumentException("Local part of the element name can not be NULL");
        }
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        for (Node node = element.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (1 != node.getNodeType() || !string.equals(node.getLocalName()) || !NullUtil.equals(string2, node.getNamespaceURI())) continue;
            return (Element)node;
        }
        return null;
    }

    public static Attr getAttribute(Element element, QName qName) {
        if (element == null) {
            throw new IllegalArgumentException("Element can not be NULL");
        }
        if (qName == null) {
            throw new IllegalArgumentException("Attribute name can not be NULL");
        }
        if (qName.getLocalPart() == null) {
            throw new IllegalArgumentException("Local part of the attribute name can not be NULL");
        }
        Attr attr = element.getAttributeNodeNS(qName.getNamespaceURI(), qName.getLocalPart());
        if (attr == null) {
            attr = element.getAttributeNodeNS(null, qName.getLocalPart());
        }
        return attr;
    }

    public static boolean equals(Node node, QName qName) {
        if (node == null || qName == null) {
            return false;
        }
        return NullUtil.equals(qName.getLocalPart(), node.getLocalName()) && NullUtil.equals(qName.getNamespaceURI(), node.getNamespaceURI());
    }

    public static String findNamespaceURI(Node node, String string) {
        if (string == null) {
            return null;
        }
        while (node != null) {
            NamedNodeMap namedNodeMap;
            if (string.equals(node.getPrefix())) {
                return node.getNamespaceURI();
            }
            if (1 == node.getNodeType() && (namedNodeMap = node.getAttributes()) != null) {
                for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                    Node node2 = namedNodeMap.item(i);
                    if (!"http://www.w3.org/2000/xmlns/".equals(node2.getNamespaceURI()) || !string.equals(node2.getLocalName())) continue;
                    return node2.getNodeValue();
                }
            }
            node = node.getParentNode();
        }
        return null;
    }

    public static String serialize(Element element) {
        String string = null;
        try {
            StringWriter stringWriter = new StringWriter();
            XMLSerializer xMLSerializer = new XMLSerializer((Writer)stringWriter, new OutputFormat("xml", "UTF-8", true));
            xMLSerializer.serialize(element);
            string = stringWriter.toString();
            stringWriter.close();
        }
        catch (Throwable throwable) {
            string = "EXCEPTION : " + throwable.getMessage();
        }
        return string;
    }

    public static Vector getChildElements(Element element) {
        if (element == null) {
            throw new IllegalArgumentException("Element can not be NULL");
        }
        Vector<Element> vector = new Vector<Element>();
        Element element2 = XMLUtils.getFirstChild(element);
        while (element2 != null) {
            vector.add(element2);
            element2 = XMLUtils.getNextSibling(element2);
        }
        return vector;
    }

    public static void serializeDoc(Document document, Writer writer) throws Exception {
        XMLSerializer xMLSerializer = new XMLSerializer(writer, new OutputFormat("xml", "UTF-8", true));
        xMLSerializer.serialize(document);
    }

    public static void serializeElement(Element element, Writer writer) throws Exception {
        XMLSerializer xMLSerializer = new XMLSerializer(writer, new OutputFormat("xml", "UTF-8", true));
        xMLSerializer.serialize(element);
    }

    public static void removeAllElementsWithoutNS(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            if (((Element)vector.get(n)).getNamespaceURI() == null || ((Element)vector.get(n)).getNamespaceURI().equals("")) {
                vector.remove(n);
                continue;
            }
            ++n;
        }
    }

    public static URL createURL(String string, String string2) throws MalformedURLException {
        URL uRL = null;
        URI uRI = null;
        try {
            uRL = new URL(string);
            uRI = new URI(string);
            uRI.normalize();
            uRL = new URL(uRI.toString());
        }
        catch (Exception exception) {
            int n = string2.lastIndexOf(47);
            int n2 = string2.lastIndexOf(92);
            if (n2 > n) {
                n = n2;
            }
            try {
                uRI = new URI(string2.substring(0, n + 1) + string);
                uRI.normalize();
                uRL = uRI.toURL();
            }
            catch (Exception exception2) {
                return new URL(string2.substring(0, n + 1) + string);
            }
        }
        return uRL;
    }

    public static String createURLString(String string, String string2) throws MalformedURLException {
        return XMLUtils.createURL(string, string2).toExternalForm();
    }

    public static void main(String[] stringArray) {
        try {
            System.out.println("Filename: " + stringArray[0] + ", schema: " + stringArray[1]);
            Document document = XMLUtils.parseXMLDocument(stringArray[0], stringArray[1]);
            System.out.println("Done.");
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
        System.exit(0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ErrHandler
    implements ErrorHandler {
        private ErrHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            String string = "Warning: " + sAXParseException.getMessage();
            throw new SAXException(string);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            String string = "Error: " + sAXParseException.getMessage();
            throw new SAXException(string);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            String string = "Fatal Error: " + sAXParseException.getMessage();
            throw new SAXException(string);
        }
    }
}

