/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.wsdl.traversal;

import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import org.w3c.dom.Element;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.wsdl.traversal.WSDLVisitor;

public class WSDLTraversal {
    private WSDLVisitor visitor;
    private boolean traverseBinding2BindingOperation = true;
    private boolean traverseBinding2Element = true;
    private boolean traverseBinding2ExtensibilityElement = true;
    private boolean traverseBinding2PortType = true;
    private boolean traverseBindingFault2Element = true;
    private boolean traverseBindingFault2ExtensibilityElement = true;
    private boolean traverseBindingInput2Element = true;
    private boolean traverseBindingInput2ExtensibilityElement = true;
    private boolean traverseBindingOperation2BindingFault = true;
    private boolean traverseBindingOperation2BindingInput = true;
    private boolean traverseBindingOperation2BindingOutput = true;
    private boolean traverseBindingOperation2Element = true;
    private boolean traverseBindingOperation2ExtensibilityElement = true;
    private boolean traverseBindingOperation2Operation = true;
    private boolean traverseBindingOutput2Element = true;
    private boolean traverseBindingOutput2ExtensibilityElement = true;
    private boolean traverseDefinition2Binding = true;
    private boolean traverseDefinition2Element = true;
    private boolean traverseDefinition2ExtensibilityElement = true;
    private boolean traverseDefinition2Import = true;
    private boolean traverseDefinition2Message = true;
    private boolean traverseDefinition2PortType = true;
    private boolean traverseDefinition2Service = true;
    private boolean traverseDefinition2Types = true;
    private boolean traverseFault2Element = true;
    private boolean traverseFault2Message = true;
    private boolean traverseImport2Definition = true;
    private boolean traverseImport2Element = true;
    private boolean traverseInput2Element = true;
    private boolean traverseInput2Message = true;
    private boolean traverseMessage2Element = true;
    private boolean traverseMessage2Part = true;
    private boolean traverseOperation2Element = true;
    private boolean traverseOperation2Fault = true;
    private boolean traverseOperation2Input = true;
    private boolean traverseOperation2Output = true;
    private boolean traverseOutput2Element = true;
    private boolean traverseOutput2Message = true;
    private boolean traversePart2Element = true;
    private boolean traversePort2Binding = true;
    private boolean traversePort2Element = true;
    private boolean traversePort2ExtensibilityElement = true;
    private boolean traversePortType2Element = true;
    private boolean traversePortType2Operation = true;
    private boolean traverseService2Element = true;
    private boolean traverseService2ExtensibilityElement = true;
    private boolean traverseService2Port = true;
    private boolean traverseTypes2Element = true;
    private boolean traverseTypes2ExtensibilityElement = true;
    private boolean traverseSOAPHeader2SOAPHeaderFault = true;
    private boolean traverseBinding2SOAPBinding = true;
    private boolean traverseBindingOperation2SOAPOperation = true;
    private boolean traverseBindingInput2SOAPHeader = true;
    private boolean traverseBindingInput2SOAPBody = true;
    private boolean traverseBindingOutput2SOAPHeader = true;
    private boolean traverseBindingOutput2SOAPBody = true;
    private boolean traverseBindingFault2SOAPFault = true;
    private boolean visitBinding = false;
    private boolean visitBindingFault = false;
    private boolean visitBindingInput = false;
    private boolean visitBindingOperation = false;
    private boolean visitBindingOutput = false;
    private boolean visitDefinition = false;
    private boolean visitElement = false;
    private boolean visitExtensibilityElement = false;
    private boolean visitFault = false;
    private boolean visitImport = false;
    private boolean visitInput = false;
    private boolean visitMessage = false;
    private boolean visitOperation = false;
    private boolean visitOutput = false;
    private boolean visitPart = false;
    private boolean visitPort = false;
    private boolean visitPortType = false;
    private boolean visitService = false;
    private boolean visitTypes = false;
    private boolean visitSOAPBinding = false;
    private boolean visitSOAPBody = false;
    private boolean visitSOAPFault = false;
    private boolean visitSOAPHeader = false;
    private boolean visitSOAPHeaderFault = false;
    private boolean visitSOAPOperation = false;

    public void ignoreReferences() {
        this.ignoreBinding2PortType();
        this.ignoreBindingOperation2Operation();
        this.ignoreFault2Message();
        this.ignoreInput2Message();
        this.ignoreOutput2Message();
        this.ignorePort2Binding();
    }

    public void setVisitor(WSDLVisitor wSDLVisitor) {
        this.visitor = wSDLVisitor;
    }

    public WSDLTraversal ignoreBinding2SOAPBinding() {
        this.traverseBinding2SOAPBinding = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2SOAPOperation() {
        this.traverseBindingOperation2SOAPOperation = false;
        return this;
    }

    public WSDLTraversal ignoreBindingInput2SOAPHeader() {
        this.traverseBindingInput2SOAPHeader = false;
        return this;
    }

    public WSDLTraversal ignoreBindingInput2SOAPBody() {
        this.traverseBindingInput2SOAPBody = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOutput2SOAPHeader() {
        this.traverseBindingOutput2SOAPHeader = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOutput2SOAPBody() {
        this.traverseBindingOutput2SOAPBody = false;
        return this;
    }

    public WSDLTraversal ignoreBindingFault2SOAPFault() {
        this.traverseBindingFault2SOAPFault = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPHeader2SOAPHeaderFault() {
        this.traverseSOAPHeader2SOAPHeaderFault = false;
        return this;
    }

    public WSDLTraversal ignoreBinding2BindingOperation() {
        this.traverseBinding2BindingOperation = false;
        return this;
    }

    public WSDLTraversal ignoreBinding2Element() {
        this.traverseBinding2Element = false;
        return this;
    }

    public WSDLTraversal ignoreBinding2ExtensibilityElement() {
        this.traverseBinding2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreBinding2PortType() {
        this.traverseBinding2PortType = false;
        return this;
    }

    public WSDLTraversal ignoreBindingFault2Element() {
        this.traverseBindingFault2Element = false;
        return this;
    }

    public WSDLTraversal ignoreBindingFault2ExtensibilityElement() {
        this.traverseBindingFault2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreBindingInput2Element() {
        this.traverseBindingInput2Element = false;
        return this;
    }

    public WSDLTraversal ignoreBindingInput2ExtensibilityElement() {
        this.traverseBindingInput2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2BindingFault() {
        this.traverseBindingOperation2BindingFault = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2BindingInput() {
        this.traverseBindingOperation2BindingInput = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2BindingOutput() {
        this.traverseBindingOperation2BindingOutput = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2Element() {
        this.traverseBindingOperation2Element = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2ExtensibilityElement() {
        this.traverseBindingOperation2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation2Operation() {
        this.traverseBindingOperation2Operation = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOutput2Element() {
        this.traverseBindingOutput2Element = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOutput2ExtensibilityElement() {
        this.traverseBindingOutput2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2Binding() {
        this.traverseDefinition2Binding = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2Element() {
        this.traverseDefinition2Element = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2ExtensibilityElement() {
        this.traverseDefinition2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2Import() {
        this.traverseDefinition2Import = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2Message() {
        this.traverseDefinition2Message = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2PortType() {
        this.traverseDefinition2PortType = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2Service() {
        this.traverseDefinition2Service = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition2Types() {
        this.traverseDefinition2Types = false;
        return this;
    }

    public WSDLTraversal ignoreFault2Element() {
        this.traverseFault2Element = false;
        return this;
    }

    public WSDLTraversal ignoreFault2Message() {
        this.traverseFault2Message = false;
        return this;
    }

    public WSDLTraversal ignoreImport2Definition() {
        this.traverseImport2Definition = false;
        return this;
    }

    public WSDLTraversal ignoreImport2Element() {
        this.traverseImport2Element = false;
        return this;
    }

    public WSDLTraversal ignoreInput2Element() {
        this.traverseInput2Element = false;
        return this;
    }

    public WSDLTraversal ignoreInput2Message() {
        this.traverseInput2Message = false;
        return this;
    }

    public WSDLTraversal ignoreMessage2Element() {
        this.traverseMessage2Element = false;
        return this;
    }

    public WSDLTraversal ignoreMessage2Part() {
        this.traverseMessage2Part = false;
        return this;
    }

    public WSDLTraversal ignoreOperation2Element() {
        this.traverseOperation2Element = false;
        return this;
    }

    public WSDLTraversal ignoreOperation2Fault() {
        this.traverseOperation2Fault = false;
        return this;
    }

    public WSDLTraversal ignoreOperation2Input() {
        this.traverseOperation2Input = false;
        return this;
    }

    public WSDLTraversal ignoreOperation2Output() {
        this.traverseOperation2Output = false;
        return this;
    }

    public WSDLTraversal ignoreOutput2Element() {
        this.traverseOutput2Element = false;
        return this;
    }

    public WSDLTraversal ignoreOutput2Message() {
        this.traverseOutput2Message = false;
        return this;
    }

    public WSDLTraversal ignorePart2Element() {
        this.traversePart2Element = false;
        return this;
    }

    public WSDLTraversal ignorePort2Binding() {
        this.traversePort2Binding = false;
        return this;
    }

    public WSDLTraversal ignorePort2Element() {
        this.traversePort2Element = false;
        return this;
    }

    public WSDLTraversal ignorePort2ExtensibilityElement() {
        this.traversePort2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignorePortType2Element() {
        this.traversePortType2Element = false;
        return this;
    }

    public WSDLTraversal ignorePortType2Operation() {
        this.traversePortType2Operation = false;
        return this;
    }

    public WSDLTraversal ignoreService2Element() {
        this.traverseService2Element = false;
        return this;
    }

    public WSDLTraversal ignoreService2ExtensibilityElement() {
        this.traverseService2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreService2Port() {
        this.traverseService2Port = false;
        return this;
    }

    public WSDLTraversal ignoreTypes2Element() {
        this.traverseTypes2Element = false;
        return this;
    }

    public WSDLTraversal ignoreTypes2ExtensibilityElement() {
        this.traverseTypes2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal visitSOAPBinding(boolean bl) {
        this.visitSOAPBinding = bl;
        return this;
    }

    public WSDLTraversal visitSOAPBody(boolean bl) {
        this.visitSOAPBody = bl;
        return this;
    }

    public WSDLTraversal visitSOAPFault(boolean bl) {
        this.visitSOAPFault = bl;
        return this;
    }

    public WSDLTraversal visitSOAPHeader(boolean bl) {
        this.visitSOAPHeader = bl;
        return this;
    }

    public WSDLTraversal visitSOAPHeaderFault(boolean bl) {
        this.visitSOAPHeaderFault = bl;
        return this;
    }

    public WSDLTraversal visitSOAPOperation(boolean bl) {
        this.visitSOAPOperation = bl;
        return this;
    }

    public WSDLTraversal visitBinding(boolean bl) {
        this.visitBinding = bl;
        return this;
    }

    public WSDLTraversal visitBindingFault(boolean bl) {
        this.visitBindingFault = bl;
        return this;
    }

    public WSDLTraversal visitBindingInput(boolean bl) {
        this.visitBindingInput = bl;
        return this;
    }

    public WSDLTraversal visitBindingOperation(boolean bl) {
        this.visitBindingOperation = bl;
        return this;
    }

    public WSDLTraversal visitBindingOutput(boolean bl) {
        this.visitBindingOutput = bl;
        return this;
    }

    public WSDLTraversal visitDefinition(boolean bl) {
        this.visitDefinition = bl;
        return this;
    }

    public WSDLTraversal visitElement(boolean bl) {
        this.visitElement = bl;
        return this;
    }

    public WSDLTraversal visitExtensibilityElement(boolean bl) {
        this.visitExtensibilityElement = bl;
        return this;
    }

    public WSDLTraversal visitFault(boolean bl) {
        this.visitFault = bl;
        return this;
    }

    public WSDLTraversal visitImport(boolean bl) {
        this.visitImport = bl;
        return this;
    }

    public WSDLTraversal visitInput(boolean bl) {
        this.visitInput = bl;
        return this;
    }

    public WSDLTraversal visitMessage(boolean bl) {
        this.visitMessage = bl;
        return this;
    }

    public WSDLTraversal visitOperation(boolean bl) {
        this.visitOperation = bl;
        return this;
    }

    public WSDLTraversal visitOutput(boolean bl) {
        this.visitOutput = bl;
        return this;
    }

    public WSDLTraversal visitPart(boolean bl) {
        this.visitPart = bl;
        return this;
    }

    public WSDLTraversal visitPort(boolean bl) {
        this.visitPort = bl;
        return this;
    }

    public WSDLTraversal visitPortType(boolean bl) {
        this.visitPortType = bl;
        return this;
    }

    public WSDLTraversal visitService(boolean bl) {
        this.visitService = bl;
        return this;
    }

    public WSDLTraversal visitTypes(boolean bl) {
        this.visitTypes = bl;
        return this;
    }

    public WSDLTraversal ignoreBinding() {
        this.traverseDefinition2Binding = false;
        this.traversePort2Binding = false;
        return this;
    }

    public WSDLTraversal ignoreBindingFault() {
        this.traverseBindingOperation2BindingFault = false;
        return this;
    }

    public WSDLTraversal ignoreBindingInput() {
        this.traverseBindingOperation2BindingInput = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOperation() {
        this.traverseBinding2BindingOperation = false;
        return this;
    }

    public WSDLTraversal ignoreBindingOutput() {
        this.traverseBindingOperation2BindingOutput = false;
        return this;
    }

    public WSDLTraversal ignoreDefinition() {
        this.traverseImport2Definition = false;
        return this;
    }

    public WSDLTraversal ignoreElement() {
        this.traverseBinding2Element = false;
        this.traverseBindingFault2Element = false;
        this.traverseBindingInput2Element = false;
        this.traverseBindingOperation2Element = false;
        this.traverseBindingOutput2Element = false;
        this.traverseDefinition2Element = false;
        this.traversePort2Element = false;
        this.traverseService2Element = false;
        this.traverseFault2Element = false;
        this.traverseOutput2Element = false;
        this.traverseImport2Element = false;
        this.traverseInput2Element = false;
        this.traverseOperation2Element = false;
        this.traverseMessage2Element = false;
        this.traversePart2Element = false;
        this.traversePortType2Element = false;
        this.traverseTypes2Element = false;
        return this;
    }

    public WSDLTraversal ignoreExtensibilityElement() {
        this.traverseService2ExtensibilityElement = false;
        this.traversePort2ExtensibilityElement = false;
        this.traverseDefinition2ExtensibilityElement = false;
        this.traverseBindingOutput2ExtensibilityElement = false;
        this.traverseBinding2ExtensibilityElement = false;
        this.traverseBindingFault2ExtensibilityElement = false;
        this.traverseBindingInput2ExtensibilityElement = false;
        this.traverseBindingOperation2ExtensibilityElement = false;
        this.traverseTypes2ExtensibilityElement = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPBinding() {
        this.traverseBinding2SOAPBinding = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPOperation() {
        this.traverseBindingOperation2SOAPOperation = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPBody() {
        this.traverseBindingInput2SOAPBody = false;
        this.traverseBindingOutput2SOAPBody = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPHeader() {
        this.traverseBindingInput2SOAPHeader = false;
        this.traverseBindingOutput2SOAPHeader = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPHeaderFault() {
        this.traverseSOAPHeader2SOAPHeaderFault = false;
        return this;
    }

    public WSDLTraversal ignoreSOAPFault() {
        this.traverseBindingFault2SOAPFault = false;
        return this;
    }

    public WSDLTraversal ignoreFault() {
        this.traverseOperation2Fault = false;
        return this;
    }

    public WSDLTraversal ignoreImport() {
        this.traverseImport2Definition = false;
        return this;
    }

    public WSDLTraversal ignoreInput() {
        this.traverseOperation2Input = false;
        return this;
    }

    public WSDLTraversal ignoreMessage() {
        this.traverseFault2Message = false;
        this.traverseDefinition2Message = false;
        this.traverseInput2Message = false;
        this.traverseOutput2Message = false;
        return this;
    }

    public WSDLTraversal ignoreOperation() {
        this.traverseBindingOperation2Operation = false;
        this.traversePortType2Operation = false;
        return this;
    }

    public WSDLTraversal ignoreOutput() {
        this.traverseOperation2Output = false;
        return this;
    }

    public WSDLTraversal ignorePart() {
        this.traverseMessage2Part = false;
        return this;
    }

    public WSDLTraversal ignorePort() {
        this.traverseService2Port = false;
        return this;
    }

    public WSDLTraversal ignorePortType() {
        this.traverseBinding2PortType = false;
        this.traverseDefinition2PortType = false;
        return this;
    }

    public WSDLTraversal ignoreService() {
        this.traverseDefinition2Service = false;
        return this;
    }

    public WSDLTraversal ignoreTypes() {
        this.traverseDefinition2Types = false;
        return this;
    }

    private void adjust() {
        this.adjustPart();
        this.adjustService();
        this.adjustTypes();
        this.adjustOperation();
        this.adjustInput();
        this.adjustOutput();
        this.adjustFault();
        this.adjustBinding();
        this.adjustBindingOperation();
        this.adjustBindingInput();
        this.adjustBindingOutput();
        this.adjustBindingFault();
        this.adjustImport();
        this.adjustElement();
        this.adjustMessage();
        this.adjustPort();
        this.adjustPortType();
        this.adjustDefinition();
        this.adjustExtensibilityElement();
        this.adjustSOAPBinding();
        this.adjustSOAPBody();
        this.adjustSOAPHeader();
        this.adjustSOAPHeaderFault();
        this.adjustSOAPFault();
        this.adjustSOAPOperation();
    }

    private boolean adjustExtensibilityElement() {
        boolean bl = this.visitExtensibilityElement;
        if (!bl) {
            this.ignoreExtensibilityElement();
        }
        return bl;
    }

    private boolean adjustPart() {
        boolean bl;
        boolean bl2 = bl = this.visitPart || this.traversePart2Element && this.adjustElement();
        if (!bl) {
            this.ignorePart();
        }
        return bl;
    }

    private boolean adjustSOAPHeader() {
        boolean bl;
        boolean bl2 = bl = this.visitSOAPHeader || this.traverseSOAPHeader2SOAPHeaderFault && this.adjustSOAPHeaderFault();
        if (!bl) {
            this.ignoreSOAPHeader();
        }
        return bl;
    }

    private boolean adjustBindingOutput() {
        boolean bl;
        boolean bl2 = bl = this.visitBindingOutput || this.traverseBindingOutput2Element && this.adjustElement() || this.traverseBindingOutput2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseBindingOutput2SOAPBody && this.adjustSOAPBody() || this.traverseBindingOutput2SOAPHeader && this.adjustSOAPHeader();
        if (!bl) {
            this.ignoreBindingOutput();
        }
        return bl;
    }

    private boolean adjustElement() {
        boolean bl = this.visitElement;
        if (!bl) {
            this.ignoreElement();
        }
        return bl;
    }

    private boolean adjustTypes() {
        boolean bl;
        boolean bl2 = bl = this.visitTypes || this.traverseTypes2Element && this.adjustElement() || this.traverseTypes2ExtensibilityElement && this.adjustExtensibilityElement();
        if (!bl) {
            this.ignoreTypes();
        }
        return bl;
    }

    private boolean adjustSOAPBinding() {
        boolean bl = this.visitSOAPBinding;
        if (!bl) {
            this.ignoreSOAPBinding();
        }
        return bl;
    }

    private boolean adjustPort() {
        boolean bl;
        boolean bl2 = bl = this.visitPort || this.traversePort2Element && this.adjustElement() || this.traversePort2ExtensibilityElement && this.adjustExtensibilityElement() || this.traversePort2Binding && this.adjustBinding();
        if (!bl) {
            this.ignorePort();
        }
        return bl;
    }

    private boolean adjustOperation() {
        boolean bl;
        boolean bl2 = bl = this.visitOperation || this.traverseOperation2Element && this.adjustElement() || this.traverseOperation2Input && this.adjustInput() || this.traverseOperation2Output && this.adjustOutput() || this.traverseOperation2Fault && this.adjustFault();
        if (!bl) {
            this.ignoreOperation();
        }
        return bl;
    }

    private boolean adjustBindingOperation() {
        boolean bl;
        boolean bl2 = bl = this.visitBindingOperation || this.traverseBindingOperation2Element && this.adjustElement() || this.traverseBindingOperation2BindingFault && this.adjustBindingFault() || this.traverseBindingOperation2BindingOutput && this.adjustBindingOutput() || this.traverseBindingOperation2Operation && this.adjustOperation() || this.traverseBindingOperation2BindingInput && this.adjustBindingInput() || this.traverseBindingOperation2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseBindingOperation2SOAPOperation && this.adjustSOAPOperation();
        if (!bl) {
            this.ignoreBindingOperation();
        }
        return bl;
    }

    private boolean adjustInput() {
        boolean bl;
        boolean bl2 = bl = this.visitInput || this.traverseInput2Element && this.adjustElement() || this.traverseInput2Message && this.adjustMessage();
        if (!bl) {
            this.ignoreInput();
        }
        return bl;
    }

    private boolean adjustBinding() {
        boolean bl;
        boolean bl2 = bl = this.visitBinding || this.traverseBinding2Element && this.adjustElement() || this.traverseBinding2BindingOperation && this.adjustBindingOperation() || this.traverseBinding2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseBinding2PortType && this.adjustPortType() || this.traverseBinding2SOAPBinding && this.adjustSOAPBinding();
        if (!bl) {
            this.ignoreBinding();
        }
        return bl;
    }

    private boolean adjustSOAPBody() {
        boolean bl = this.visitSOAPBody;
        if (!bl) {
            this.ignoreSOAPBody();
        }
        return bl;
    }

    private boolean adjustSOAPHeaderFault() {
        boolean bl = this.visitSOAPHeaderFault;
        if (!bl) {
            this.ignoreSOAPHeaderFault();
        }
        return bl;
    }

    private boolean adjustBindingInput() {
        boolean bl;
        boolean bl2 = bl = this.visitBindingInput || this.traverseBindingInput2Element && this.adjustElement() || this.traverseBindingInput2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseBindingInput2SOAPBody && this.adjustSOAPBody() || this.traverseBindingInput2SOAPHeader && this.adjustSOAPHeader();
        if (!bl) {
            this.ignoreBindingInput();
        }
        return bl;
    }

    private boolean adjustOutput() {
        boolean bl;
        boolean bl2 = bl = this.visitOutput || this.traverseOutput2Element && this.adjustElement() || this.traverseOutput2Message && this.adjustMessage();
        if (!bl) {
            this.ignoreOutput();
        }
        return bl;
    }

    private boolean adjustBindingFault() {
        boolean bl;
        boolean bl2 = bl = this.visitBindingFault || this.traverseBindingFault2Element && this.adjustElement() || this.traverseBindingFault2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseBindingFault2SOAPFault && this.adjustSOAPFault();
        if (!bl) {
            this.ignoreBindingFault();
        }
        return bl;
    }

    private boolean adjustSOAPOperation() {
        boolean bl = this.visitSOAPOperation;
        if (!bl) {
            this.ignoreSOAPOperation();
        }
        return bl;
    }

    private boolean adjustDefinition() {
        boolean bl;
        boolean bl2 = bl = this.visitDefinition || this.traverseDefinition2Element && this.adjustElement() || this.traverseDefinition2Import && this.adjustImport() || this.traverseDefinition2Types && this.adjustTypes() || this.traverseDefinition2Message && this.adjustMessage() || this.traverseDefinition2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseDefinition2PortType && this.adjustPortType() || this.traverseDefinition2Binding && this.adjustBinding() || this.traverseDefinition2Service && this.adjustService();
        if (!bl) {
            this.ignoreDefinition();
        }
        return bl;
    }

    private boolean adjustSOAPFault() {
        boolean bl = this.visitSOAPFault;
        if (!bl) {
            this.ignoreSOAPFault();
        }
        return bl;
    }

    private boolean adjustImport() {
        boolean bl;
        boolean bl2 = bl = this.visitImport || this.traverseImport2Definition || this.traverseImport2Element && this.adjustElement();
        if (!bl) {
            this.ignoreImport();
        }
        return bl;
    }

    private boolean adjustFault() {
        boolean bl;
        boolean bl2 = bl = this.visitFault || this.traverseFault2Element && this.adjustElement() || this.traverseFault2Message && this.adjustMessage();
        if (!bl) {
            this.ignoreFault();
        }
        return bl;
    }

    private boolean adjustPortType() {
        boolean bl;
        boolean bl2 = bl = this.visitPortType || this.traversePortType2Element && this.adjustElement() || this.traversePortType2Operation && this.adjustOperation();
        if (!bl) {
            this.ignorePortType();
        }
        return bl;
    }

    private boolean adjustService() {
        boolean bl;
        boolean bl2 = bl = this.visitService || this.traverseService2Element && this.adjustElement() || this.traverseService2ExtensibilityElement && this.adjustExtensibilityElement() || this.traverseService2Port && this.adjustPort();
        if (!bl) {
            this.ignoreService();
        }
        return bl;
    }

    private boolean adjustMessage() {
        boolean bl;
        boolean bl2 = bl = this.visitMessage || this.traverseMessage2Element && this.adjustElement() || this.traverseMessage2Part && this.adjustPart();
        if (!bl) {
            this.ignoreMessage();
        }
        return bl;
    }

    private void traverse(ExtensibilityElement extensibilityElement, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.resumeExtensibilityElementProcessing();
        wSDLTraversalContext.setExtensibilityElement(extensibilityElement);
        if (this.visitExtensibilityElement) {
            this.visitor.visit(extensibilityElement, object, wSDLTraversalContext);
        }
    }

    private void traverse(Part part, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.resumePartProcessing();
        wSDLTraversalContext.setPart(part);
        if (this.visitPart) {
            this.visitor.visit(part, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processPart()) {
                return;
            }
        }
        if (part == null) {
            return;
        }
        if (this.traversePart2Element) {
            this.traverse(part.getDocumentationElement(), (Object)part, wSDLTraversalContext);
        }
    }

    private void traverse(SOAPHeader sOAPHeader, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.resumeSOAPHeaderProcessing();
        wSDLTraversalContext.setSOAPHeader(sOAPHeader);
        if (this.visitSOAPHeader) {
            this.visitor.visit(sOAPHeader, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processSOAPHeader()) {
                return;
            }
        }
        if (sOAPHeader == null) {
            return;
        }
        if (this.traverseSOAPHeader2SOAPHeaderFault && sOAPHeader.getSOAPHeaderFaults() != null) {
            Iterator iterator = sOAPHeader.getSOAPHeaderFaults().iterator();
            while (iterator.hasNext()) {
                this.traverse((SOAPHeaderFault)iterator.next(), (Object)sOAPHeader, wSDLTraversalContext);
                if (wSDLTraversalContext.processSOAPHeader()) continue;
                return;
            }
        }
    }

    private void traverse(Element element, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.setElement(element);
        if (this.visitElement) {
            this.visitor.visit(element, object, wSDLTraversalContext);
        }
    }

    private void traverse(Types types, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.resumeTypesProcessing();
        wSDLTraversalContext.setTypes(types);
        if (this.visitTypes) {
            this.visitor.visit(types, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processTypes()) {
                return;
            }
        }
        if (types == null) {
            return;
        }
        if (this.traverseTypes2Element) {
            this.traverse(types.getDocumentationElement(), (Object)types, wSDLTraversalContext);
            if (!wSDLTraversalContext.processTypes()) {
                return;
            }
        }
        if (this.traverseTypes2ExtensibilityElement && types.getExtensibilityElements() != null) {
            Iterator iterator = types.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                this.traverse((ExtensibilityElement)iterator.next(), (Object)types, wSDLTraversalContext);
                if (wSDLTraversalContext.processTypes()) continue;
                return;
            }
        }
    }

    private void traverse(SOAPBinding sOAPBinding, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.setSOAPBinding(sOAPBinding);
        if (this.visitSOAPBinding) {
            this.visitor.visit(sOAPBinding, object, wSDLTraversalContext);
        }
    }

    private void traverse(Definition definition, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Iterator<Object> iterator;
        wSDLTraversalContext.resumeDefinitionProcessing();
        wSDLTraversalContext.setDefinition(definition);
        if (this.visitDefinition) {
            this.visitor.visit(definition, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processDefinition()) {
                return;
            }
        }
        if (definition == null) {
            return;
        }
        if (this.traverseDefinition2Import && definition.getImports() != null) {
            iterator = definition.getImports().values().iterator();
            while (iterator.hasNext()) {
                Vector vector = (Vector)iterator.next();
                if (vector == null) continue;
                Iterator iterator2 = vector.iterator();
                while (iterator2.hasNext()) {
                    this.traverse((Import)iterator2.next(), (Object)definition, wSDLTraversalContext);
                    if (wSDLTraversalContext.processDefinition()) continue;
                    return;
                }
            }
        }
        if (this.traverseDefinition2Element) {
            this.traverse(definition.getDocumentationElement(), (Object)definition, wSDLTraversalContext);
            if (!wSDLTraversalContext.processDefinition()) {
                return;
            }
        }
        if (this.traverseDefinition2Types) {
            this.traverse(definition.getTypes(), (Object)definition, wSDLTraversalContext);
            if (!wSDLTraversalContext.processDefinition()) {
                return;
            }
        }
        if (this.traverseDefinition2Message && definition.getMessages() != null) {
            iterator = definition.getMessages().values().iterator();
            while (iterator.hasNext()) {
                this.traverse((Message)iterator.next(), (Object)definition, wSDLTraversalContext);
                if (wSDLTraversalContext.processDefinition()) continue;
                return;
            }
        }
        if (this.traverseDefinition2PortType && definition.getPortTypes() != null) {
            iterator = definition.getPortTypes().values().iterator();
            while (iterator.hasNext()) {
                this.traverse((PortType)iterator.next(), (Object)definition, wSDLTraversalContext);
                if (wSDLTraversalContext.processDefinition()) continue;
                return;
            }
        }
        if (this.traverseDefinition2Binding && definition.getBindings() != null) {
            iterator = definition.getBindings().values().iterator();
            while (iterator.hasNext()) {
                this.traverse((Binding)iterator.next(), (Object)definition, wSDLTraversalContext);
                if (wSDLTraversalContext.processDefinition()) continue;
                return;
            }
        }
        if (this.traverseDefinition2Service && definition.getServices() != null) {
            iterator = definition.getServices().values().iterator();
            while (iterator.hasNext()) {
                this.traverse((Service)iterator.next(), (Object)definition, wSDLTraversalContext);
                if (wSDLTraversalContext.processDefinition()) continue;
                return;
            }
        }
        if (this.traverseDefinition2ExtensibilityElement && definition.getExtensibilityElements() != null) {
            iterator = definition.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                this.traverse((ExtensibilityElement)iterator.next(), (Object)definition, wSDLTraversalContext);
                if (wSDLTraversalContext.processDefinition()) continue;
                return;
            }
        }
    }

    private void traverse(Port port, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.resumePortProcessing();
        wSDLTraversalContext.setPort(port);
        if (this.visitPort) {
            this.visitor.visit(port, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processPort()) {
                return;
            }
        }
        if (port == null) {
            return;
        }
        if (this.traversePort2Element) {
            this.traverse(port.getDocumentationElement(), (Object)port, wSDLTraversalContext);
            if (!wSDLTraversalContext.processPort()) {
                return;
            }
        }
        if (this.traversePort2Binding) {
            this.traverse(port.getBinding(), (Object)port, wSDLTraversalContext);
            if (!wSDLTraversalContext.processPort()) {
                return;
            }
        }
        if (this.traversePort2ExtensibilityElement && port.getExtensibilityElements() != null) {
            Iterator iterator = port.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                this.traverse((ExtensibilityElement)iterator.next(), (Object)port, wSDLTraversalContext);
                if (wSDLTraversalContext.processPort()) continue;
                return;
            }
        }
    }

    private void traverse(Operation operation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.resumeOperationProcessing();
        wSDLTraversalContext.setOperation(operation);
        if (this.visitOperation) {
            this.visitor.visit(operation, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processOperation()) {
                return;
            }
        }
        if (operation == null) {
            return;
        }
        if (this.traverseOperation2Element) {
            this.traverse(operation.getDocumentationElement(), (Object)operation, wSDLTraversalContext);
            if (!wSDLTraversalContext.processOperation()) {
                return;
            }
        }
        if (this.traverseOperation2Input) {
            this.traverse(operation.getInput(), (Object)operation, wSDLTraversalContext);
            if (!wSDLTraversalContext.processOperation()) {
                return;
            }
        }
        if (this.traverseOperation2Output) {
            this.traverse(operation.getOutput(), (Object)operation, wSDLTraversalContext);
            if (!wSDLTraversalContext.processOperation()) {
                return;
            }
        }
        if (this.traverseOperation2Fault && operation.getFaults() != null) {
            Iterator iterator = operation.getFaults().values().iterator();
            while (iterator.hasNext()) {
                this.traverse((Fault)iterator.next(), (Object)operation, wSDLTraversalContext);
                if (wSDLTraversalContext.processOperation()) continue;
                return;
            }
        }
    }

    private void traverse(Input input, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.resumeInputProcessing();
        wSDLTraversalContext.setInput(input);
        if (this.visitInput) {
            this.visitor.visit(input, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processInput()) {
                return;
            }
        }
        if (input == null) {
            return;
        }
        if (this.traverseInput2Element) {
            this.traverse(input.getDocumentationElement(), (Object)input, wSDLTraversalContext);
            if (!wSDLTraversalContext.processInput()) {
                return;
            }
        }
        if (this.traverseInput2Message) {
            this.traverse(input.getMessage(), (Object)input, wSDLTraversalContext);
        }
    }

    private void traverse(SOAPBody sOAPBody, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.setSOAPBody(sOAPBody);
        if (this.visitSOAPBody) {
            this.visitor.visit(sOAPBody, object, wSDLTraversalContext);
        }
    }

    private void traverse(SOAPHeaderFault sOAPHeaderFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.setSOAPHeaderFault(sOAPHeaderFault);
        if (this.visitSOAPHeaderFault) {
            this.visitor.visit(sOAPHeaderFault, object, wSDLTraversalContext);
        }
    }

    private void traverse(Output output, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.resumeOutputProcessing();
        wSDLTraversalContext.setOutput(output);
        if (this.visitOutput) {
            this.visitor.visit(output, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processOutput()) {
                return;
            }
        }
        if (output == null) {
            return;
        }
        if (this.traverseOutput2Element) {
            this.traverse(output.getDocumentationElement(), (Object)output, wSDLTraversalContext);
            if (!wSDLTraversalContext.processOutput()) {
                return;
            }
        }
        if (this.traverseOutput2Message) {
            this.traverse(output.getMessage(), (Object)output, wSDLTraversalContext);
        }
    }

    private void traverse(BindingFault bindingFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Iterator iterator;
        wSDLTraversalContext.resumeBindingFaultProcessing();
        wSDLTraversalContext.setBindingFault(bindingFault);
        if (this.visitBindingFault) {
            this.visitor.visit(bindingFault, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBindingFault()) {
                return;
            }
        }
        if (bindingFault == null) {
            return;
        }
        if (this.traverseBindingFault2Element) {
            this.traverse(bindingFault.getDocumentationElement(), (Object)bindingFault, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBindingFault()) {
                return;
            }
        }
        if (this.traverseBindingFault2SOAPFault && bindingFault.getExtensibilityElements() != null) {
            iterator = bindingFault.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof SOAPFault) {
                    this.traverse((SOAPFault)e, (Object)bindingFault, wSDLTraversalContext);
                }
                if (wSDLTraversalContext.processBindingFault()) continue;
                return;
            }
        }
        if (this.traverseBindingFault2ExtensibilityElement && bindingFault.getExtensibilityElements() != null) {
            iterator = bindingFault.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                this.traverse((ExtensibilityElement)iterator.next(), (Object)bindingFault, wSDLTraversalContext);
                if (wSDLTraversalContext.processBindingFault()) continue;
                return;
            }
        }
    }

    private void traverse(SOAPOperation sOAPOperation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.setSOAPOperation(sOAPOperation);
        if (this.visitSOAPOperation) {
            this.visitor.visit(sOAPOperation, object, wSDLTraversalContext);
        }
    }

    private void traverse(BindingInput bindingInput, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Iterator iterator;
        wSDLTraversalContext.resumeBindingInputProcessing();
        wSDLTraversalContext.setBindingInput(bindingInput);
        if (this.visitBindingInput) {
            this.visitor.visit(bindingInput, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBindingInput()) {
                return;
            }
        }
        if (bindingInput == null) {
            return;
        }
        if (this.traverseBindingInput2Element) {
            this.traverse(bindingInput.getDocumentationElement(), (Object)bindingInput, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBindingInput()) {
                return;
            }
        }
        if ((this.traverseBindingInput2SOAPBody || this.traverseBindingInput2SOAPHeader) && bindingInput.getExtensibilityElements() != null) {
            iterator = bindingInput.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.traverseBindingInput2SOAPBody && e instanceof SOAPBody) {
                    this.traverse((SOAPBody)e, (Object)bindingInput, wSDLTraversalContext);
                } else if (this.traverseBindingInput2SOAPHeader && e instanceof SOAPHeader) {
                    this.traverse((SOAPHeader)e, (Object)bindingInput, wSDLTraversalContext);
                }
                if (wSDLTraversalContext.processBindingInput()) continue;
                return;
            }
        }
        if (this.traverseBindingInput2ExtensibilityElement && bindingInput.getExtensibilityElements() != null) {
            iterator = bindingInput.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                this.traverse((ExtensibilityElement)iterator.next(), (Object)bindingInput, wSDLTraversalContext);
                if (wSDLTraversalContext.processBindingInput()) continue;
                return;
            }
        }
    }

    private void traverse(BindingOperation bindingOperation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Iterator<Object> iterator;
        wSDLTraversalContext.resumeBindingOperationProcessing();
        wSDLTraversalContext.setBindingOperation(bindingOperation);
        if (this.visitBindingOperation) {
            this.visitor.visit(bindingOperation, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBindingOperation()) {
                return;
            }
        }
        if (bindingOperation == null) {
            return;
        }
        if (this.traverseBindingOperation2Element) {
            this.traverse(bindingOperation.getDocumentationElement(), (Object)bindingOperation, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBindingOperation()) {
                return;
            }
        }
        if (this.traverseBindingOperation2SOAPOperation && bindingOperation.getExtensibilityElements() != null) {
            iterator = bindingOperation.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof SOAPOperation) {
                    this.traverse((SOAPOperation)e, (Object)bindingOperation, wSDLTraversalContext);
                }
                if (wSDLTraversalContext.processBindingOperation()) continue;
                return;
            }
        }
        if (this.traverseBindingOperation2ExtensibilityElement && bindingOperation.getExtensibilityElements() != null) {
            iterator = bindingOperation.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                this.traverse((ExtensibilityElement)iterator.next(), (Object)bindingOperation, wSDLTraversalContext);
                if (wSDLTraversalContext.processBindingOperation()) continue;
                return;
            }
        }
        if (this.traverseBindingOperation2Operation) {
            this.traverse(bindingOperation.getOperation(), (Object)bindingOperation, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBindingOperation()) {
                return;
            }
        }
        if (this.traverseBindingOperation2BindingInput) {
            this.traverse(bindingOperation.getBindingInput(), (Object)bindingOperation, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBindingOperation()) {
                return;
            }
        }
        if (this.traverseBindingOperation2BindingOutput) {
            this.traverse(bindingOperation.getBindingOutput(), (Object)bindingOperation, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBindingOperation()) {
                return;
            }
        }
        if (this.traverseBindingOperation2BindingFault && bindingOperation.getBindingFaults() != null) {
            iterator = bindingOperation.getBindingFaults().values().iterator();
            while (iterator.hasNext()) {
                this.traverse((BindingFault)iterator.next(), (Object)bindingOperation, wSDLTraversalContext);
                if (wSDLTraversalContext.processBindingOperation()) continue;
                return;
            }
        }
    }

    private void traverse(SOAPFault sOAPFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.setSOAPFault(sOAPFault);
        if (this.visitSOAPFault) {
            this.visitor.visit(sOAPFault, object, wSDLTraversalContext);
        }
    }

    private void traverse(Binding binding, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Iterator iterator;
        wSDLTraversalContext.resumeBindingProcessing();
        wSDLTraversalContext.setBinding(binding);
        if (this.visitBinding) {
            this.visitor.visit(binding, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBinding()) {
                return;
            }
        }
        if (binding == null) {
            return;
        }
        if (this.traverseBinding2Element) {
            this.traverse(binding.getDocumentationElement(), (Object)binding, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBinding()) {
                return;
            }
        }
        if (this.traverseBinding2SOAPBinding && binding.getExtensibilityElements() != null) {
            iterator = binding.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e instanceof SOAPBinding) {
                    this.traverse((SOAPBinding)e, (Object)binding, wSDLTraversalContext);
                }
                if (wSDLTraversalContext.processBinding()) continue;
                return;
            }
        }
        if (this.traverseBinding2PortType) {
            this.traverse(binding.getPortType(), (Object)binding, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBinding()) {
                return;
            }
        }
        if (this.traverseBinding2BindingOperation && binding.getBindingOperations() != null) {
            iterator = binding.getBindingOperations().iterator();
            while (iterator.hasNext()) {
                this.traverse((BindingOperation)iterator.next(), (Object)binding, wSDLTraversalContext);
                if (wSDLTraversalContext.processBinding()) continue;
                return;
            }
        }
        if (this.traverseBinding2ExtensibilityElement && binding.getExtensibilityElements() != null) {
            iterator = binding.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                this.traverse((ExtensibilityElement)iterator.next(), (Object)binding, wSDLTraversalContext);
                if (wSDLTraversalContext.processBinding()) continue;
                return;
            }
        }
    }

    private void traverse(Fault fault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.resumeFaultProcessing();
        wSDLTraversalContext.setFault(fault);
        if (this.visitFault) {
            this.visitor.visit(fault, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processFault()) {
                return;
            }
        }
        if (fault == null) {
            return;
        }
        if (this.traverseFault2Element) {
            this.traverse(fault.getDocumentationElement(), (Object)fault, wSDLTraversalContext);
            if (!wSDLTraversalContext.processFault()) {
                return;
            }
        }
        if (this.traverseFault2Message) {
            this.traverse(fault.getMessage(), (Object)fault, wSDLTraversalContext);
        }
    }

    private void traverse(Service service, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Iterator<Object> iterator;
        wSDLTraversalContext.resumeServiceProcessing();
        wSDLTraversalContext.setService(service);
        if (this.visitService) {
            this.visitor.visit(service, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processService()) {
                return;
            }
        }
        if (service == null) {
            return;
        }
        if (this.traverseService2Element) {
            this.traverse(service.getDocumentationElement(), (Object)service, wSDLTraversalContext);
            if (!wSDLTraversalContext.processService()) {
                return;
            }
        }
        if (this.traverseService2ExtensibilityElement && service.getExtensibilityElements() != null) {
            iterator = service.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                this.traverse((ExtensibilityElement)iterator.next(), (Object)service, wSDLTraversalContext);
                if (wSDLTraversalContext.processService()) continue;
                return;
            }
        }
        if (this.traverseService2Port && service.getPorts() != null) {
            iterator = service.getPorts().values().iterator();
            while (iterator.hasNext()) {
                this.traverse((Port)iterator.next(), (Object)service, wSDLTraversalContext);
                if (wSDLTraversalContext.processService()) continue;
                return;
            }
        }
    }

    private void traverse(Import import_, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.resumeImportProcessing();
        wSDLTraversalContext.setImport(import_);
        if (this.visitImport) {
            this.visitor.visit(import_, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processImport()) {
                return;
            }
        }
        if (import_ == null) {
            return;
        }
        if (this.traverseImport2Element) {
            this.traverse(import_.getDocumentationElement(), (Object)import_, wSDLTraversalContext);
            if (!wSDLTraversalContext.processImport()) {
                return;
            }
        }
        if (this.traverseImport2Definition) {
            this.traverse(import_.getDefinition(), (Object)import_, wSDLTraversalContext);
        }
    }

    private void traverse(BindingOutput bindingOutput, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Iterator iterator;
        wSDLTraversalContext.resumeBindingOutputProcessing();
        wSDLTraversalContext.setBindingOutput(bindingOutput);
        if (this.visitBindingOutput) {
            this.visitor.visit(bindingOutput, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBindingOutput()) {
                return;
            }
        }
        if (bindingOutput == null) {
            return;
        }
        if (this.traverseBindingOutput2Element) {
            this.traverse(bindingOutput.getDocumentationElement(), (Object)bindingOutput, wSDLTraversalContext);
            if (!wSDLTraversalContext.processBindingOutput()) {
                return;
            }
        }
        if ((this.traverseBindingOutput2SOAPBody || this.traverseBindingOutput2SOAPHeader) && bindingOutput.getExtensibilityElements() != null) {
            iterator = bindingOutput.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (this.traverseBindingOutput2SOAPBody && e instanceof SOAPBody) {
                    this.traverse((SOAPBody)e, (Object)bindingOutput, wSDLTraversalContext);
                } else if (this.traverseBindingOutput2SOAPHeader && e instanceof SOAPHeader) {
                    this.traverse((SOAPHeader)e, (Object)bindingOutput, wSDLTraversalContext);
                }
                if (wSDLTraversalContext.processBindingOutput()) continue;
                return;
            }
        }
        if (this.traverseBindingOutput2ExtensibilityElement && bindingOutput.getExtensibilityElements() != null) {
            iterator = bindingOutput.getExtensibilityElements().iterator();
            while (iterator.hasNext()) {
                this.traverse((ExtensibilityElement)iterator.next(), (Object)bindingOutput, wSDLTraversalContext);
                if (wSDLTraversalContext.processBindingOutput()) continue;
                return;
            }
        }
    }

    private void traverse(PortType portType, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.resumePortTypeProcessing();
        wSDLTraversalContext.setPortType(portType);
        if (this.visitPortType) {
            this.visitor.visit(portType, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processPortType()) {
                return;
            }
        }
        if (portType == null) {
            return;
        }
        if (this.traversePortType2Element) {
            this.traverse(portType.getDocumentationElement(), (Object)portType, wSDLTraversalContext);
            if (!wSDLTraversalContext.processPortType()) {
                return;
            }
        }
        if (this.traversePortType2Operation && portType.getOperations() != null) {
            Iterator iterator = portType.getOperations().iterator();
            while (iterator.hasNext()) {
                this.traverse((Operation)iterator.next(), (Object)portType, wSDLTraversalContext);
                if (wSDLTraversalContext.processPortType()) continue;
                return;
            }
        }
    }

    private void traverse(Message message, Object object, WSDLTraversalContext wSDLTraversalContext) {
        wSDLTraversalContext.resumeMessageProcessing();
        wSDLTraversalContext.setMessage(message);
        if (this.visitMessage) {
            this.visitor.visit(message, object, wSDLTraversalContext);
            if (!wSDLTraversalContext.processMessage()) {
                return;
            }
        }
        if (message == null) {
            return;
        }
        if (this.traverseMessage2Element) {
            this.traverse(message.getDocumentationElement(), (Object)message, wSDLTraversalContext);
            if (!wSDLTraversalContext.processMessage()) {
                return;
            }
        }
        if (this.traverseMessage2Part && message.getParts() != null) {
            Iterator iterator = message.getParts().values().iterator();
            while (iterator.hasNext()) {
                this.traverse((Part)iterator.next(), (Object)message, wSDLTraversalContext);
                if (wSDLTraversalContext.processMessage()) continue;
                return;
            }
        }
    }

    public void traverse(Part part) {
        this.adjust();
        this.traverse(part, null, new WSDLTraversalContext(this));
    }

    public void traverse(Service service) {
        this.adjust();
        this.traverse(service, null, new WSDLTraversalContext(this));
    }

    public void traverse(Types types) {
        this.adjust();
        this.traverse(types, null, new WSDLTraversalContext(this));
    }

    public void traverse(Operation operation) {
        this.adjust();
        this.traverse(operation, null, new WSDLTraversalContext(this));
    }

    public void traverse(Input input) {
        this.adjust();
        this.traverse(input, null, new WSDLTraversalContext(this));
    }

    public void traverse(Output output) {
        this.adjust();
        this.traverse(output, null, new WSDLTraversalContext(this));
    }

    public void traverse(Fault fault) {
        this.adjust();
        this.traverse(fault, null, new WSDLTraversalContext(this));
    }

    public void traverse(Binding binding) {
        this.adjust();
        this.traverse(binding, null, new WSDLTraversalContext(this));
    }

    public void traverse(BindingOperation bindingOperation) {
        this.adjust();
        this.traverse(bindingOperation, null, new WSDLTraversalContext(this));
    }

    public void traverse(BindingInput bindingInput) {
        this.adjust();
        this.traverse(bindingInput, null, new WSDLTraversalContext(this));
    }

    public void traverse(BindingOutput bindingOutput) {
        this.adjust();
        this.traverse(bindingOutput, null, new WSDLTraversalContext(this));
    }

    public void traverse(BindingFault bindingFault) {
        this.adjust();
        this.traverse(bindingFault, null, new WSDLTraversalContext(this));
    }

    public void traverse(Import import_) {
        this.adjust();
        this.traverse(import_, null, new WSDLTraversalContext(this));
    }

    public void traverse(Element element) {
        this.adjust();
        this.traverse(element, null, new WSDLTraversalContext(this));
    }

    public void traverse(Message message) {
        this.adjust();
        this.traverse(message, null, new WSDLTraversalContext(this));
    }

    public void traverse(Port port) {
        this.adjust();
        this.traverse(port, null, new WSDLTraversalContext(this));
    }

    public void traverse(PortType portType) {
        this.adjust();
        this.traverse(portType, null, new WSDLTraversalContext(this));
    }

    public void traverse(Definition definition) {
        this.adjust();
        this.traverse(definition, null, new WSDLTraversalContext(this));
    }

    public void traverse(ExtensibilityElement extensibilityElement) {
        this.adjust();
        this.traverse(extensibilityElement, null, new WSDLTraversalContext(this));
    }

    public void traverse(SOAPBinding sOAPBinding) {
        this.adjust();
        this.traverse(sOAPBinding, null, new WSDLTraversalContext(this));
    }

    public void traverse(SOAPBody sOAPBody) {
        this.adjust();
        this.traverse(sOAPBody, null, new WSDLTraversalContext(this));
    }

    public void traverse(SOAPHeader sOAPHeader) {
        this.adjust();
        this.traverse(sOAPHeader, null, new WSDLTraversalContext(this));
    }

    public void traverse(SOAPHeaderFault sOAPHeaderFault) {
        this.adjust();
        this.traverse(sOAPHeaderFault, null, new WSDLTraversalContext(this));
    }

    public void traverse(SOAPFault sOAPFault) {
        this.adjust();
        this.traverse(sOAPFault, null, new WSDLTraversalContext(this));
    }

    public void traverse(SOAPOperation sOAPOperation) {
        this.adjust();
        this.traverse(sOAPOperation, null, new WSDLTraversalContext(this));
    }

    public void traverse(Part part, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(part, null, wSDLTraversalContext);
    }

    public void traverse(Service service, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(service, null, wSDLTraversalContext);
    }

    public void traverse(Types types, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(types, null, wSDLTraversalContext);
    }

    public void traverse(Operation operation, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(operation, null, wSDLTraversalContext);
    }

    public void traverse(Input input, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(input, null, wSDLTraversalContext);
    }

    public void traverse(Output output, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(output, null, wSDLTraversalContext);
    }

    public void traverse(Fault fault, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(fault, null, wSDLTraversalContext);
    }

    public void traverse(Binding binding, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(binding, null, wSDLTraversalContext);
    }

    public void traverse(BindingOperation bindingOperation, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(bindingOperation, null, wSDLTraversalContext);
    }

    public void traverse(BindingInput bindingInput, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(bindingInput, null, wSDLTraversalContext);
    }

    public void traverse(BindingOutput bindingOutput, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(bindingOutput, null, wSDLTraversalContext);
    }

    public void traverse(BindingFault bindingFault, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(bindingFault, null, wSDLTraversalContext);
    }

    public void traverse(Import import_, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(import_, null, wSDLTraversalContext);
    }

    public void traverse(Element element, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(element, null, wSDLTraversalContext);
    }

    public void traverse(Message message, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(message, null, wSDLTraversalContext);
    }

    public void traverse(Port port, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(port, null, wSDLTraversalContext);
    }

    public void traverse(PortType portType, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(portType, null, wSDLTraversalContext);
    }

    public void traverse(Definition definition, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(definition, null, wSDLTraversalContext);
    }

    public void traverse(ExtensibilityElement extensibilityElement, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(extensibilityElement, null, wSDLTraversalContext);
    }

    public void traverse(SOAPBinding sOAPBinding, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(sOAPBinding, null, wSDLTraversalContext);
    }

    public void traverse(SOAPBody sOAPBody, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(sOAPBody, null, wSDLTraversalContext);
    }

    public void traverse(SOAPHeader sOAPHeader, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(sOAPHeader, null, wSDLTraversalContext);
    }

    public void traverse(SOAPHeaderFault sOAPHeaderFault, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(sOAPHeaderFault, null, wSDLTraversalContext);
    }

    public void traverse(SOAPFault sOAPFault, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(sOAPFault, null, wSDLTraversalContext);
    }

    public void traverse(SOAPOperation sOAPOperation, Map map) {
        this.adjust();
        WSDLTraversalContext wSDLTraversalContext = new WSDLTraversalContext(this);
        if (map != null) {
            wSDLTraversalContext.params.putAll(map);
        }
        this.traverse(sOAPOperation, null, wSDLTraversalContext);
    }
}

