/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.wsdl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.PortType;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;

public final class WSDLUtils {
    public static boolean isRpcLiteral(String string, BindingOperation bindingOperation) {
        return WSDLUtils.checkStyleAndUse("rpc", "literal", string, bindingOperation);
    }

    public static boolean isDocLiteral(String string, BindingOperation bindingOperation) {
        return WSDLUtils.checkStyleAndUse("document", "literal", string, bindingOperation);
    }

    private static boolean checkStyleAndUse(String string, String string2, String string3, BindingOperation bindingOperation) {
        boolean bl = false;
        boolean bl2 = false;
        SOAPOperation sOAPOperation = WSDLUtils.getSoapOperation(bindingOperation);
        if (sOAPOperation == null || sOAPOperation.getStyle() == null) {
            if (string.equals(string3)) {
                bl = true;
            }
        } else if (string.equals(sOAPOperation.getStyle())) {
            bl = true;
        }
        if (bl) {
            SOAPBody sOAPBody = WSDLUtils.getInputSoapBody(bindingOperation);
            if (sOAPBody == null || sOAPBody.getUse() == null) {
                if (string2.equals("literal")) {
                    bl2 = true;
                }
            } else if (string2.equals(sOAPBody.getUse())) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static SOAPBinding getSoapBinding(Binding binding) {
        SOAPBinding sOAPBinding = null;
        List list = null;
        list = binding.getExtensibilityElements();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && sOAPBinding == null) {
                Object e = iterator.next();
                if (!(e instanceof SOAPBinding)) continue;
                sOAPBinding = (SOAPBinding)e;
            }
        }
        return sOAPBinding;
    }

    public static SOAPOperation getSoapOperation(BindingOperation bindingOperation) {
        SOAPOperation sOAPOperation = null;
        List list = null;
        list = bindingOperation.getExtensibilityElements();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && sOAPOperation == null) {
                Object e = iterator.next();
                if (!(e instanceof SOAPOperation)) continue;
                sOAPOperation = (SOAPOperation)e;
            }
        }
        return sOAPOperation;
    }

    public static SOAPBody getInputSoapBody(BindingOperation bindingOperation) {
        SOAPBody sOAPBody = null;
        List list = null;
        list = bindingOperation.getBindingInput().getExtensibilityElements();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && sOAPBody == null) {
                Object e = iterator.next();
                if (!(e instanceof SOAPBody)) continue;
                sOAPBody = (SOAPBody)e;
            }
        }
        return sOAPBody;
    }

    public static HashSet findMessages(Definition definition, Binding binding) {
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = WSDLUtils.findMessages(binding.getPortType());
        Iterator iterator = binding.getBindingOperations().iterator();
        while (iterator.hasNext()) {
            HashSet hashSet3;
            BindingOperation bindingOperation = (BindingOperation)iterator.next();
            if (bindingOperation.getBindingInput() != null) {
                hashSet3 = WSDLUtils.findMessages(bindingOperation.getBindingInput().getExtensibilityElements().iterator(), hashSet2, definition);
                hashSet.addAll(hashSet3);
            }
            if (bindingOperation.getBindingOutput() == null) continue;
            hashSet3 = WSDLUtils.findMessages(bindingOperation.getBindingOutput().getExtensibilityElements().iterator(), hashSet2, definition);
            hashSet.addAll(hashSet3);
        }
        return hashSet;
    }

    public static HashSet findMessages(PortType portType) {
        HashSet<Message> hashSet = new HashSet<Message>();
        Iterator iterator = portType.getOperations().iterator();
        while (iterator.hasNext()) {
            Operation operation = (Operation)iterator.next();
            if (operation.getInput() != null) {
                hashSet.add(operation.getInput().getMessage());
            }
            if (operation.getOutput() != null) {
                hashSet.add(operation.getOutput().getMessage());
            }
            Iterator iterator2 = operation.getFaults().values().iterator();
            while (iterator2.hasNext()) {
                hashSet.add(((Fault)iterator2.next()).getMessage());
            }
        }
        return hashSet;
    }

    protected static HashSet findMessages(Iterator iterator, HashSet hashSet, Definition definition) {
        HashSet<Message> hashSet2 = new HashSet<Message>();
        Message message = null;
        while (iterator.hasNext()) {
            Message message2;
            ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
            if (!(extensibilityElement instanceof SOAPHeader)) continue;
            SOAPHeader sOAPHeader = (SOAPHeader)extensibilityElement;
            QName qName = sOAPHeader.getMessage();
            if (qName != null) {
                message2 = definition.getMessage(qName);
                if (message2 == null) {
                    message2 = definition.createMessage();
                    message2.setQName(qName);
                    message2.setUndefined(true);
                }
                if (!hashSet.contains(message2)) {
                    hashSet2.add(message2);
                    message = message2;
                }
            }
            Iterator iterator2 = sOAPHeader.getSOAPHeaderFaults().iterator();
            while (iterator2.hasNext()) {
                SOAPHeaderFault sOAPHeaderFault = (SOAPHeaderFault)iterator2.next();
                qName = sOAPHeaderFault.getMessage();
                if (qName == null) continue;
                message2 = definition.getMessage(qName);
                if (message2 == null) {
                    message2 = definition.createMessage();
                    message2.setQName(qName);
                    message2.setUndefined(true);
                }
                if (hashSet.contains(message2) || message != null && (message == null || message.getQName().equals(message2.getQName()))) continue;
                hashSet2.add(message2);
            }
        }
        return hashSet2;
    }
}

