/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.WSITag;
import org.wsi.test.profile.validator.BaseValidator;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.wsdl.traversal.WSDLVisitor;
import org.wsi.xml.XMLTags;
import org.wsi.xml.XMLUtils;

public final class TypesRegistry
implements WSITag,
WSDLVisitor {
    private Map element2Type = new HashMap();
    private Set extendsArray = new HashSet();
    private Set usesWsdlArrayType = new HashSet();
    protected BaseValidator baseValidator = null;

    public void visit(Part part, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(Service service, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(Types types, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(Operation operation, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(Input input, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(Output output, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(Fault fault, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(Binding binding, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(BindingOperation bindingOperation, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(BindingInput bindingInput, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(BindingOutput bindingOutput, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(BindingFault bindingFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(Element element, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(Message message, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(Port port, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(PortType portType, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(Definition definition, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(ExtensibilityElement extensibilityElement, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(SOAPBinding sOAPBinding, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(SOAPBody sOAPBody, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(SOAPHeader sOAPHeader, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(SOAPHeaderFault sOAPHeaderFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(SOAPFault sOAPFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public void visit(SOAPOperation sOAPOperation, Object object, WSDLTraversalContext wSDLTraversalContext) {
    }

    public TypesRegistry(Definition definition, BaseValidator baseValidator) {
        this.baseValidator = baseValidator;
        if (definition == null) {
            throw new IllegalArgumentException("Definition can not be null");
        }
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitImport(true);
        this.processTypes(definition.getTypes(), definition.getDocumentBaseURI());
        wSDLTraversal.traverse(definition);
    }

    public TypesRegistry(Types types, String string, BaseValidator baseValidator) {
        this.baseValidator = baseValidator;
        this.processTypes(types, string);
    }

    public QName getType(QName qName) {
        return (QName)this.element2Type.get(qName);
    }

    public Set getArrayTypes() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.usesWsdlArrayType);
        hashSet.addAll(this.extendsArray);
        return hashSet;
    }

    public Set getElementList() {
        return this.element2Type.keySet();
    }

    public boolean isUsesWSDLArrayType(QName qName) {
        return this.usesWsdlArrayType.contains(qName);
    }

    public boolean isExtendsArray(QName qName) {
        return this.extendsArray.contains(qName);
    }

    public void visit(Import import_, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (import_.getDefinition() != null) {
            this.processWSDL(import_.getDefinition());
        }
    }

    private void processWSDL(Definition definition) {
        if (definition.getTypes() != null) {
            this.processTypes(definition.getTypes(), definition.getDocumentBaseURI());
        }
    }

    private void processTypes(Types types, String string) {
        if (types == null) {
            return;
        }
        List list = types.getExtensibilityElements();
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
                if (!(extensibilityElement instanceof UnknownExtensibilityElement)) continue;
                this.searchForSchema(((UnknownExtensibilityElement)extensibilityElement).getElement(), string);
            }
        }
    }

    private void searchForSchema(Node node, String string) {
        while (node != null) {
            if (1 == node.getNodeType()) {
                if (XMLUtils.equals(node, XMLTags.ELEM_XSD_SCHEMA)) {
                    this.processSchema(node, string);
                } else if (XMLUtils.equals(node, XMLTags.ELEM_XSD_IMPORT)) {
                    this.loadSchema(node, string);
                } else if (XMLUtils.equals(node, XMLTags.ELEM_XSD_INCLUDE)) {
                    this.loadSchema(node, string);
                } else {
                    this.searchForSchema(node.getFirstChild(), string);
                }
            }
            node = node.getNextSibling();
        }
    }

    private void loadSchema(Node node, String string) {
        Element element = (Element)node;
        Attr attr = XMLUtils.getAttribute(element, XMLTags.ATTR_XSD_SCHEMALOCATION);
        if (attr != null && attr.getValue() != null) {
            try {
                Document document = this.baseValidator.parseXMLDocumentURL(attr.getValue(), string, null);
                if (XMLUtils.equals(document.getDocumentElement(), XMLTags.ELEM_XSD_SCHEMA)) {
                    this.processSchema(document.getDocumentElement(), XMLUtils.createURLString(attr.getValue(), string));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void processSchema(Node node, String string) {
        Attr attr = XMLUtils.getAttribute((Element)node, XMLTags.ATTR_XSD_TARGETNAMESPACE);
        String string2 = attr != null ? attr.getValue() : "";
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            QName qName;
            Element element;
            if (1 != node2.getNodeType()) continue;
            if (XMLUtils.equals(node2, XMLTags.ELEM_XSD_ELEMENT)) {
                element = (Element)node2;
                attr = XMLUtils.getAttribute(element, XMLTags.ATTR_XSD_NAME);
                qName = new QName(string2, attr != null ? attr.getValue() : "");
                attr = XMLUtils.getAttribute(element, XMLTags.ATTR_XSD_TYPE);
                QName qName2 = null;
                if (attr != null) {
                    String string3 = attr.getValue();
                    int n = string3.indexOf(58);
                    if (n != -1) {
                        String string4 = string3.substring(0, n);
                        String string5 = XMLUtils.findNamespaceURI(node2, string4);
                        qName2 = new QName(string5, string3.substring(n + 1));
                    } else {
                        qName2 = new QName(string2, string3);
                    }
                } else {
                    qName2 = qName;
                    this.checkType(node2, qName2);
                }
                this.element2Type.put(qName, qName2);
                continue;
            }
            if (XMLUtils.equals(node2, XMLTags.ELEM_XSD_IMPORT)) {
                this.loadSchema(node2, string);
                continue;
            }
            if (XMLUtils.equals(node2, XMLTags.ELEM_XSD_INCLUDE)) {
                this.loadSchema(node2, string);
                continue;
            }
            if (!XMLUtils.equals(node2, XMLTags.ELEM_XSD_COMPLEXTYPE)) continue;
            element = (Element)node2;
            attr = XMLUtils.getAttribute(element, XMLTags.ATTR_XSD_NAME);
            qName = new QName(string2, attr != null ? attr.getValue() : "");
            this.checkType(node2, qName);
        }
    }

    private void checkType(Node node, QName qName) {
        while (node != null) {
            if (1 == node.getNodeType()) {
                String string;
                int n;
                Attr attr;
                if (XMLUtils.equals(node, XMLTags.ELEM_XSD_ATTRIBUTE) && (attr = XMLUtils.getAttribute((Element)node, WSITag.ATTR_WSDL_ARRAYTYPE)) != null) {
                    this.usesWsdlArrayType.add(qName);
                }
                if ((attr = XMLUtils.getAttribute((Element)node, XMLTags.ATTR_XSD_BASE)) != null && (n = (string = attr.getValue()).indexOf(":")) != -1) {
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    String string4 = XMLUtils.findNamespaceURI(node, string2);
                    if (WSITag.SOAPENC_ARRAY.equals(new QName(string4, string3))) {
                        this.extendsArray.add(qName);
                    }
                }
                this.checkType(node.getFirstChild(), qName);
            }
            node = node.getNextSibling();
        }
    }
}

