/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.xml.XMLDocumentCache;
import org.wsi.xml.schema.XMLSchemaProcessor;

public class BP4202
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private static final String ANNOTATION_KEY = "annotation";
    private ErrorList errorList = new ErrorList();
    private AnnotationProcessor processor;

    public BP4202(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public void visit(ExtensibilityElement extensibilityElement, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (extensibilityElement != null && extensibilityElement instanceof UnknownExtensibilityElement) {
            UnknownExtensibilityElement unknownExtensibilityElement = (UnknownExtensibilityElement)extensibilityElement;
            try {
                this.processor.processAllSchema(unknownExtensibilityElement.getElement());
            }
            catch (WSIException wSIException) {
                // empty catch block
            }
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Types types = (Types)entryContext.getEntry().getEntryDetail();
        this.processor = new AnnotationProcessor(entryContext.getWSDLDocument().getDefinitions().getDocumentBaseURI(), this.validator.getDocumentList());
        WSDLTraversal wSDLTraversal = new WSDLTraversal();
        wSDLTraversal.setVisitor(this);
        wSDLTraversal.visitExtensibilityElement(true);
        wSDLTraversal.ignoreReferences();
        wSDLTraversal.traverse(types);
        if (this.errorList.isEmpty()) {
            return this.validator.createAssertionResult(testAssertion, "notApplicable", (String)null);
        }
        this.failureDetail = this.validator.createFailureDetail(testAssertion.getFailureMessage() + "\n\n" + this.errorList.toString(), entryContext);
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    class AnnotationProcessor
    extends XMLSchemaProcessor {
        public AnnotationProcessor(String string, XMLDocumentCache xMLDocumentCache) {
            super(string, xMLDocumentCache, false);
        }

        protected void processSchema(Element element) {
            this.checkForAnnotation(element);
        }

        private void checkForAnnotation(Node node) {
            if (node.getLocalName() != null && node.getLocalName().equals(BP4202.ANNOTATION_KEY)) {
                BP4202.this.errorList.add(node.toString());
            }
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                this.checkForAnnotation(node.getChildNodes().item(i));
            }
        }
    }
}

