/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.TestUtils;
import org.wsi.util.Utils;
import org.wsi.xml.XMLUtils;
import org.xml.sax.SAXException;

public class BP2703
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2703(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        try {
            Definition definition = (Definition)entryContext.getEntry().getEntryDetail();
            if (definition == null) {
                throw new AssertionFailException("Definition null");
            }
            String string = entryContext.getEntry().getReferenceID();
            Map map = definition.getNamespaces();
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if ("http://schemas.xmlsoap.org/wsdl/".equalsIgnoreCase(string2)) {
                    XMLUtils.parseXMLDocument(string, TestUtils.getWSDLSchemaLocation());
                }
                if (!"http://schemas.xmlsoap.org/wsdl/soap/".equalsIgnoreCase(string2)) continue;
                XMLUtils.parseXMLDocument(string, TestUtils.getWSDLSOAPSchemaLocation());
            }
        }
        catch (WSIException wSIException) {
            if (wSIException.getTargetException() instanceof SAXException) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail(Utils.getExceptionDetails(wSIException.getTargetException()), entryContext);
            }
        }
        catch (Exception exception) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(Utils.getExceptionDetails(exception), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

