/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.List;
import javax.wsdl.Definition;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.xml.XMLTags;

public class BP2122
extends AssertionProcess {
    private final WSDLValidatorImpl validator;
    private String context;

    public BP2122(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        ErrorList errorList = new ErrorList();
        Types types = (Types)entryContext.getEntry().getEntryDetail();
        Definition definition = null;
        if (types != null) {
            definition = this.validator.analyzerContext.getCandidateInfo().getDefinition(types);
            if (definition == null) {
                throw new WSIException("Could not find types definition in any WSDL document.");
            }
            this.context = definition.getDocumentBaseURI();
            List list = types.getExtensibilityElements();
            for (int i = 0; i < list.size(); ++i) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)list.get(i);
                if (!(extensibilityElement instanceof UnknownExtensibilityElement) || extensibilityElement.getElementType().equals(XMLTags.ELEM_XSD_SCHEMA)) continue;
                errorList.add(extensibilityElement.getElementType().toString() + " can not be a child of the wsdl:types element.");
            }
        }
        if (errorList.isEmpty()) {
            errorList.add(this.validator.wsdlDocument.getSchemasValidationErrors());
        }
        if (!errorList.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(errorList.toString(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

