/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.ErrorList;
import org.wsi.xml.XMLTags;
import org.wsi.xml.XMLUtils;

public class BP2107
extends AssertionProcess
implements WSITag {
    private final WSDLValidatorImpl validator;
    private boolean schemaFound = false;
    private ErrorList errors = new ErrorList();
    private String context;

    public BP2107(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        Types types = (Types)entryContext.getEntry().getEntryDetail();
        List list = types.getExtensibilityElements();
        if (list != null) {
            this.context = entryContext.getWSDLDocument().getDefinitions().getDocumentBaseURI();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExtensibilityElement extensibilityElement = (ExtensibilityElement)iterator.next();
                if (!(extensibilityElement instanceof UnknownExtensibilityElement)) continue;
                this.searchForSchema(((UnknownExtensibilityElement)extensibilityElement).getElement());
            }
        }
        if (!this.errors.isEmpty()) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
        } else {
            this.result = !this.schemaFound ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private void searchForSchema(Node node) {
        while (node != null) {
            if (1 == node.getNodeType()) {
                if (XMLUtils.equals(node, XMLTags.ELEM_XSD_SCHEMA)) {
                    this.schemaFound = true;
                    this.processSchema(node, null);
                } else {
                    this.searchForSchema(node.getFirstChild());
                }
            }
            node = node.getNextSibling();
        }
    }

    private void loadSchema(Node node) {
        Element element = (Element)node;
        Attr attr = XMLUtils.getAttribute(element, XMLTags.ATTR_XSD_SCHEMALOCATION);
        if (attr != null && attr.getValue() != null) {
            try {
                Document document = this.validator.parseXMLDocumentURL(attr.getValue(), this.context);
                if (XMLUtils.equals(document.getDocumentElement(), XMLTags.ELEM_XSD_SCHEMA)) {
                    Attr attr2 = XMLUtils.getAttribute(element, XMLTags.ATTR_XSD_NAMESPACE);
                    String string = attr2 != null ? attr2.getValue() : "";
                    this.processSchema(document.getDocumentElement(), string);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void processSchema(Node node, String string) {
        Attr attr = XMLUtils.getAttribute((Element)node, XMLTags.ATTR_XSD_TARGETNAMESPACE);
        String string2 = attr != null ? attr.getValue() : null;
        boolean bl = true;
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1) continue;
            bl &= XMLUtils.equals(node2, XMLTags.ELEM_XSD_IMPORT) || XMLUtils.equals(node2, XMLTags.ELEM_XSD_ANNOTATION);
        }
        if (!(string2 != null && string2.length() != 0 || bl)) {
            this.errors.add(string2, XMLUtils.serialize((Element)node));
        }
        if (string != null && !string.equals(string2)) {
            this.errors.add(string, XMLUtils.serialize((Element)node));
        }
    }
}

