/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import java.util.Iterator;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class BP2021
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2021(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        SOAPHeader[] sOAPHeaderArray = this.validator.getSoapHeaders(binding);
        if (sOAPHeaderArray.length == 0) {
            this.result = "notApplicable";
        } else {
            for (int i = 0; i < sOAPHeaderArray.length && this.result.equals("passed"); ++i) {
                if (sOAPHeaderArray[i].getPart() == null || !XMLUtils.isNmtoken(sOAPHeaderArray[i].getPart())) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(sOAPHeaderArray[i].toString(), entryContext);
                    continue;
                }
                List list = sOAPHeaderArray[i].getSOAPHeaderFaults();
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && this.result.equals("passed")) {
                    SOAPHeaderFault sOAPHeaderFault = (SOAPHeaderFault)iterator.next();
                    if (sOAPHeaderFault.getPart() != null && XMLUtils.isNmtoken(sOAPHeaderFault.getPart())) continue;
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(sOAPHeaderFault.toString(), entryContext);
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

