/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.wsdl;

import javax.wsdl.Binding;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import org.apache.xerces.util.URI;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.wsi.test.report.AssertionResult;

public class BP2020
extends AssertionProcess {
    private final WSDLValidatorImpl validator;

    public BP2020(WSDLValidatorImpl wSDLValidatorImpl) {
        super(wSDLValidatorImpl);
        this.validator = wSDLValidatorImpl;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        boolean bl = false;
        Binding binding = (Binding)entryContext.getEntry().getEntryDetail();
        SOAPBinding sOAPBinding = WSDLValidatorImpl.getSoapBinding(binding);
        String string = "document";
        if (sOAPBinding != null) {
            String string2 = string = sOAPBinding.getStyle() == null ? "document" : sOAPBinding.getStyle();
        }
        if (sOAPBinding != null && string.equals("rpc")) {
            SOAPBody[] sOAPBodyArray = this.validator.getSoapBodies(binding);
            boolean bl2 = false;
            String string3 = null;
            for (int i = 0; i < sOAPBodyArray.length && !bl2; ++i) {
                SOAPBody sOAPBody = sOAPBodyArray[i];
                if (sOAPBody.getUse() != null && !sOAPBody.getUse().equals("literal")) continue;
                bl = true;
                string3 = sOAPBody.getNamespaceURI();
                if (string3 == null) {
                    bl2 = true;
                    this.failureDetail = this.validator.createFailureDetail("--- SOAP BODY:\n" + sOAPBody.toString() + "\n--- BINDING QNAME:\n" + binding.getQName(), entryContext);
                    continue;
                }
                try {
                    URI uRI = new URI(string3);
                    if (uRI.getScheme() != null) continue;
                    bl2 = true;
                    this.failureDetail = this.validator.createFailureDetail("--- SOAP BODY:\n" + sOAPBody.toString() + "\n--- BINDING QNAME:\n" + binding.getQName(), entryContext);
                    continue;
                }
                catch (URI.MalformedURIException malformedURIException) {
                    bl2 = true;
                    this.failureDetail = this.validator.createFailureDetail("--- SOAP BODY:\n" + sOAPBody.toString() + "\n--- BINDING QNAME:\n" + binding.getQName(), entryContext);
                }
            }
            if (!bl) {
                this.result = "notApplicable";
                this.failureDetail = null;
            } else if (!bl2) {
                this.result = "passed";
                this.failureDetail = null;
            }
        } else {
            this.result = "notApplicable";
            this.failureDetail = null;
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

