/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.uddi;

import com.ibm.wsdl.util.StringUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.WSDLException;
import org.uddi4j.client.UDDIProxy;
import org.uddi4j.datatype.binding.BindingTemplate;
import org.uddi4j.datatype.binding.TModelInstanceInfo;
import org.uddi4j.datatype.tmodel.TModel;
import org.uddi4j.util.CategoryBag;
import org.uddi4j.util.KeyedReference;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AnalyzerContext;
import org.wsi.test.analyzer.ServiceReference;
import org.wsi.test.analyzer.config.UDDIReference;
import org.wsi.test.analyzer.config.WSDLElement;
import org.wsi.test.analyzer.config.impl.WSDLElementImpl;
import org.wsi.test.profile.ProfileArtifact;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.UDDIValidator;
import org.wsi.test.profile.validator.impl.BaseValidatorImpl;
import org.wsi.test.report.Entry;
import org.wsi.test.report.ReportArtifact;
import org.wsi.test.report.Reporter;
import org.wsi.test.util.EntryType;
import org.wsi.util.UDDIUtils;
import org.wsi.wsdl.WSDLDocument;

public class UDDIValidatorImpl
extends BaseValidatorImpl
implements UDDIValidator {
    protected UDDIReference uddiReference;
    protected UDDIProxy uddiProxy;
    private Binding binding = null;

    public void init(AnalyzerContext analyzerContext, ProfileArtifact profileArtifact, ReportArtifact reportArtifact, UDDIReference uDDIReference, Reporter reporter) throws WSIException {
        super.init(analyzerContext, profileArtifact, reportArtifact, reporter);
        this.uddiReference = uDDIReference;
    }

    public String validate() throws WSIException {
        String string = null;
        Entry entry = null;
        BindingTemplate bindingTemplate = null;
        TModel tModel = null;
        String string2 = this.getClass().getPackage().getName() + ".";
        try {
            block15: {
                Object object;
                this.uddiProxy = new UDDIProxy();
                this.uddiProxy.setInquiryURL(this.uddiReference.getInquiryURL());
                boolean bl = false;
                try {
                    object = StringUtils.getURL(null, (String)this.uddiReference.getInquiryURL());
                    StringUtils.getContentAsInputStream((URL)object);
                }
                catch (UnknownHostException unknownHostException) {
                    bl = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!bl) {
                    if (this.uddiReference.getKeyType().equals("bindingKey")) {
                        object = this.uddiProxy.get_bindingDetail(this.uddiReference.getKey());
                        bindingTemplate = (BindingTemplate)object.getBindingTemplateVector().elementAt(0);
                        if (this.verboseOption) {
                            System.err.println("    BindingTemplate - " + UDDIUtils.bindingTemplateToString(bindingTemplate));
                        }
                        tModel = this.findTModel(this.uddiProxy, bindingTemplate);
                    } else {
                        object = this.uddiProxy.get_tModelDetail(this.uddiReference.getKey());
                        tModel = (TModel)object.getTModelVector().elementAt(0);
                    }
                    if (this.verboseOption) {
                        System.err.println("    TModel specified or found in bindingTemplate - " + UDDIUtils.tModelToString(tModel));
                    }
                }
                if (bindingTemplate == null) {
                    this.setMissingInput(EntryType.getEntryType("bindingTemplate"));
                } else {
                    entry = this.reporter.getReport().createEntry();
                    entry.setEntryType(EntryType.getEntryType("bindingTemplate"));
                    entry.setReferenceID(bindingTemplate.getBindingKey());
                    entry.setEntryDetail(bindingTemplate);
                    this.processAssertions(string2, new EntryContext(entry, this.analyzerContext));
                }
                try {
                    object = this.getOverviewURL(tModel);
                    string = this.getWSDLLocation((String)object);
                    WSDLDocument wSDLDocument = this.getWSDLDocument(string);
                    this.binding = this.getBinding((String)object, wSDLDocument);
                }
                catch (Exception exception) {
                    if (!this.verboseOption) break block15;
                    System.err.println("    EXCEPTION: " + exception.toString());
                }
            }
            entry = this.reporter.getReport().createEntry();
            entry.setEntryType(EntryType.getEntryType("tModel"));
            entry.setReferenceID(tModel == null ? "[tModel]" : tModel.getTModelKey());
            entry.setEntryDetail(tModel);
            this.processAssertions(string2, new EntryContext(entry, this.analyzerContext));
        }
        catch (Exception exception) {
            if (exception instanceof WSIException) {
                throw (WSIException)exception;
            }
            throw new WSIException("An exception occurred while processing the discovery test assertions.", exception);
        }
        this.cleanup();
        string = this.analyzerContext.getServiceReference().getWSDLLocation();
        return string;
    }

    protected void setWSDLBinding(Binding binding) {
        String string = binding == null ? null : binding.getQName().getLocalPart();
        String string2 = binding == null ? null : binding.getQName().getNamespaceURI();
        ServiceReference serviceReference = this.analyzerContext.getServiceReference();
        WSDLElement wSDLElement = serviceReference.getWSDLElement();
        if (wSDLElement == null) {
            wSDLElement = new WSDLElementImpl();
            wSDLElement.setName(string);
            wSDLElement.setNamespace(string2);
            wSDLElement.setType("binding");
        }
        serviceReference.setWSDLElement(wSDLElement);
        this.analyzerContext.setServiceReference(serviceReference);
    }

    protected void setWSDLLocation(String string) {
        ServiceReference serviceReference = this.analyzerContext.getServiceReference();
        serviceReference.setWSDLLocation(string);
        this.analyzerContext.setServiceReference(serviceReference);
    }

    private TModel findTModel(UDDIProxy uDDIProxy, BindingTemplate bindingTemplate) throws WSIException {
        TModelInstanceInfo tModelInstanceInfo;
        TModel tModel = null;
        Iterator iterator = bindingTemplate.getTModelInstanceDetails().getTModelInstanceInfoVector().iterator();
        Vector<String> vector = new Vector<String>();
        while (iterator.hasNext()) {
            tModelInstanceInfo = (TModelInstanceInfo)iterator.next();
            vector.add(tModelInstanceInfo.getTModelKey());
        }
        if (vector.size() > 0) {
            try {
                tModelInstanceInfo = uDDIProxy.get_tModelDetail(vector);
                Iterator iterator2 = tModelInstanceInfo.getTModelVector().iterator();
                TModel tModel2 = null;
                while (iterator2.hasNext() && tModel == null) {
                    tModel2 = (TModel)iterator2.next();
                    if (this.verboseOption) {
                        System.err.println("      TModel referenced from bindingTemplate - " + UDDIUtils.tModelToString(tModel2));
                    }
                    if (!this.isWsdlSpec(tModel2)) continue;
                    tModel = tModel2;
                }
            }
            catch (Exception exception) {
                throw new WSIException("Could not get tModel details.", exception);
            }
        }
        return tModel;
    }

    protected boolean isWsdlSpec(TModel tModel) {
        boolean bl = false;
        CategoryBag categoryBag = null;
        Iterator iterator = null;
        categoryBag = tModel.getCategoryBag();
        if (categoryBag != null) {
            iterator = categoryBag.getKeyedReferenceVector().iterator();
            KeyedReference keyedReference = null;
            while (iterator.hasNext() && !bl) {
                keyedReference = (KeyedReference)iterator.next();
                if (!keyedReference.getTModelKey().equalsIgnoreCase("UUID:C1ACF26D-9672-4404-9D70-39B756E62AB4") || !"wsdlSpec".equals(keyedReference.getKeyValue())) continue;
                bl = true;
            }
        }
        return bl;
    }

    protected String getOverviewURL(TModel tModel) {
        if (tModel != null && tModel.getOverviewDoc() != null && tModel.getOverviewDoc().getOverviewURL() != null) {
            return tModel.getOverviewDoc().getOverviewURL().getText();
        }
        return null;
    }

    protected String getWSDLLocation(String string) {
        int n = string.indexOf("#");
        if (n > -1) {
            string = string.substring(0, n);
        }
        return string;
    }

    protected WSDLDocument getWSDLDocument(String string) throws MalformedURLException, WSDLException {
        return new WSDLDocument(this.getWSDLLocation(string));
    }

    protected Binding getBinding(String string, WSDLDocument wSDLDocument) {
        int n;
        Binding[] bindingArray = wSDLDocument.getBindings();
        if (bindingArray == null || bindingArray.length == 0) {
            return null;
        }
        if (string != null && (n = string.indexOf("#")) > -1) {
            String string2 = "@name=";
            int n2 = string.substring(n + 1).indexOf(string2);
            if (n2 > -1) {
                int n3 = n + 1 + n2 + string2.length();
                String string3 = string.substring(n3, n3 + 1);
                String string4 = string.substring(n3 + 1);
                int n4 = string4.indexOf(string3);
                if (n4 > -1) {
                    String string5 = string4.substring(0, n4);
                    for (int i = 0; i < bindingArray.length; ++i) {
                        if (!string5.equals(bindingArray[i].getQName().getLocalPart())) continue;
                        return bindingArray[i];
                    }
                }
            }
        }
        return bindingArray[0];
    }

    protected String categoryBagToString(CategoryBag categoryBag) {
        String string = "";
        if (categoryBag != null) {
            Vector vector = null;
            vector = categoryBag.getKeyedReferenceVector();
            if (vector == null || vector.size() == 0) {
                string = string + "No KeyedReferences";
            } else {
                int n = 1;
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    KeyedReference keyedReference = (KeyedReference)iterator.next();
                    string = string + "\n  [" + n++ + "] tModelKey: " + keyedReference.getTModelKey() + ", keyName: " + keyedReference.getKeyName() + ", keyValue: " + keyedReference.getKeyValue();
                }
            }
        } else {
            string = "null";
        }
        return string;
    }

    protected boolean isPrimaryEntryTypeMatch(TestAssertion testAssertion, EntryContext entryContext) {
        boolean bl = false;
        if (testAssertion.getEntryTypeName().equals(entryContext.getEntry().getEntryType().getTypeName())) {
            bl = true;
        }
        return bl;
    }

    protected boolean isNotApplicable(TestAssertion testAssertion) {
        boolean bl = false;
        return bl;
    }
}

