/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Part;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPFault;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.wsdl.extensions.soap.SOAPHeaderFault;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.NullUtil;
import org.wsi.test.util.OperationSignature;
import org.wsi.test.util.TypesRegistry;
import org.wsi.test.util.WSDLUtil;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;
import org.wsi.xml.XMLUtils;

public class WSI1108
extends AssertionProcessVisitor
implements WSITag {
    private final BaseMessageValidator validator;
    private OperationSignature.OperationMatch match = null;
    private EntryContext entryContext = null;
    private OperationSignature responseSig = null;
    private Vector headerRarts = null;
    private boolean visitFault = false;
    private boolean existSOAPHeader = true;
    private boolean isRequest = false;
    private boolean existSOAPHeaderFault = true;

    public WSI1108(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public void visit(SOAPBody sOAPBody, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Object object2;
        if (sOAPBody.getRequired() != null && sOAPBody.getRequired().booleanValue()) {
            return;
        }
        BindingOperation bindingOperation = wSDLTraversalContext.getBindingOperation();
        if (bindingOperation.getOperation() == null || bindingOperation.getOperation().getOutput() == null || bindingOperation.getOperation().getOutput().getMessage() == null) {
            return;
        }
        Message message = bindingOperation.getOperation().getOutput().getMessage();
        List list = WSDLUtil.getParts(bindingOperation.getOperation(), message, sOAPBody, this.match.getOperationStyle());
        QName qName = null;
        if ("rpc".equals(this.match.getOperationStyle())) {
            object2 = sOAPBody.getNamespaceURI();
            if (object2 == null || ((String)object2).length() == 0) {
                object2 = wSDLTraversalContext.getBinding().getQName().getNamespaceURI();
            }
            qName = new QName((String)object2, bindingOperation.getOperation().getOutput().getMessage().getQName().getLocalPart());
        }
        object2 = new OperationSignature(list, null, new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator), false);
        if (qName != null) {
            ((OperationSignature)object2).getSignature().add(0, qName);
        }
        if (!((Object)((OperationSignature)object2).getSignature()).equals(this.responseSig.getSignature())) {
            object2 = new OperationSignature(list, null, new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator), true);
            if (qName != null) {
                ((OperationSignature)object2).getSignature().add(0, qName);
            }
            if (!((Object)((OperationSignature)object2).getSignature()).equals(this.responseSig.getSignature())) {
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("\nMessage:\n" + this.entryContext.getMessageEntry().getMessage(), this.entryContext);
                wSDLTraversalContext.cancelBindingOperationProcessing();
            }
        }
    }

    public void visit(SOAPHeader sOAPHeader, Object object, WSDLTraversalContext wSDLTraversalContext) {
        if (!this.existSOAPHeaderFault) {
            this.existSOAPHeader = false;
            wSDLTraversalContext.cancelBindingOperationProcessing();
            return;
        }
        if (sOAPHeader.getRequired() != null && sOAPHeader.getRequired().booleanValue()) {
            return;
        }
        Definition definition = (Definition)wSDLTraversalContext.getParameter("definition");
        TypesRegistry typesRegistry = (TypesRegistry)wSDLTraversalContext.getParameter("TypesRegistry");
        Part part = WSDLUtil.getPart(definition.getMessage(sOAPHeader.getMessage()), sOAPHeader.getPart());
        QName qName = part.getTypeName();
        if (qName == null) {
            qName = typesRegistry.getType(part.getElementName());
        }
        if (qName == null) {
            throw new IllegalArgumentException("Part type can not be null." + part.getElementName().toString());
        }
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        this.existSOAPHeader = false;
        for (int i = 0; i < this.headerRarts.size(); ++i) {
            Element element = (Element)this.headerRarts.get(i);
            if (!element.getLocalName().equals(string) || !NullUtil.equals(string2, element.getNamespaceURI())) continue;
            this.existSOAPHeader = true;
            break;
        }
        if (this.existSOAPHeader) {
            wSDLTraversalContext.cancelSOAPHeaderProcessing();
        }
        if (this.isRequest) {
            wSDLTraversalContext.cancelBindingOperationProcessing();
        }
        if (!this.existSOAPHeader && !this.isRequest) {
            this.existSOAPHeaderFault = false;
        }
    }

    public void visit(SOAPHeaderFault sOAPHeaderFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        Definition definition = (Definition)wSDLTraversalContext.getParameter("definition");
        TypesRegistry typesRegistry = (TypesRegistry)wSDLTraversalContext.getParameter("TypesRegistry");
        Part part = WSDLUtil.getPart(definition.getMessage(sOAPHeaderFault.getMessage()), sOAPHeaderFault.getPart());
        QName qName = part.getTypeName();
        if (qName == null) {
            qName = typesRegistry.getType(part.getElementName());
        }
        if (qName == null) {
            throw new IllegalArgumentException("Part type can not be null." + part.getElementName().toString());
        }
        String string = qName.getLocalPart();
        String string2 = qName.getNamespaceURI();
        for (int i = 0; i < this.headerRarts.size(); ++i) {
            Element element = (Element)this.headerRarts.get(i);
            if (!element.getLocalName().equals(string) || !NullUtil.equals(string2, element.getNamespaceURI())) continue;
            this.existSOAPHeaderFault = true;
            break;
        }
        if (this.existSOAPHeaderFault) {
            wSDLTraversalContext.cancelSOAPHeaderProcessing();
        }
    }

    public void visit(SOAPFault sOAPFault, Object object, WSDLTraversalContext wSDLTraversalContext) {
        this.visitFault = true;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        if (this.validator.isOneWayResponse(entryContext)) {
            this.result = "notApplicable";
        } else {
            this.entryContext = entryContext;
            Document document = entryContext.getRequestDocument();
            this.match = OperationSignature.matchOperation(document, null, this.validator.analyzerContext.getCandidateInfo().getBindings()[0], new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator), false);
            if (this.match != null) {
                this.isRequest = "request".equals(entryContext.getMessageEntry().getType());
                document = entryContext.getMessageEntryDocument();
                if (!this.isRequest) {
                    this.responseSig = new OperationSignature(document);
                    if ("rpc".equals(this.match.getOperationStyle())) {
                        this.responseSig.createRPCSignature();
                    }
                }
                Element element = XMLUtils.findChildElement(document.getDocumentElement(), WSITag.ELEM_SOAP_HEADER);
                this.headerRarts = new Vector();
                if (element != null) {
                    this.headerRarts = XMLUtils.getChildElements(element);
                }
                WSDLTraversal wSDLTraversal = new WSDLTraversal();
                wSDLTraversal.setVisitor(this);
                wSDLTraversal.visitSOAPBody(true);
                wSDLTraversal.visitSOAPHeader(true);
                wSDLTraversal.visitSOAPHeaderFault(true);
                wSDLTraversal.visitSOAPFault(true);
                wSDLTraversal.ignoreReferences();
                wSDLTraversal.ignoreBindingInput2SOAPBody();
                if (this.isRequest) {
                    wSDLTraversal.ignoreBindingOutput();
                } else {
                    wSDLTraversal.ignoreBindingInput2SOAPHeader();
                }
                if (this.responseSig != null && this.responseSig.isFault()) {
                    wSDLTraversal.ignoreBindingOutput();
                } else {
                    wSDLTraversal.ignoreBindingFault();
                }
                this.existSOAPHeaderFault = true;
                HashMap<String, Object> hashMap = new HashMap<String, Object>();
                WSDLUtil.expandDefinition(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions());
                hashMap.put("definition", this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions());
                TypesRegistry typesRegistry = new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator);
                hashMap.put("TypesRegistry", typesRegistry);
                wSDLTraversal.traverse(this.match.getOperation(), hashMap);
                if (!this.isRequest && this.existSOAPHeaderFault) {
                    this.existSOAPHeader = true;
                }
                if (this.responseSig != null && this.responseSig.isFault() && !this.visitFault) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail("\nMessage:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                }
                if (!this.existSOAPHeader) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail("\nMessage:\n" + entryContext.getMessageEntry().getMessage(), entryContext);
                }
            } else {
                this.result = "notApplicable";
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

