/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.message;

import javax.wsdl.extensions.soap.SOAPOperation;
import org.w3c.dom.Document;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcessVisitor;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.OperationSignature;
import org.wsi.test.util.TypesRegistry;
import org.wsi.util.HTTPUtils;
import org.wsi.wsdl.traversal.WSDLTraversal;
import org.wsi.wsdl.traversal.WSDLTraversalContext;

public class BP1116
extends AssertionProcessVisitor {
    private final BaseMessageValidator validator;
    private String action = null;
    private String headers = null;

    public BP1116(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public void visit(SOAPOperation sOAPOperation, Object object, WSDLTraversalContext wSDLTraversalContext) {
        String string = sOAPOperation.getSoapActionURI();
        if (string == null) {
            if (!"".equals(this.action)) {
                this.result = "failed";
                this.failureDetailMessage = "\nHTTP headers:\n" + this.headers + "\nsoapAction:\n" + string;
            }
        } else if (!string.equals(this.action)) {
            this.result = "failed";
            this.failureDetailMessage = "\nHTTP headers:\n" + this.headers + "\nsoapAction:\n" + string;
        }
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            OperationSignature.OperationMatch operationMatch;
            Document document = entryContext.getMessageEntryDocument();
            this.headers = entryContext.getRequest().getHTTPHeaders();
            if (this.headers != null) {
                this.action = (String)HTTPUtils.getHttpHeaderTokens(this.headers, ":").get("SOAPAction");
            }
            if (this.action == null) {
                throw new AssertionNotApplicableException();
            }
            if (this.action.length() > 1 && this.action.charAt(0) == '\"' && this.action.charAt(this.action.length() - 1) == '\"') {
                this.action = this.action.substring(1, this.action.length() - 1);
            }
            if ((operationMatch = OperationSignature.matchOperation(document, null, this.validator.analyzerContext.getCandidateInfo().getBindings()[0], new TypesRegistry(this.validator.analyzerContext.getCandidateInfo().getWsdlDocument().getDefinitions(), this.validator), false)) != null) {
                WSDLTraversal wSDLTraversal = new WSDLTraversal();
                wSDLTraversal.setVisitor(this);
                wSDLTraversal.visitSOAPOperation(true);
                wSDLTraversal.traverse(operationMatch.getOperation());
            } else {
                this.result = "notApplicable";
            }
        }
        catch (Exception exception) {
            this.result = "notApplicable";
        }
        if (this.result == "failed" && this.failureDetailMessage != null) {
            this.failureDetail = this.validator.createFailureDetail(this.failureDetailMessage, entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

