/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.analyzer.AssertionPassException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;

public class BP4101
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP4101(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            Document document = entryContext.getMessageEntryDocument();
            if (document == null) {
                throw new AssertionNotApplicableException();
            }
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
            if (nodeList == null || nodeList.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            Node node = nodeList.item(0);
            NodeList nodeList2 = node.getChildNodes();
            if (nodeList2 == null || nodeList2.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node2;
                NamedNodeMap namedNodeMap = nodeList2.item(i).getAttributes();
                if (namedNodeMap == null || (node2 = namedNodeMap.getNamedItem(element.getPrefix() + ":" + "actor")) == null || node2.getNodeValue().equals("http://schemas.xmlsoap.org/soap/actor/next")) continue;
                throw new AssertionPassException();
            }
            this.result = "notApplicable";
        }
        catch (AssertionPassException assertionPassException) {
            this.failureDetail = this.validator.createFailureDetail(testAssertion.getDetailDescription(), entryContext);
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

