/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.OperationSignature;
import org.wsi.test.util.TypesRegistry;
import org.wsi.util.HTTPUtils;
import org.wsi.wsdl.WSDLUtils;

public class BP1318
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1318(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            TypesRegistry typesRegistry;
            Binding binding;
            OperationSignature.OperationMatch operationMatch;
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document document = entryContext.getMessageEntryDocument();
            Document document2 = entryContext.getRequestDocument();
            if (document == null || document2 == null) {
                throw new AssertionNotApplicableException();
            }
            String string = entryContext.getRequest().getHTTPHeaders();
            String string2 = null;
            if (string != null) {
                string2 = (String)HTTPUtils.getHttpHeaderTokens(string, ":").get("SOAPAction");
            }
            if ((operationMatch = OperationSignature.matchOperation(document2, string2, binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], typesRegistry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator))) == null) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = operationMatch.getOperation();
            if (!WSDLUtils.isRpcLiteral(operationMatch.getOperationStyle(), bindingOperation)) {
                throw new AssertionNotApplicableException();
            }
            NodeList nodeList = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body");
            if (nodeList == null || nodeList.getLength() == 0) {
                throw new AssertionNotApplicableException();
            }
            boolean bl = false;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                NodeList nodeList2 = element.getChildNodes();
                if (nodeList2 == null) continue;
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Element element2;
                    NodeList nodeList3;
                    if (nodeList2.item(j).getNodeType() != 1 || (nodeList3 = (element2 = (Element)nodeList2.item(j)).getChildNodes()) == null) continue;
                    for (int k = 0; k < nodeList3.getLength(); ++k) {
                        if (nodeList3.item(k).getNodeType() != 1) continue;
                        bl = true;
                        Element element3 = (Element)nodeList3.item(k);
                        if (element3.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle") == null) continue;
                        throw new AssertionFailException(entryContext.getMessageEntry().getMessage());
                    }
                }
            }
            if (!bl) {
                throw new AssertionNotApplicableException();
            }
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

