/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;

public class BP1316
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1316(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document document;
        if (this.validator.isOneWayResponse(entryContext) || (document = entryContext.getMessageEntryDocument()) == null) {
            this.result = "notApplicable";
        } else {
            NodeList nodeList = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Fault");
            if (nodeList == null || nodeList.getLength() == 0) {
                this.result = "notApplicable";
            } else {
                try {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        for (Node node = nodeList.item(i).getFirstChild(); node != null; node = node.getNextSibling()) {
                            if (node.getNodeType() != 1 || !node.getLocalName().equalsIgnoreCase("faultcode") && !node.getLocalName().equalsIgnoreCase("faultstring") && !node.getLocalName().equalsIgnoreCase("faultactor") && !node.getLocalName().equalsIgnoreCase("detail") || node.getNamespaceURI() == null) continue;
                            throw new AssertionFailException(entryContext.getMessageEntry().getMessage());
                        }
                    }
                }
                catch (AssertionFailException assertionFailException) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

