/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;

public class BP1307
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1307(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document document;
        if (this.validator.isOneWayResponse(entryContext) || (document = entryContext.getMessageEntryDocument()) == null) {
            this.result = "notApplicable";
        } else {
            NodeList nodeList = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "*");
            if (nodeList == null || nodeList.getLength() == 0) {
                this.result = "notApplicable";
            } else {
                try {
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        Element element = (Element)nodeList.item(i);
                        if (element.getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "encodingStyle") == null) continue;
                        throw new AssertionFailException(entryContext.getMessageEntry().getMessage());
                    }
                }
                catch (AssertionFailException assertionFailException) {
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

