/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class BP1301
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1301(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        String string = entryContext.getMessageEntry().getMessage();
        Object[] objectArray = this.getMustUnderstandAttributes(string);
        if (objectArray == null) {
            this.result = "notApplicable";
        } else {
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null && (objectArray[i].equals("1") || objectArray[i].equals("0"))) {
                    this.result = "passed";
                    continue;
                }
                this.result = "failed";
                this.failureDetail = this.validator.createFailureDetail("The SOAP mustUnderstand attribute was present  and its value was  " + objectArray[i], entryContext);
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private Object[] getMustUnderstandAttributes(String string) throws WSIException {
        if (string == null || string.trim().equals("")) {
            return null;
        }
        Document document = XMLUtils.parseXML(string);
        NodeList nodeList = document.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Header");
        if (nodeList.getLength() <= 0) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        Element element = (Element)nodeList.item(0);
        if (element == null) {
            return null;
        }
        NodeList nodeList2 = element.getChildNodes();
        boolean bl = false;
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            Node node = nodeList2.item(i);
            if (node.getNodeType() != 1) continue;
            bl = true;
            Attr attr = ((Element)node).getAttributeNodeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
            if (attr != null) {
                String string2 = attr.getNodeValue();
                vector.add(string2);
                continue;
            }
            this.result = "notApplicable";
        }
        if (!bl) {
            this.result = "notApplicable";
        }
        return vector.toArray();
    }

    public boolean isMustUnderstandFaultCode(Element element) {
        if (element == null) {
            return false;
        }
        String string = element.getFirstChild().getNodeValue().trim();
        if (string == null) {
            return false;
        }
        String string2 = element.getPrefix();
        String string3 = string.substring(0, string.indexOf(58));
        String string4 = string.substring(string.indexOf(58) + 1, string.length());
        if (string2 != null || string3 != null) {
            return string3.equals(string2) && (string4.equals("MustUnderstand") || string4.startsWith("MustUnderstand."));
        }
        return string.equals("MustUnderstand") || string4.startsWith("MustUnderstand.");
    }
}

