/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.BindingOperation;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.xml.XMLUtils;

public class BP1212
extends AssertionProcess {
    private final BaseMessageValidator validator;

    public BP1212(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document document = entryContext.getMessageEntryDocument();
            Element element = null;
            if (this.validator.isFault(document) || (element = this.validator.getSoapBodyChild(document)) == null) {
                throw new AssertionNotApplicableException();
            }
            QName qName = new QName(element.getNamespaceURI(), element.getLocalName());
            BindingOperation[] bindingOperationArray = this.validator.getMatchingBindingOps("rpc", this.validator.analyzerContext.getCandidateInfo().getBindings());
            BindingOperation bindingOperation = this.validator.getOperationMatch(entryContext.getEntry().getEntryType(), qName, bindingOperationArray);
            if (bindingOperation == null) {
                throw new AssertionNotApplicableException();
            }
            List list = null;
            List list2 = null;
            if (entryContext.getMessageEntry().getType().equals("request")) {
                list = bindingOperation.getOperation().getInput().getMessage().getOrderedParts(null);
                if (bindingOperation.getBindingInput() != null) {
                    list2 = bindingOperation.getBindingInput().getExtensibilityElements();
                }
            } else {
                list = bindingOperation.getOperation().getOutput().getMessage().getOrderedParts(null);
                if (bindingOperation.getBindingOutput() != null) {
                    list2 = bindingOperation.getBindingOutput().getExtensibilityElements();
                }
            }
            Vector vector = XMLUtils.getChildElements(element);
            List list3 = this.validator.orderPartNames(list, list2);
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (this.getPartsCount(vector, string) == 1) continue;
                throw new AssertionFailException("The name of wsdl:part is " + string);
            }
        }
        catch (AssertionNotApplicableException assertionNotApplicableException) {
            this.result = "notApplicable";
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private int getPartsCount(List list, String string) {
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            Element element = (Element)list.get(i);
            if (!element.getLocalName().equals(string)) continue;
            ++n;
        }
        return n;
    }
}

