/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.wsi.WSIException;
import org.wsi.test.analyzer.AssertionFailException;
import org.wsi.test.analyzer.AssertionNotApplicableException;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;
import org.wsi.test.util.OperationSignature;
import org.wsi.test.util.TypesRegistry;
import org.wsi.util.HTTPUtils;
import org.wsi.wsdl.WSDLUtils;
import org.wsi.xml.XMLTags;
import org.wsi.xml.XMLUtils;

public class BP1211
extends AssertionProcess
implements XMLTags {
    private final BaseMessageValidator validator;

    public BP1211(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        try {
            TypesRegistry typesRegistry;
            Binding binding;
            OperationSignature.OperationMatch operationMatch;
            if (this.validator.isOneWayResponse(entryContext)) {
                throw new AssertionNotApplicableException();
            }
            Document document = entryContext.getMessageEntryDocument();
            Document document2 = entryContext.getRequestDocument();
            Element element = null;
            if (this.validator.isFault(document) || (element = this.validator.getSoapBodyChild(document)) == null) {
                throw new AssertionNotApplicableException();
            }
            String string = entryContext.getRequest().getHTTPHeaders();
            String string2 = null;
            if (string != null) {
                string2 = (String)HTTPUtils.getHttpHeaderTokens(string, ":").get("SOAPAction");
            }
            if ((operationMatch = OperationSignature.matchOperation(document2, string2, binding = this.validator.analyzerContext.getCandidateInfo().getBindings()[0], typesRegistry = new TypesRegistry(this.validator.getWSDLDocument().getDefinitions(), this.validator))) == null) {
                throw new AssertionNotApplicableException();
            }
            BindingOperation bindingOperation = operationMatch.getOperation();
            if (!WSDLUtils.isRpcLiteral(operationMatch.getOperationStyle(), bindingOperation)) {
                throw new AssertionNotApplicableException();
            }
            Element element2 = XMLUtils.getFirstChild(element);
            while (element2 != null) {
                Attr attr = XMLUtils.getAttribute(element2, XMLTags.ATTR_XSI_NIL);
                if (attr != null && (attr.getValue().equals("1") || attr.getValue().equals("true"))) {
                    throw new AssertionFailException("The accessor name is " + element2.getNodeName());
                }
                element2 = XMLUtils.getNextSibling(element2);
            }
        }
        catch (AssertionFailException assertionFailException) {
            this.result = "failed";
            this.failureDetail = this.validator.createFailureDetail(assertionFailException.getMessage(), entryContext);
        }
        catch (Exception exception) {
            this.result = "notApplicable";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

