/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.profile.validator.impl.envelope;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wsi.WSIException;
import org.wsi.WSITag;
import org.wsi.test.profile.TestAssertion;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.impl.AssertionProcess;
import org.wsi.test.profile.validator.impl.BaseMessageValidator;
import org.wsi.test.report.AssertionResult;

public class BP1202
extends AssertionProcess
implements WSITag {
    private final BaseMessageValidator validator;

    public BP1202(BaseMessageValidator baseMessageValidator) {
        super(baseMessageValidator);
        this.validator = baseMessageValidator;
    }

    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        Document document = entryContext.getMessageEntryDocument();
        if (this.validator.isOneWayResponse(entryContext)) {
            this.result = "notApplicable";
        } else if (!this.validator.containsSoapBodyWithChild(document)) {
            this.result = "notApplicable";
        } else {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagNameNS(WSITag.ELEM_SOAP_BODY.getNamespaceURI(), WSITag.ELEM_SOAP_BODY.getLocalPart());
            if (nodeList.getLength() > 0) {
                Element element2 = (Element)nodeList.item(0);
                NodeList nodeList2 = element2.getChildNodes();
                for (int i = 0; i < nodeList2.getLength() && this.result == "passed"; ++i) {
                    String string;
                    Node node = nodeList2.item(i);
                    if (!(node instanceof Element) || (string = node.getNamespaceURI()) != null && string.length() != 0) continue;
                    this.result = "failed";
                    this.failureDetail = this.validator.createFailureDetail(entryContext.getMessageEntry().getMessage(), entryContext);
                }
            }
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }
}

