/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.monitor.config.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.wsi.test.monitor.config.Comment;
import org.wsi.test.monitor.config.Redirect;
import org.wsi.xml.XMLUtils;

public class RedirectImpl
implements Redirect {
    protected Comment comment;
    protected int listenPort;
    protected String host;
    protected String toProtocol;
    protected int toPort;
    protected String toHost;
    protected int maxConnections;
    protected int readTimeoutSeconds;

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment comment) {
        this.comment = comment;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public void setListenPort(int n) {
        this.listenPort = n;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        URL uRL;
        this.host = string;
        try {
            uRL = new URL(string);
            this.toProtocol = uRL.getProtocol();
            this.toHost = uRL.getHost();
            this.toPort = uRL.getPort();
            if (this.toPort == -1) {
                this.toPort = this.toProtocol.equalsIgnoreCase("http") ? 80 : 80;
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("The schemeAndHostPort option contains an invalid value: " + string);
        }
        if (uRL.getPath() != null && !uRL.getPath().equals("") || uRL.getQuery() != null && !uRL.getQuery().equals("")) {
            throw new IllegalArgumentException("The schemeAndHostPort option must contain only a scheme, host and port: " + string);
        }
    }

    public int getToPort() {
        return this.toPort;
    }

    public String getToHost() {
        return this.toHost;
    }

    public String getToProtocol() {
        return this.toProtocol;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int n) {
        this.maxConnections = n;
    }

    public int getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    public void setReadTimeoutSeconds(int n) {
        this.readTimeoutSeconds = n;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("    comment ................... " + this.comment);
        printWriter.println("    listenPort ................ " + this.listenPort);
        printWriter.println("    host ...................... " + this.cutHost(this.host));
        printWriter.println("    maxConnections ............ " + this.maxConnections);
        printWriter.println("    readTimeoutSeconds ........ " + this.readTimeoutSeconds);
        return stringWriter.toString();
    }

    private String cutHost(String string) {
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getPort() > -1 ? String.valueOf(uRL.getPort()) : "80";
            return uRL.getProtocol() + "://" + uRL.getHost() + ":" + string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    public String toXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = string;
        if (!string2.equals("") && !string2.endsWith(":")) {
            string2 = string2 + ":";
        }
        printWriter.println("        <" + string2 + "redirect" + ">");
        if (this.comment != null) {
            printWriter.println(this.comment.toXMLString(string2));
        }
        printWriter.print("          <" + string2 + "listenPort" + ">");
        printWriter.print(this.getListenPort());
        printWriter.println("</" + string2 + "listenPort" + ">");
        printWriter.print("          <" + string2 + "schemeAndHostPort" + ">");
        printWriter.print(XMLUtils.xmlEscapedString(this.getHost()));
        printWriter.println("</" + string2 + "schemeAndHostPort" + ">");
        printWriter.print("          <" + string2 + "maxConnections" + ">");
        printWriter.print(this.getMaxConnections());
        printWriter.println("</" + string2 + "maxConnections" + ">");
        printWriter.print("          <" + string2 + "readTimeoutSeconds" + ">");
        printWriter.print(this.getReadTimeoutSeconds());
        printWriter.println("</" + string2 + "readTimeoutSeconds" + ">");
        printWriter.println("        </" + string2 + "redirect" + ">");
        return stringWriter.toString();
    }
}

