/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.log.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Iterator;
import org.wsi.test.log.MessageEntry;
import org.wsi.test.log.MimePart;
import org.wsi.test.log.MimeParts;
import org.wsi.test.log.impl.MimePartsImpl;
import org.wsi.xml.XMLUtils;
import org.wsi.xml.dom.ElementLocation;

public class MessageEntryImpl
implements MessageEntry {
    protected String id;
    protected String conversationId;
    protected String type;
    protected String timestamp;
    protected String senderHostAndPort;
    protected String receiverHostAndPort;
    protected String message = "";
    protected String httpHeaders = "";
    protected int bom;
    protected String encoding = "";
    protected boolean isMimeContent = false;
    protected MimeParts mimeParts = new MimePartsImpl();
    protected ElementLocation elementLocation = null;

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(String string) {
        this.conversationId = string;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String string) {
        this.timestamp = string;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getSenderHostAndPort() {
        return this.senderHostAndPort;
    }

    public void setSenderHostAndPort(String string) {
        this.senderHostAndPort = string;
    }

    public String getReceiverHostAndPort() {
        return this.receiverHostAndPort;
    }

    public void setReceiverHostAndPort(String string) {
        this.receiverHostAndPort = string;
    }

    public String getMessage() {
        if (!this.isMimeContent) {
            return this.message;
        }
        if (this.mimeParts.getRootPart() == null) {
            return "";
        }
        return this.mimeParts.getRootPart().getContent();
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public int getBOM() {
        return this.bom;
    }

    public void setBOM(int n) {
        this.bom = n;
    }

    public String getHTTPHeaders() {
        return this.httpHeaders;
    }

    public void setHTTPHeaders(String string) {
        this.httpHeaders = string;
    }

    public ElementLocation getElementLocation() {
        return this.elementLocation;
    }

    public void setElementLocation(ElementLocation elementLocation) {
        this.elementLocation = elementLocation;
    }

    public String toString() {
        return this.toXMLString("wsi-log");
    }

    public String toXMLString(String string) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        String string2 = string;
        if (!string2.equals("") && !string2.endsWith(":")) {
            string2 = string2 + ":";
        }
        printWriter.print("<" + string2 + "messageEntry" + " ");
        printWriter.print("xsi:type=\"httpMessageEntry\" ");
        printWriter.print("ID=\"" + this.id + "\" ");
        printWriter.print("conversationID=\"" + this.conversationId + "\" ");
        printWriter.print("type=\"" + this.type + "\" ");
        printWriter.println("timestamp=\"" + this.timestamp + "\">");
        if (this.isMimeContent()) {
            printWriter.print("<" + string2 + "messageContentWithAttachments");
            if (this.bom != 0) {
                printWriter.print(" BOM=\"" + this.bom + "\"");
            }
            printWriter.print(">");
            Collection collection = this.mimeParts.getParts();
            if (!collection.isEmpty()) {
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    MimePart mimePart = (MimePart)iterator.next();
                    printWriter.print(mimePart.toXMLString(string));
                }
            }
            printWriter.println("</" + string2 + "messageContentWithAttachments" + ">");
        } else {
            printWriter.print("<" + string2 + "messageContent");
            if (this.bom != 0) {
                printWriter.print(" BOM=\"" + this.bom + "\"");
            }
            printWriter.print(">");
            printWriter.print(XMLUtils.xmlEscapedString(this.message));
            printWriter.println("</" + string2 + "messageContent" + ">");
        }
        printWriter.println("<" + string2 + "senderHostAndPort" + ">" + this.senderHostAndPort + "</" + string2 + "senderHostAndPort" + ">");
        printWriter.println("<" + string2 + "receiverHostAndPort" + ">" + this.receiverHostAndPort + "</" + string2 + "receiverHostAndPort" + ">");
        printWriter.print("<" + string2 + "httpHeaders" + ">");
        printWriter.print(XMLUtils.xmlEscapedString(this.httpHeaders));
        printWriter.println("</" + string2 + "httpHeaders" + ">");
        printWriter.println("</" + string2 + "messageEntry" + ">");
        return stringWriter.toString();
    }

    public boolean isMimeContent() {
        return this.isMimeContent;
    }

    public void setMimeContent(boolean bl) {
        this.isMimeContent = bl;
    }

    public MimeParts getMimeParts() {
        return this.mimeParts;
    }

    public void setMimeParts(MimeParts mimeParts) {
        this.mimeParts = mimeParts;
    }
}

