/*
 * Decompiled with CFR 0.152.
 */
package org.wsi.test.analyzer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.wsdl.WSDLException;
import org.wsi.WSIException;
import org.wsi.WSIFileNotFoundException;
import org.wsi.test.ToolInfo;
import org.wsi.test.analyzer.Analyzer;
import org.wsi.test.analyzer.AnalyzerContext;
import org.wsi.test.analyzer.ServiceReference;
import org.wsi.test.log.LogReader;
import org.wsi.test.log.MessageEntryHandler;
import org.wsi.test.profile.ProfileAssertionsReader;
import org.wsi.test.profile.validator.EntryContext;
import org.wsi.test.profile.validator.EnvelopeValidator;
import org.wsi.test.profile.validator.MessageValidator;
import org.wsi.test.profile.validator.UDDIValidator;
import org.wsi.test.profile.validator.WSDLValidator;
import org.wsi.test.report.ArtifactReference;
import org.wsi.test.report.Report;
import org.wsi.test.report.ReportArtifact;
import org.wsi.test.report.ReportContext;
import org.wsi.test.report.ReportWriter;
import org.wsi.test.report.impl.DefaultReporter;
import org.wsi.test.util.ArtifactType;
import org.wsi.util.WSIProperties;
import org.wsi.wsdl.WSDLDocument;

public class BasicProfileAnalyzer
extends Analyzer {
    public static final String TOOL_NAME = "Analyzer";
    protected WSDLDocument wsdlDocument = null;

    public BasicProfileAnalyzer(String[] stringArray) throws WSIException {
        super(stringArray, new ToolInfo(TOOL_NAME));
    }

    public BasicProfileAnalyzer(String[] stringArray, boolean bl) throws WSIException {
        super(stringArray, new ToolInfo(TOOL_NAME), bl);
    }

    public BasicProfileAnalyzer(List list) throws WSIException {
        super(list, new ToolInfo(TOOL_NAME));
    }

    public BasicProfileAnalyzer(List list, String string) throws WSIException {
        super(list, new ToolInfo(TOOL_NAME));
        try {
            if (string != null) {
                this.wsdlDocument = new WSDLDocument(string);
            }
        }
        catch (WSDLException wSDLException) {
            throw new WSIException(wSDLException.getMessage(), wSDLException);
        }
    }

    public int validateConformance() throws WSIException {
        int n = 0;
        Report report = null;
        ReportArtifact reportArtifact = null;
        String string = null;
        this.analyzerContext = new AnalyzerContext(new ServiceReference(this.getAnalyzerConfig()));
        try {
            ProfileAssertionsReader profileAssertionsReader = this.documentFactory.newProfileAssertionsReader();
            this.profileAssertions = profileAssertionsReader.readProfileAssertions(this.getAnalyzerConfig().getTestAssertionsDocumentLocation());
            report = this.documentFactory.newReport();
            report.setLocation(this.getAnalyzerConfig().getReportLocation());
            ReportContext reportContext = new ReportContext("WS-I Basic Profile Conformance Report.", this.profileAssertions, this);
            report.setReportContext(reportContext);
            ReportWriter reportWriter = this.documentFactory.newReportWriter();
            reportWriter.setWriter(this.getAnalyzerConfig().getReportLocation());
            this.reporter = new DefaultReporter(report, reportWriter);
            this.reporter.startReport();
            reportArtifact = this.setCurrentArtifact(ArtifactType.ARTIFACT_TYPE_DISCOVERY);
            string = this.validateUDDI(reportArtifact, this.factory.newUDDIValidator());
            if (string == null && this.getAnalyzerConfig().isWSDLReferenceSet()) {
                string = this.getAnalyzerConfig().getWSDLLocation();
            }
            this.reporter.endCurrentArtifact();
            reportArtifact = this.setCurrentArtifact(ArtifactType.ARTIFACT_TYPE_DESCRIPTION);
            this.wsdlDocument = this.validateWSDL(reportArtifact, this.factory.newWSDLValidator(), string, this.wsdlDocument);
            if (this.wsdlDocument == null && this.getAnalyzerConfig().isWSDLReferenceSet()) {
                throw new WSIException(this.messageList.getMessage("config05", "WSDL document was either not found or could not be processed."));
            }
            this.reporter.endCurrentArtifact();
            reportArtifact = this.setCurrentArtifact(ArtifactType.ARTIFACT_TYPE_MESSAGE);
            this.validateMessages(reportArtifact, this.factory.newMessageValidator(), this.wsdlDocument);
            this.reporter.endCurrentArtifact();
            if (!this.profileAssertions.getTADName().equals("Basic Profile Test Assertions")) {
                reportArtifact = this.setCurrentArtifact(ArtifactType.ARTIFACT_TYPE_ENVELOPE);
                this.validateEnvelopes(reportArtifact, this.factory.newEnvelopeValidator(), this.wsdlDocument);
                this.reporter.endCurrentArtifact();
            }
            this.reporter.finishReport();
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            String string2 = this.messageList.getMessage("error03", "The conformance validation process failed.");
            if (this.reporter != null) {
                printWriter.println(string2);
                printWriter.println(this.messageList.getMessage("exception01", "Exception: ") + exception.getClass().getName());
                exception.printStackTrace(printWriter);
                this.reporter.finishReportWithError(stringWriter.toString());
            }
            if (exception instanceof WSIException) {
                throw (WSIException)exception;
            }
            throw new WSIException(string2, exception);
        }
        if (report != null) {
            n = report.getSummaryResult().equals("passed") ? 0 : 1;
        }
        return n;
    }

    private String validateUDDI(ReportArtifact reportArtifact, UDDIValidator uDDIValidator) throws WSIException {
        String string = null;
        uDDIValidator.init(this.analyzerContext, this.profileAssertions.getArtifact("discovery"), reportArtifact, this.getAnalyzerConfig().getUDDIReference(), this.reporter);
        if (this.getAnalyzerConfig().isUDDIReferenceSet()) {
            string = uDDIValidator.validate();
            uDDIValidator.cleanup();
        } else {
            uDDIValidator.setAllMissingInput();
        }
        return string;
    }

    private WSDLDocument validateWSDL(ReportArtifact reportArtifact, WSDLValidator wSDLValidator, String string, WSDLDocument wSDLDocument) throws WSIException {
        WSDLDocument wSDLDocument2 = null;
        wSDLValidator.init(this.analyzerContext, this.profileAssertions.getArtifact("description"), reportArtifact, string, wSDLDocument, this.reporter);
        if (string != null || wSDLDocument != null) {
            wSDLDocument2 = wSDLValidator.validate();
            wSDLValidator.cleanup();
        } else {
            wSDLValidator.setAllMissingInput();
        }
        return wSDLDocument2;
    }

    private void validateMessages(ReportArtifact reportArtifact, MessageValidator messageValidator, WSDLDocument wSDLDocument) throws WSIException {
        messageValidator.init(this.analyzerContext, this.profileAssertions.getArtifact("message"), reportArtifact, wSDLDocument, this.reporter);
        if (this.getAnalyzerConfig().getLogLocation() != null) {
            LogReader logReader = this.documentFactory.newLogReader();
            MessageProcessor messageProcessor = new MessageProcessor(messageValidator);
            logReader.readLog(this.getAnalyzerConfig().getLogLocation(), (MessageEntryHandler)messageProcessor);
            messageValidator.cleanup();
        } else {
            messageValidator.setAllMissingInput();
        }
    }

    private void validateEnvelopes(ReportArtifact reportArtifact, EnvelopeValidator envelopeValidator, WSDLDocument wSDLDocument) throws WSIException {
        envelopeValidator.init(this.analyzerContext, this.profileAssertions.getArtifact("envelope"), reportArtifact, wSDLDocument, this.reporter);
        if (this.getAnalyzerConfig().getLogLocation() != null) {
            LogReader logReader = this.documentFactory.newLogReader();
            EnvelopeProcessor envelopeProcessor = new EnvelopeProcessor(envelopeValidator);
            logReader.readLog(this.getAnalyzerConfig().getLogLocation(), (MessageEntryHandler)envelopeProcessor);
            envelopeValidator.cleanup();
        } else {
            envelopeValidator.setAllMissingInput();
        }
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        block6: {
            n = 0;
            BasicProfileAnalyzer basicProfileAnalyzer = null;
            try {
                System.setProperty("javax.xml.parsers.DocumentBuilderFactory", WSIProperties.getProperty("javax.xml.parsers.DocumentBuilderFactory"));
                System.setProperty("org.uddi4j.TransportClassName", WSIProperties.getProperty("org.uddi4j.TransportClassName"));
                basicProfileAnalyzer = new BasicProfileAnalyzer(stringArray);
                n = ((Analyzer)basicProfileAnalyzer).validateConformance();
                basicProfileAnalyzer.printMessage("created01", null, "Conformance report has been created.");
            }
            catch (Exception exception) {
                String string;
                String string2;
                String string3;
                n = 1;
                boolean bl = true;
                if (exception instanceof WSIFileNotFoundException || exception instanceof IllegalArgumentException) {
                    string3 = "error01";
                    string2 = "Analyzer Error:";
                    string = exception.getMessage();
                } else {
                    string3 = "error02";
                    string2 = "Analyzer Stopped By Exception:";
                    string = exception.toString();
                }
                if (basicProfileAnalyzer != null) {
                    basicProfileAnalyzer.printMessage(string3, string, string2);
                } else {
                    Analyzer.staticPrintMessage(string3, string, string2);
                }
                if (basicProfileAnalyzer == null || basicProfileAnalyzer.getAnalyzerConfig() == null || !basicProfileAnalyzer.getAnalyzerConfig().getVerboseOption()) break block6;
                BasicProfileAnalyzer.dump(exception);
            }
        }
        System.exit(n);
    }

    protected ReportArtifact setCurrentArtifact(ArtifactType artifactType) throws WSIException {
        ReportArtifact reportArtifact = this.reporter.createArtifact();
        reportArtifact.setType(artifactType);
        this.reporter.setCurrentArtifact(reportArtifact);
        return reportArtifact;
    }

    public static void dump(Throwable throwable) {
        Throwable throwable2;
        while (throwable instanceof WSIException && (throwable2 = ((WSIException)throwable).getTargetException()) != null) {
            throwable = throwable2;
        }
        throwable.printStackTrace();
    }

    class EnvelopeProcessor
    implements MessageEntryHandler {
        EnvelopeValidator envelopeValidator = null;

        EnvelopeProcessor(EnvelopeValidator envelopeValidator) {
            this.envelopeValidator = envelopeValidator;
        }

        public void processArtifactReference(ArtifactReference artifactReference) throws WSIException {
            BasicProfileAnalyzer.this.reporter.addArtifactReference(artifactReference);
        }

        public void processLogEntry(EntryContext entryContext) throws WSIException {
            this.envelopeValidator.validate(entryContext);
        }
    }

    class MessageProcessor
    implements MessageEntryHandler {
        MessageValidator messageValidator = null;

        MessageProcessor(MessageValidator messageValidator) {
            this.messageValidator = messageValidator;
        }

        public void processArtifactReference(ArtifactReference artifactReference) throws WSIException {
            BasicProfileAnalyzer.this.reporter.addArtifactReference(artifactReference);
        }

        public void processLogEntry(EntryContext entryContext) throws WSIException {
            this.messageValidator.validate(entryContext);
        }
    }
}

