/*
 * Decompiled with CFR 0.152.
 */
package com.teamdev.jxbrowser.mozilla.ssl;

import com.teamdev.jxbrowser.gecko.events.impl.nsIWebProgressAdapter;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOM;
import com.teamdev.jxbrowser.gecko.xpcom.XPCOMManager;
import com.teamdev.jxbrowser.gecko.xpcom.util.FlagUtil;
import com.teamdev.jxbrowser.mozilla.MozillaHttpSecurity;
import com.teamdev.jxbrowser.mozilla.ssl.SSLCertificateManager;
import com.teamdev.jxbrowser.security.HttpSecurityAction;
import com.teamdev.jxbrowser.security.HttpSecurityHandler;
import com.teamdev.jxbrowser.security.SecurityProblem;
import java.net.URI;
import java.util.EnumSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.mozilla.interfaces.nsIHttpChannel;
import org.mozilla.interfaces.nsIRecentBadCertsService;
import org.mozilla.interfaces.nsIRequest;
import org.mozilla.interfaces.nsIWebProgress;
import org.mozilla.interfaces.nsIX509Cert;
import org.mozilla.xpcom.XPCOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BadCertificateListener
extends nsIWebProgressAdapter {
    private static final Logger a = LoggerFactory.getLogger(BadCertificateListener.class);
    private final MozillaHttpSecurity b;

    public BadCertificateListener(MozillaHttpSecurity mozillaHttpSecurity) {
        this.b = mozillaHttpSecurity;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onSecurityChange(nsIWebProgress object, nsIRequest object2, long l2) {
        HostPortHolder hostPortHolder;
        void var3_4;
        if (FlagUtil.checkFlag((long)var3_4, (long)2L)) {
            a.debug("The data corresponding to the request was received over a secure channel.");
        } else if (FlagUtil.checkFlag((long)var3_4, (long)1L)) {
            a.debug("Unknown security state. The request is being loaded as part of a page in which some content was received over an insecure channel.");
        } else if (FlagUtil.checkFlag((long)var3_4, (long)4L)) {
            a.debug("The data corresponding to the request was received over an insecure channel.");
            try {
                object = (nsIHttpChannel)object2.queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
                if (object.getRequestSucceeded()) {
                    return;
                }
            }
            catch (XPCOMException xPCOMException) {
                a.debug("Called before the response has been received.");
            }
        }
        object = object2.getName();
        a.debug("Changing certificate approve process.");
        object = URI.create((String)object);
        if (this.b.isInApproveCertificateProcessForURL((URI)object)) return;
        a.debug("Approving certificate.");
        Object object3 = object;
        int n2 = 443;
        if (-1 != ((URI)object3).getPort()) {
            n2 = ((URI)object3).getPort();
        }
        HostPortHolder hostPortHolder2 = hostPortHolder = new HostPortHolder(((URI)object3).getHost(), n2);
        Object object4 = EnumSet.noneOf(SecurityProblem.class);
        nsIRecentBadCertsService nsIRecentBadCertsService2 = (nsIRecentBadCertsService)XPCOMManager.getInstance().getService("@mozilla.org/security/recentbadcerts;1", nsIRecentBadCertsService.class);
        Object object5 = nsIRecentBadCertsService2.getRecentBadCert(hostPortHolder2.getAddress());
        if (object5 != null) {
            if (object5.getIsUntrusted()) {
                object4.add((SecurityProblem)SecurityProblem.NOT_TRUSTED_CERTIFICATE);
            }
            if (object5.getIsDomainMismatch()) {
                object4.add((SecurityProblem)SecurityProblem.INVALID_CERTIFICATE_NAME);
            }
            if (object5.getIsNotValidAtThisTime()) {
                object4.add((SecurityProblem)SecurityProblem.INVALID_CERTIFICATE_DATE);
            }
        }
        if ((object5 = object4).isEmpty()) {
            a.debug("No certificate problems for the given " + hostPortHolder);
            return;
        }
        HttpSecurityAction[] httpSecurityActionArray = new HttpSecurityAction[1];
        XPCOM.invokeAtAWTAndWait((Runnable)new Runnable(this, httpSecurityActionArray, (Set)object5){
            private /* synthetic */ HttpSecurityAction[] a;
            private /* synthetic */ Set b;
            private /* synthetic */ BadCertificateListener c;
            {
                this.c = badCertificateListener;
                this.a = httpSecurityActionArray;
                this.b = set;
            }

            public void run() {
                HttpSecurityHandler httpSecurityHandler = this.c.b.getHandler();
                if (httpSecurityHandler != null) {
                    this.a[0] = httpSecurityHandler.onSecurityProblem(this.b);
                }
            }
        });
        if (HttpSecurityAction.ABORT != httpSecurityActionArray[0]) {
            if (HttpSecurityAction.CONTINUE == httpSecurityActionArray[0] && !object5.isEmpty()) {
                this.a((URI)object, hostPortHolder, (Set<SecurityProblem>)object5);
                return;
            }
            if (HttpSecurityAction.DEFAULT != httpSecurityActionArray[0] || object5.isEmpty()) return;
            a.debug("Approving certificate by default.");
            object4 = object5;
            BadCertificateListener badCertificateListener = this;
            int[] nArray = new int[1];
            XPCOM.invokeAtAWTAndWait((Runnable)new Runnable(badCertificateListener, (Set)object4, nArray){
                private /* synthetic */ Set a;
                private /* synthetic */ int[] b;
                {
                    this.a = set;
                    this.b = nArray;
                }

                public void run() {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("<html><body>");
                    stringBuilder.append("<strong>");
                    stringBuilder.append("This page may not be secure!<br/><br/>");
                    stringBuilder.append("</strong>");
                    stringBuilder.append("Certificate errors:");
                    stringBuilder.append("<ol>");
                    for (SecurityProblem securityProblem : this.a) {
                        stringBuilder.append("<li>");
                        stringBuilder.append(securityProblem.getDefaultDescription());
                        stringBuilder.append("</li>");
                    }
                    stringBuilder.append("</ol>");
                    stringBuilder.append("<strong>You need to approve or reject loading of this page?</strong>");
                    stringBuilder.append("</body></html>");
                    Object[] objectArray = new Object[]{"Approve", "Reject"};
                    this.b[0] = JOptionPane.showOptionDialog(null, stringBuilder.toString(), "Security Issue", 0, 2, null, objectArray, objectArray[1]);
                }
            });
            if (nArray[0] == 0) {
                this.a((URI)object, hostPortHolder, (Set<SecurityProblem>)object5);
                return;
            }
        }
        this.b.reject();
    }

    private void a(URI uRI, HostPortHolder hostPortHolder, Set<SecurityProblem> set) {
        Object object;
        HostPortHolder hostPortHolder2 = hostPortHolder;
        Object object2 = (nsIRecentBadCertsService)XPCOMManager.getInstance().getService("@mozilla.org/security/recentbadcerts;1", nsIRecentBadCertsService.class);
        if ((object2 = object2.getRecentBadCert(hostPortHolder2.getAddress())) == null) {
            a.debug("No SSL cert was recently seen OR good cert was seen for the given " + hostPortHolder2.getAddress());
            object = null;
        } else {
            object = hostPortHolder2 = object2.getServerCert();
        }
        if (object != null) {
            object2 = new SSLCertificateManager();
            object2.validityOverride(SSLCertificateManager.Trust.TRUSTED, hostPortHolder.host, hostPortHolder.port, (nsIX509Cert)hostPortHolder2, set);
            this.b.approveCertificateForURL(uRI);
        }
    }

    private static class HostPortHolder {
        public final String host;
        public final int port;

        private HostPortHolder(String string, int n2) {
            this.host = string;
            this.port = n2;
        }

        public String getAddress() {
            return this.host + ':' + this.port;
        }
    }
}

